/***************************************************************************
 *                                                                         *
 *   POLLSYN.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll Synthesis Class.                                                 *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "pollsyn.h"
#include "dnfmgr.h"
#include "cstring.h"
#include "pollmsg.h"
#include "ahutil.h"
#include "majorbbs.h"

#define FILREV "$Revision: 18 $"
#define FRAMECOOKIE "pollframe"    // name of poll "frame" cookie

// Dynafile defs

dnfStep dnfNoFrameSteps[]={
     dnfStep(DNFMAPEND)
};
dnfStep dnfFrameSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap defnfMap(PPFIX "indexn.htm","No Frames Default",dnfNoFrameSteps);
dnfMap deffMap(PPFIX "indexf.htm","Frames Default",dnfFrameSteps);

// class method defs

MARKSOURCE(pollsyn);

pollSynthesis::pollSynthesis(       // default constructor
               acthSession *_ses):
               acthSynthesis(_ses),
               m_usrPtr(NULL),
               m_dnfPtr(NULL),
               m_pAPI(NULL),
               m_pTvb(NULL),
               m_pPoll(NULL),
               m_pQues(NULL),
               m_checkedFramePref(FALSE),
               m_framesOn(FALSE),
               m_errorStatus(FALSE)
{
     m_onErrorBuf[0]='\0';
     m_onSuccessBuf[0]='\0';
     m_pAPI=new pollAPI();
     m_pTvb=new pollVar();
     m_cyc.setSlice(timslc);
}

pollSynthesis::~pollSynthesis()     // destructor
{
     if (m_dnfPtr != NULL) {
          delete m_dnfPtr;
          m_dnfPtr=NULL;
     }
     if (m_pAPI != NULL) {
          delete m_pAPI;
          m_pAPI=NULL;
     }
     if (m_pTvb != NULL) {
          delete m_pTvb;
          m_pTvb=NULL;
     }
}

const CHAR *
pollSynthesis::getSynthDir()       // get synthesis directory
{
     return(PPFIX);
}

ACTHCODE
pollSynthesis::initRequest()
{
     CHAR *ckptr;

     if ((strchr(ses->urlsfx(),'.')) == NULL) {
          if (ses->forceDir()) {
               return(ACTHDONE);
          }
     }
     m_pTvb->clearAllVars();
     if ((ckptr=getCookie(FRAMECOOKIE,ses)) != NULL && sameas(ckptr,"1")) {
          m_pTvb->setTargetVbs();
     }
     getRedirects();
     if (m_errorStatus) {
          setErrorVbs();
     }
     return(ACTHMORE);
}

ACTHCODE
pollSynthesis::isUserOK()          // check some basic stuff about user and session
{
     if ((m_usrPtr=ses->getUser()) == NULL) {
          return(ACTHNOANON);
     }
     if (!hasAgentAccess()) {
          return(ACTHFORBID);
     }
     return(initRequest());
}

ACTHCODE
pollSynthesis::proceed()           // proceed entry point
{
     ACTHCODE retval;

     if (ses->urlargc() > 0 && strchr(ses->urlargv(0),'.') == NULL) {
          return(ACTHNOTFND);
     }
     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }
     if (!m_checkedFramePref) {
          m_framesOn=pfrmset;                            // global setting
          if (m_pAPI->userFramesOn(m_usrPtr->userid())) {  // user preference
               m_framesOn=TRUE;
          }
          else if (m_pAPI->userFramesOff(m_usrPtr->userid())) {
               m_framesOn=FALSE;
          }
          GETPARAMVAL("useframes");                      // URL param
          if (m_pValBuf[0] != '\0') {
               if (sameas(m_pValBuf,"0")) {
                    m_framesOn=FALSE;
               }
               else if (sameas(m_pValBuf,"1")) {
                    m_framesOn=TRUE;
               }
               else if (sameas(m_pValBuf,"~")) {
                    m_framesOn=!(m_framesOn);
               }
               else if (sameas(m_pValBuf,"0 set")) {
                    m_pAPI->setFrames((m_framesOn=FALSE),m_usrPtr->userid());
               }
               else if (sameas(m_pValBuf,"1 set")) {
                    m_pAPI->setFrames((m_framesOn=TRUE),m_usrPtr->userid());
               }
               else if (sameas(m_pValBuf,"~ set")) {
                    if (m_framesOn) {
                         m_pAPI->setFrames((m_framesOn=FALSE),m_usrPtr->userid());
                    }
                    else {
                         m_pAPI->setFrames((m_framesOn=TRUE),m_usrPtr->userid());
                    }
               }
          }
          m_checkedFramePref=TRUE;
     }
     if (m_dnfPtr == NULL) {
          if (m_framesOn) {
               setCookie(FRAMECOOKIE,"1",NULL,NULL,NULL,FALSE,ses);
               if (handleDynaResp(FALSE,NULL,&deffMap) == ACTHDONE) {
                    return(ACTHDONE);
               }
          }
          else {
               setCookie(FRAMECOOKIE,"0",NULL,NULL,NULL,FALSE,ses);
               if (handleDynaResp(FALSE,NULL,&defnfMap) == ACTHDONE) {
                    return(ACTHDONE);
               }
          }
     }
     ASSERT(m_dnfPtr != NULL);
     if (m_framesOn) {
          m_pTvb->setTargetVbs();
     }
     dnfSetTemplateTvb(m_dnfPtr);
     if (m_cyc.start()) {
          do {
               retval=dynafile();
          } while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}

VOID
pollSynthesis::getRedirects()      // get onerror/onsuccess params
{
     ses->param("onerror",m_onErrorBuf,URLSIZ);
     ses->param("onsuccess",m_onSuccessBuf,URLSIZ);
}

ACTHCODE
pollSynthesis::dynafile()          // dynafile
{
     ASSERT(m_dnfPtr != NULL);

     ACTHCODE retval=ACTHMORE;

     switch(m_dnfPtr->process()) {
     case DNFEND:
          retval=ACTHDONE;
          break;
     }
     return(retval);
}

bool
pollSynthesis::hasAgentAccess()    // does user have access?
{
     ASSERT(m_usrPtr != NULL);

     if (m_usrPtr->hasKey(hpnqkey)) {
          return(TRUE);
     }
     return(FALSE);
}

VOID
pollSynthesis::getHandler(         // get dnfHandler
bool error,
dnfMap *defMap)
{
     string dir;
     dir+=getSynthDir();
     if (error) {
          dir+=m_onErrorBuf;
     }
     else {
          dir+=m_onSuccessBuf;
     }
     dnfMap *dm=dnfGetMap(defMap,dir.c_str());
     m_dnfPtr=new dnfHandler(*dm,bout);
}

VOID
pollSynthesis::setError(           // set error text variables
INT messageOpt,                    // given message opt
const CHAR *arg1,                  // argument for prfmsg
const CHAR *arg2,                  // argument for prfmsg
SHORT qnum)                        // given question number
{
     setmbk(pAHmsg);
     clrprf();
     if (arg1 != NULL && arg2 != NULL) {
          prfmsg(messageOpt,arg1,arg2);
     }
     else if (arg1 != NULL) {
          prfmsg(messageOpt,arg1);
     }
     else {
          prfmsg(messageOpt);
     }
     m_errorStatus=TRUE;
     m_errMessage=stpans(prfbuf);
     m_errQid=qnum;
     setErrorVbs();
     rstmbk();
}

VOID
pollSynthesis::setErrorVbs()       // set up error text variables
{
     if (m_errQid != -1) {
          t_ErrQID=m_errQid;
     }
     t_ErrMessage=m_errMessage;
}

ACTHCODE
pollSynthesis::handleDynaResp(     // handle response
bool error,                        // did error occur?
dnfMap *errorMap,                  // our error map
dnfMap *successMap)                // our success map
{
     if (error) {
          if (m_onErrorBuf[0] != '\0') {
               if (isURLTemplate(m_onErrorBuf)) {
                    ses->redirect(m_onErrorBuf);
                    return(ACTHDONE);
               }
               else if (errorMap != NULL) {
                    getHandler(TRUE,errorMap);
                    return(ACTHMORE);
               }
          }
          ASSERT(errorMap != NULL);
          m_dnfPtr=dnfCreateHandlerURL(ses,errorMap,PPFIX);
     }
     else {
          if (m_onSuccessBuf[0] != '\0') {
               if (isURLTemplate(m_onSuccessBuf)) {
                    ses->redirect(m_onSuccessBuf);
                    return(ACTHDONE);
               }
               else if (successMap != NULL) {
                    getHandler(FALSE,successMap);
                    return(ACTHMORE);
               }
          }
          ASSERT(successMap != NULL);
          m_dnfPtr=dnfCreateHandlerURL(ses,successMap,PPFIX);
     }
     return(ACTHMORE);
}

