/***************************************************************************
 *                                                                         *
 *   POLLAGT.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll Agent Class.                                                     *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "pollagt.h"
#include "pollsyn.h"
#include "dlsyn.h"
#include "filesyn.h"
#include "listsyn.h"
#include "majorbbs.h"
#include "looksyn.h"
#include "ressyn.h"
#include "takesyn.h"

#define URLIS(x) sameas(ses->urlargv(0),x)

pollAgent *pAgent;                  // pointer to poll agent
VOID delAgent(VOID);                // delete agent

MARKSOURCE(pollagt);

pollAgent::pollAgent() : acthAgent("AH P&Qs","polls")  // default constructor
{
     init__galpnq();
     registerAgent(acthVersion);
     m_pMsg=new pollMsg();
     m_pAPI=new pollAPI();
     m_pAPI->initMaps();
     oldMod=pollModified;
     pollModified=updateMap;
     delete m_pAPI;
     hook_finalshutdown(delAgent);
}

pollAgent::~pollAgent()            // destructor
{
     delete m_pMsg;
}

acthSynthesis *                    // synth obj
pollAgent::newSynthesis(           // return a new synthesis object
acthSession *ses)                  // session object
{
     pollSynthesis *pSynth=NULL;

     if (ses->urlargc() >= 1) {
          if (URLIS("download")) {
               pSynth=new downloadSynthesis(ses);
          }
          else if (URLIS("file")) {
               pSynth=new fileSynthesis(ses);
          }
          else if (URLIS("list")) {
               pSynth=new listSynthesis(ses);
          }
          else if (URLIS("look-up")) {
               pSynth=new lookupSynthesis(ses);
          }
          else if (URLIS("results")) {
               pSynth=new resultsSynthesis(ses);
          }
          else if (URLIS("take")) {
               pSynth=new takeSynthesis(ses);
          }
     }
     if (pSynth == NULL) {
          pSynth=new pollSynthesis(ses);
     }
     return(pSynth);
}

extern "C" VOID EXPORT             // init our agent
init__galpnqah(VOID)
{
     pAgent=new pollAgent;
}

VOID
delAgent(                          // delete our agent
VOID)
{
     delete pAgent;
}

