/**************************************************************************
 *                                                                         *
 *   POLL.H                                                                *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll Class.                                                           *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __POLL_H
#define __POLL_H

#pragma option -w-par
#define _RWSTDLL
#undef min(a,b)
#undef max(a,b)

#include <map>
using namespace std;

#include "gcspsrv.h"
#include "galpnqh.h"
#include "question.h"
#include <cstring>

#define STAT_NEW   0               // new poll
#define STAT_DONE  1               // poll is completed
#define STAT_DEL   2               // poll tagged 4 delete
#define STAT_MAINT 3               // poll is being maintained
#define PERCSIZ    5               // max size of percentage string

#define URLSIZ     1024            // maximum size of URL

typedef std::map<SHORT, question *, less<SHORT> > QUESMAP, *PQUESMAP;

class poll {                       // Class objectifies a "poll"
public:

     poll();                       // default constructor

     poll(                         // constructor
     const CHAR *pollname);        // given poll to objectify

     ~poll();                      // destructor

     VOID
     initPoll();                   // set up some default stuff

     bool
     create();                     // create the poll

     bool
     load();                       // load poll data from disk

     bool
     update();                     // update poll data

     VOID
     tag4delete();                 // tag poll 4 delete

     SHORT
     getAccessAttrib();            // get access attribute (SHOW, DIM etc.)

     SHORT
     getAnswerType();              // get answer type (YES/NO, T/F etc.)

     USHORT
     getCloseDate();               // get closing date of poll

     USHORT
     getCreateDate();              // get creation date of poll

     const CHAR *
     getDescription();             // get description of poll

     const CHAR *
     getGrantClass();              // get class to grant

     LONG
     getGrantCredits();            // get credits to grant

     const CHAR *
     getGrantFile();               // get file to grant (w/ path if applicable)

     const CHAR *
     getGrantFileName();           // get file to grant (just name)

     const CHAR *
     getGrantKey();                // get key to grant

     const CHAR *
     getLookupKey();               // get key required for lookup

     const CHAR *
     getLogonKey();                // get the key required for logon stuff

     const CHAR *
     getName();                    // get the name of the poll

     SHORT
     getPriority();                // get the priority (ASK, INSIST etc.)

     question *                    // NULL if not found
     getQuestion(                  // get question object
     SHORT number);                // given question number

     VOID
     emptyMap();                   // clear out map

     bool
     isQuestion(                   // is this a valid question?
     SHORT number);                // the question number

     bool
     firstOpenQues(                // get first "unused" question
     SHORT *qnum);                 // pointer to question number

     bool
     isClosed();                   // is this poll closed?

     const CHAR *
     getResultKey();               // get results key

     SHORT
     getStorageMethod();           // get storage method (BTRIEVE, NONE etc.)

     const CHAR *
     getTakeKey();                 // get key required to take

     SHORT
     getFlags();                   // get flags

     SHORT
     getType();                    // get type (POLL or QUESTIONNAIRE)

     bool
     getSaveBranch();              // get whether to save branches

     VOID
     setAccessAttrib(              // set access attribute
     SHORT attrib);                // the attribute

     VOID
     setAnswerType(                // set the answer type
     SHORT type);                  // the answer type

     VOID
     setCloseDate(                 // set the closing date
     USHORT date);                 // the closing date

     VOID
     setCreateDate(                // set the create date
     USHORT date);                 // the create date

     VOID
     setDescription(               // set the description
     const CHAR *description);     // the description

     VOID
     setGrantClass(                // set class to grant
     const CHAR *cls);             // the class

     VOID
     setGrantCredits(              // set credits to grant
     LONG credits);                // credits

     VOID
     setGrantFile(                 // set file to grant
     const CHAR *filename);        // path and filename

     VOID
     setLookupKey(                 // set lookup key
     const CHAR *key);             // the key

     VOID
     setTakeKey(                   // set take key
     const CHAR *key);             // the key

     VOID
     setResultsKey(                // set results key
     const CHAR *key);             // the key

     VOID
     setLogonKey(                  // set the logon key
     const CHAR *key);             // the key

     VOID
     setGrantKey(                  // set grant key
     const CHAR *key);             // the key

     VOID
     setName(                      // set name
     const CHAR *pollname);        // the poll name

     VOID
     setPriority(                  // set priority
     SHORT priority);              // the priority

     VOID
     setStorageMethod(             // set storage method
     SHORT method);                // the method

     VOID
     setFlags(                     // set flags
     SHORT flags);                 // the flags

     VOID
     setSaveBranch(                // set whether to save branches
     bool save);                   // save?

     VOID
     setType(                      // set the type of poll
     SHORT type);                  // type

     bool
     isComplete(                   // has poll been completed?
     const CHAR *userid);          // userid to check

     VOID
     finishedPoll(                 // user has finished poll - update status
     const CHAR *userid);          // userid

     SHORT
     getTalliedAnswers(            // get tallied answers for question
     SHORT qnumber,                // the question
     SHORT anaser);

     const CHAR *
     getTalliedPercent(            // get tallied percentage for question
     SHORT qnumber,                // the question
     SHORT answer);

     SHORT
     getTalliedTotal(              // get total answers for question
     SHORT qnumber);               // the question

     bool
     nextTallied(                  // get the next tallied question
     SHORT start,                  // question to start at
     SHORT *qtally);               // question number

     bool
     prevTallied(                  // get the previous tallied question
     SHORT start,                  // question to start at
     SHORT *qtally);               // question number

     bool
     isTallied(                    // check if given qnumber is tallied
     SHORT qnumber);

     bool
     nextLookup(                   // is there another question to lookup
     const CHAR *userid,           // user to lookup
     SHORT start,                  // the start
     SHORT *qlook);                // where to put the question to lookup

     bool
     prevLookup(                   // is there a previous question to lookup
     const CHAR *userid,           // userid to lookup
     SHORT start,                  // the start
     SHORT *qlook);                // where to put question to lookup

     bool
     canLookup(                    // can we lookup this question?
     const CHAR *userid,           // userid to lookup
     SHORT qnumber);               // the question number

     const struct polldata
     getPollData();                // get poll data struct

     SHORT
     getStatus(                    // get poll status
     const CHAR *userid);          // userid in question

     VOID
     setPollData(                  // set poll data - with struct
     struct polldata pd);          // passed struct

     bool
     pollUpdated();                // has poll been updated?

     string
     getFileLink();                // get link for file

     VOID
     grantKey(                     // grant a key
     const CHAR *userid);          // user

     VOID
     grantClass(                   // grant a class
     const CHAR *userid);          // userid

     VOID
     grantCreds(                   // grant credits
     const CHAR *userid);          // user

     bool
     allAnswered(                  // have all questions been answered?
     const CHAR *userid);          // user

private:

     CHAR *
     getPercentage(                // percentage value
     INT numAns,
     INT totAns);

     PQUESMAP m_pQuesMap;          // pointer to map for question objects
     struct statcomp m_scomp;      // completion composite key
     struct polldata m_pdata;      // struct containing poll data
     struct polltally m_tally;     // poll tally struct
     INT m_tallyTotal;             // total tallied answers
     INT m_percentage;             // percentage
     INT m_tallyAnswers;           // number of times answer was selected
     USHORT m_updTime;             // time of last update
     USHORT m_updDate;             // date of last update
     struct timedata m_td;         // struct that stores time data
     CHAR *m_percentVal;           // pointer to percentage value
     CHAR m_fileLinkbuf[URLSIZ];   // buffer to hold link to file
     SHORT m_qnum;                 // question number
     CHAR m_percentBuf[PERCSIZ];   // percentage storage
};

#endif                             // __POLL_H
