/***************************************************************************
 *                                                                         *
 *   LOOKSYN.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Look-up Synthesis Class.                                              *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __LOOKSYN_H
#define __LOOKSYN_H

#include "gcomm.h"
#include "pollsyn.h"
#include "takesyn.h"

class lookupSynthesis: public takeSynthesis {
public:

     lookupSynthesis(          // default constructor
     acthSession *_ses);       // session object

     ~lookupSynthesis();       // destructor

     const CHAR *
     getSynthDir();            // synth directory

     bool
     getLookupParam();         // check the lookup parameter

     bool
     getPollNameParam();       // check poll name parameter

     ACTHCODE
     proceed();                // proceed entry point

private:

     const CHAR *m_uPtr;       // points to user name
};

#endif                         // __LOOKSYN_H
