/***************************************************************************
 *                                                                         *
 *   LOOKSYN.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Look-up Synthesis Class.                                              *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "looksyn.h"
#include "dnfmgr.h"
#include "majorbbs.h"

#define FILREV "$Revision: 11 $"

#define LOOKDIR "look-up/"

// dynafile stuff

dnfStep dnfLookErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfLookErrMap(PPFIX LOOKDIR "error.htm","Look-up Error Steps",dnfLookErrSteps);

// class method defs

MARKSOURCE(looksyn);

lookupSynthesis::lookupSynthesis(   // default constructor
                   acthSession *_ses):  // session object
                   takeSynthesis(_ses)
{
}

lookupSynthesis::~lookupSynthesis()   // destructor
{
}

const CHAR *
lookupSynthesis::getSynthDir()   // synth directory
{
     return(PPFIX LOOKDIR);
}

bool
lookupSynthesis::getPollNameParam() // check the pollname param
{
     GETPARAMVAL("pollname");
     if (m_pValBuf[0] == '\0') {
          setError(ERRNOPN);
     }
     else if (!m_pAPI->isPoll(m_pValBuf)) {
          setError(ERRINVPN);
     }
     else {
          m_pPoll=new poll(m_pValBuf);
          return(TRUE);
     }
     return(FALSE);
}

bool
lookupSynthesis::getLookupParam()  // check the lookup param
{
     bool retval=FALSE;

     GETPARAMVAL("lookup");
     if (m_pValBuf[0] == '\0') {
          setError(ERRNOUSR);
     }
     else if ((m_uPtr=uidCaps(m_pValBuf)) == NULL) {
          setError(ERRNXST);
     }
     else if (!m_pPoll->isComplete(m_uPtr)) {
          setError(ERRNCOMP);
     }
     else {
          retval=TRUE;
     }
     return(retval);
}

ACTHCODE
lookupSynthesis::proceed()       // proceed entry point
{
     ACTHCODE retval;
     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }
     if (getPollNameParam() && getLookupParam()) {
          string rdStr="/polls/take/?pollname=";
          rdStr+=urlEncode(m_pPoll->getName());
          rdStr+="&lookup=";
          rdStr+=urlEncode(m_uPtr);
          ses->redirect(rdStr.c_str());
          return(ACTHDONE);
     }
     else if (m_dnfPtr == NULL) {
          if (handleDynaResp(TRUE,&dnfLookErrMap,NULL) == ACTHDONE) {
               return(ACTHDONE);
          }
     }
     dnfSetTemplateTvb(m_dnfPtr);
     if (m_cyc.start()) {
          do {
               retval=dynafile();
          } while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}
