/***************************************************************************
 *                                                                         *
 *   LISTSYN.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   List Synthesis Class.                                                 *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __LISTSYN_H
#define __LISTSYN_H

#include "gcomm.h"
#include "pollsyn.h"

enum LISTSTATE {AH_FLAGS,AH_QUEUE,AH_MORELO,AH_MOREHI,AH_DYNAFILE};    // List Syn states

class listSynthesis: public pollSynthesis {
public:

     listSynthesis(                // default constructor
     acthSession *_ses);           // session object

     ~listSynthesis();             // destructor

     const CHAR *
     getSynthDir();                // synth directory

     ACTHCODE
     proceed();                    // entry point

private:

     VOID
     setOrderVb();                 // set order TVB

     VOID
     setStatusVb();                // set status TVB

     VOID
     setPriorityVb();              // set priority TVB

     VOID
     setListFlags();               // gets parameters and sets flags

     VOID
     setOrderFlag();               // figure out the order

     VOID
     setDirectFlag();              // figure out what direction to list

     VOID
     setLogonFlag();               // figure out what logon type to list

     VOID
     setStatusFlag();              // figure out what stati to list

     LISTSTATE
     establishQueue();             // set up poll queue

     VOID
     setListContextVbs();          // set up list context stuff

     VOID
     queuePollsGT();               // queue up polls greater than start

     VOID
     queuePollsLT();               // queue up polls less than start

     VOID
     queuePollsGE();               // queue up polls greater-equal to start

     VOID
     queuePollsLE();               // queue up polls less-equal to start

     VOID
     getPollCloseByAscend();       // get polls by close date in asc order

     VOID
     getPollCloseByDescend();      // get polls by close date in desc order

     VOID
     getPollCreateByAscend();      // get polls by create date in asc order

     VOID
     getPollCreateByDescend();     // get polls by create date in desc order

     ACTHCODE
     dynafile();                   // overriden dynafile

     bool
     isOkToList(                   // check status and logon parameters
     poll *pollptr);

     LISTSTATE
     pollsMoreLo();                // do we have lower polls?

     LISTSTATE
     pollsMoreHi();                // do we have higher polls?

     VOID
     start(                        // seed start value
     CHAR *ptr);                   // start at

     bool
     canLookup();                  // determine if a lookup can be done

     bool
     showPoll(                     // can we show this poll?
     poll *p);                     // pointer to poll object

     poll *m_listPoll;             // pointer to poll object
     poll *m_lowPoll;              // poll off back of queue
     poll *m_hiPoll;               // poll off front of queue
     CHAR m_startAt[PNAMELEN];     // where to start listing
     INT m_listCount;              // how polls to process in list
     LONG m_flags;                 // list flags
     PPOLLQUEUE m_pQueue;          // pointer to Queue
     USHORT m_startDate;           // starting date of list
     INT m_pollsFound;             // count variable
     bool m_noPollsFound;          // no polls were found
     SHORT m_count;                // count tracking variable
     CHAR m_nameBuf[PNAMELEN];     // temp. poll name storage
     bool m_moreLo;                // more polls lower?
     bool m_moreHi;                // more polls higher?
     string m_phiStr;              // store hi poll name (can also be date)
     string m_ploStr;              // store low poll name (can also be date)
};

#endif                             // __LISTSYN_H

