/***************************************************************************
 *                                                                         *
 *   LISTSYN.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   List Synthesis Class.                                                 *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "pollsyn.h"
#include "listsyn.h"
#include "majorbbs.h"
#include "dnfmgr.h"

#define FILREV "$Revision: 17 $"

#define LISTDIR  "list/"           // list directory
#define PARAMVALLEN      10
#define ISCREATE         m_flags&(ORDER_CREATEASC|ORDER_CREATEDESC)
#define ISCLOSE          m_flags&(ORDER_CLOSEASC|ORDER_CLOSEDESC)
#define ISALPHA          m_flags&(ORDER_ALPHASC|ORDER_ALPHDESC)
#define ISLOOKUP         m_flags&LIST_LOOKUP
#define ISRESULTS        m_flags&LIST_RESULTS
#define ISASCEND         m_flags&(ORDER_CREATEASC|ORDER_CLOSEASC|ORDER_ALPHASC)
#define ISALL            m_flags&LIST_ALL
#define ISGREATER        m_flags&(DIRECT_GE|DIRECT_GT)

// dynafile stuff

enum {DEFAULTITEM,LOOKUPITEM,RESULTSITEM};

dnfStep dnfListSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,DEFAULTITEM,"LISTITEM"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};

dnfStep dnfLookupSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,LOOKUPITEM,"LISTITEM"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};

dnfStep dnfResultsSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,RESULTSITEM,"LISTITEM"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};

dnfMap dnfListMap(PPFIX LISTDIR "index.htm","Default List",dnfListSteps);
dnfMap dnfLookupMap(PPFIX LISTDIR "look-up.htm","Lookup List"
,dnfLookupSteps);
dnfMap dnfResultsMap(PPFIX LISTDIR "results.htm","Results List"
,dnfResultsSteps);

struct valflag {                     // struct for stroing param vals and flags
     CHAR *pparamVal;                // parameter value ptr
     LONG flag;                      // parameter flag
};

// general flags

#define LIST_ALL         0x00000001  // List all polls - not queued - uses order
#define LIST_LOOKUP      0x00000002  // List all poll users has axs to lookup
#define LIST_RESULTS     0x00000004  // List all poll user has axs to results

// direction flags

#define DIRECT_GT        0x00000008  // List in Greather-than direction
#define DIRECT_LT        0x00000010  // List in Less-than direction
#define DIRECT_GE        0x00000020  // List in Greter-than-equal direction
#define DIRECT_LE        0x00000040  // list is less-than-equal direction

struct valflag directArray[]= {      // array of structures w/ direct values
     {"gt",DIRECT_GT},
     {"lt",DIRECT_LT},
     {"ge",DIRECT_GE},
     {"le",DIRECT_LE},
     {NULL,0}
};
// status flags

#define STATUS_NEW       0x00000080  // List polls with new status (default)
#define STATUS_DONE      0x00000100  // List polls with done status
#define STATUS_DEL       0x00000200  // list polls with delete status
#define STATUS_MAINT     0x00000400  // List polls with maintenance status
#define STATUS_ALL       0x00000800  // List polls with all statuses

struct valflag statusArray[]= {      // array of structures w/ status values
     {"all",  STATUS_ALL},
     {"new",  STATUS_NEW},
     {"done", STATUS_DONE},
     {"del",  STATUS_DEL},
     {"maint",STATUS_MAINT},
     {NULL,     0}
};

// logon flags

#define LOGON_ANNOUNCE   0x00001000  // List polls with "announce" logon
#define LOGON_SKIP       0x00002000  // List polls with "skip" logon
#define LOGON_INSIST     0x00004000  // List polls with "insist" logon
#define LOGON_ASK        0x00008000  // List polls with "ask" logon
#define LOGON_ALL        0x00010000  // List all logon polls

struct valflag logonArray[]= {       // array of structures w/ logon values
     {"all",     LOGON_ALL},
     {"announce",LOGON_ANNOUNCE},
     {"skip",    LOGON_SKIP},
     {"insist",  LOGON_INSIST},
     {"ask",     LOGON_ASK},
     {NULL,        0}
};

// order flags

#define ORDER_ALPHASC    0x00020000  // List polls in ascending order - alpha
#define ORDER_ALPHDESC   0x00040000  // List polls in descending order - alpha
#define ORDER_CREATEASC  0x00080000  // List polls in ascending order by createdate
#define ORDER_CREATEDESC 0x00100000  // List polls in descend. order by createdate
#define ORDER_CLOSEASC   0x00200000  // List polls in ascending order by closedate
#define ORDER_CLOSEDESC  0x00400000  // List polls in descending order by closedate

struct valflag orderArray[]= {       // array of structures w/ order values
     {"alphasc",   ORDER_ALPHASC},
     {"alphdesc",  ORDER_ALPHDESC},
     {"createasc", ORDER_CREATEASC},
     {"createdesc",ORDER_CREATEDESC},
     {"closeasc",  ORDER_CLOSEASC},
     {"closedesc", ORDER_CLOSEDESC},
     {NULL,          0}
};

MARKSOURCE(listsyn);

listSynthesis::listSynthesis(      // default constructor
               acthSession *_ses): // session object
               pollSynthesis(_ses),
               m_listPoll(NULL),
               m_pQueue(NULL),
               m_flags(0),
               m_listCount(dftlstc),
               m_startDate(0),
               m_count(0),
               m_pollsFound(0),
               m_noPollsFound(FALSE),
               m_moreLo(FALSE),
               m_moreHi(FALSE),
               m_lowPoll(NULL),
               m_hiPoll(NULL)
{
     m_startAt[0]=' ';
     m_startAt[1]='\0';
     m_nameBuf[0]='\0';
     m_cyc.setSlice(timslc);
     m_ahState=AH_FLAGS;
}

listSynthesis::~listSynthesis()    // destructor
{
}

const CHAR *
listSynthesis::getSynthDir()       // synth directory
{
     return(PPFIX LISTDIR);
}

ACTHCODE
listSynthesis::proceed()           // entry point
{
     ACTHCODE retval=ACTHMORE;

     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }

     switch (m_ahState) {
     case AH_FLAGS:
          setListFlags();
          if (m_flags&(LIST_ALL|LIST_LOOKUP|LIST_RESULTS)) {
               m_ahState=AH_DYNAFILE;
          }
          else {
               m_ahState=AH_QUEUE;
          }
          break;
     case AH_QUEUE:
          m_ahState=establishQueue();
          break;
     case AH_MORELO:
          m_ahState=pollsMoreLo();
          break;
     case AH_MOREHI:
          m_ahState=pollsMoreHi();
          break;
     case AH_DYNAFILE:
          if (m_dnfPtr == NULL) {
               m_onErrorBuf[0]='\0';   //onerror and onsuccess not
               m_onSuccessBuf[0]='\0'; // supported for "list" URL

               if (ISLOOKUP) {
                    handleDynaResp(FALSE,NULL,&dnfLookupMap);
               }
               else if (ISRESULTS) {
                    handleDynaResp(FALSE,NULL,&dnfResultsMap);
               }
               else {
                    handleDynaResp(FALSE,NULL,&dnfListMap);
               }
          }
          else {
               dnfSetTemplateTvb(m_dnfPtr);
               retval=dynafile();
          }
     }
     return(retval);
}

LISTSTATE
listSynthesis::pollsMoreLo()
{
     LISTSTATE retval=AH_MORELO;

     if (m_pQueue == NULL || m_pQueue->empty()) {
          return(AH_DYNAFILE);
     }
     if (!m_cyc.start()) {
          return(retval);
     }
     do {
          if (m_lowPoll == NULL) {
               m_lowPoll=m_pAPI->getPollEQ(m_pQueue->back());
          }

          const CHAR *pollPtr;

          if (ISALPHA) {
               if (m_lowPoll != NULL
                && (m_lowPoll=m_pAPI->getPollLT(m_lowPoll->getName()))
                != NULL) {
                    if (isOkToList(m_lowPoll)) {
                         m_moreLo=TRUE;
                    }
               }
          }
          else if (ISCLOSE) {
               if (m_lowPoll != NULL
                && (pollPtr=m_pAPI->getDateLT(m_lowPoll->getName(),FALSE
                ,m_lowPoll->getCloseDate())) != NULL) {
                    if ((m_lowPoll=m_pAPI->getPollEQ(pollPtr))
                     != NULL && isOkToList(m_lowPoll)) {
                         m_moreLo=TRUE;
                    }
               }
               else {
                    m_lowPoll=NULL;
               }
          }
          else {
               if (m_lowPoll != NULL
                && (pollPtr=m_pAPI->getDateLT(m_lowPoll->getName(),FALSE
                ,m_lowPoll->getCreateDate())) != NULL) {
                    if ((m_lowPoll=m_pAPI->getPollEQ(pollPtr))
                     != NULL && isOkToList(m_lowPoll)) {
                         m_moreLo=TRUE;
                    }
               }
               else {
                    m_lowPoll=NULL;
               }
          }
          if (m_lowPoll == NULL || m_moreLo == TRUE) {
               retval=AH_MOREHI;
          }

     } while (retval != AH_MOREHI && m_cyc.haveTime());
     return(retval);
}

LISTSTATE
listSynthesis::pollsMoreHi()
{
     LISTSTATE retval=AH_MOREHI;

     if (m_pQueue == NULL || m_pQueue->empty()) {
          return(AH_DYNAFILE);
     }
     if (!m_cyc.start()) {
          return(retval);
     }
     do {
          if (m_hiPoll == NULL) {
               m_hiPoll=m_pAPI->getPollEQ(m_pQueue->front());
          }

          const CHAR *pollPtr;

          if (ISALPHA) {
               if (m_hiPoll != NULL
                && (m_hiPoll=m_pAPI->getPollGT(m_hiPoll->getName()))
                != NULL) {
                    if (isOkToList(m_hiPoll)) {
                         m_moreHi=TRUE;
                    }
               }
          }
          else if (ISCLOSE) {
               if (m_hiPoll != NULL
                && (pollPtr=m_pAPI->getDateGT(m_hiPoll->getName(),FALSE
                ,m_hiPoll->getCloseDate())) != NULL) {
                    if ((m_hiPoll=m_pAPI->getPollEQ(pollPtr))
                     != NULL && isOkToList(m_hiPoll)) {
                         m_moreHi=TRUE;
                    }
               }
               else {
                    m_hiPoll=NULL;
               }
          }
          else {
               if (m_hiPoll != NULL
                && (pollPtr=m_pAPI->getDateGT(m_hiPoll->getName(),FALSE
                ,m_hiPoll->getCreateDate())) != NULL) {
                    if ((m_hiPoll=m_pAPI->getPollEQ(pollPtr))
                     != NULL && isOkToList(m_hiPoll)) {
                         m_moreHi=TRUE;
                    }
               }
               else {
                    m_hiPoll=NULL;
               }
          }
          if (m_hiPoll == NULL || m_moreHi == TRUE) {
               retval=AH_DYNAFILE;
          }

     } while (retval != AH_DYNAFILE && m_cyc.haveTime());
     return(retval);
}

VOID
listSynthesis::setListFlags()      // gets parameters and sets flags
{
     setOrderFlag();
     if (ISPARAM("all")) {
          m_flags|=LIST_ALL;
          return;
     }
     else if (ISPARAM("lookup")) {
          m_flags=0;
          m_flags|=LIST_LOOKUP;
          m_flags|=ORDER_ALPHASC;
          return;
     }
     else if (ISPARAM("results")) {
          m_flags|=LIST_RESULTS;
          return;
     }
     GETPARAMVAL("start");
     if (m_pValBuf[0] != '\0') {
          start(m_pValBuf);
     }
     if (ISCREATE || ISCLOSE) {
          if (m_startAt[0] != ' ') {
               m_startDate=dcdate(m_startAt);
               if (m_startDate == GCINVALIDDOT) {
                    m_startDate=0;
               }
          }
     }
     GETPARAMVAL("count");
     if (m_pValBuf[0] != '\0') {
          if ((m_listCount=atol(m_pValBuf)) > maxlstc) {
               m_listCount=maxlstc;
          }
     }
     setDirectFlag();
     setLogonFlag();
     setStatusFlag();
}

VOID
listSynthesis::setDirectFlag()      // figure out direction to list
{
     bool set=FALSE;

     GETPARAMVAL("direction");
     if (m_pValBuf[0] != '\0') {
          INT arrit=0;
          while (directArray[arrit].pparamVal != NULL) {
               if (sameas(directArray[arrit].pparamVal,m_pValBuf)) {
                    m_flags|=directArray[arrit].flag;
                    set=TRUE;
                    break;
               }
               ++arrit;
          }
     }
     if (!set) {
          m_flags|=DIRECT_GE;
     }
}

VOID
listSynthesis::setLogonFlag()      // figures out what logontype to list
{
     bool set=FALSE;
     bool setAll=FALSE;

     GETPARAMVAL("logon");
     if (m_pValBuf[0] != '\0') {
          INT arrit=0;
          while (logonArray[arrit].pparamVal != NULL) {
               if (samein(logonArray[arrit].pparamVal,m_pValBuf)) {
                    m_flags|=logonArray[arrit].flag;
                    set=TRUE;
               }
               if (m_flags&LOGON_ALL) {
                    break;
               }
               ++arrit;
          }
     }
     if (!set) {
          m_flags|=LOGON_ALL;
     }
}

VOID
listSynthesis::setStatusFlag()         // figures out what stati to list
{
     bool set=FALSE;
     bool setAll=FALSE;

     GETPARAMVAL("status");
     if (m_pValBuf[0] != '\0') {
          INT arrit=0;
          while (statusArray[arrit].pparamVal != NULL) {
               if (samein(statusArray[arrit].pparamVal,m_pValBuf)) {
                    m_flags|=statusArray[arrit].flag;
                    set=TRUE;
               }
               if (m_flags&STATUS_ALL) {
                    break;
               }
               ++arrit;
          }
     }
     if (!set) {
          m_flags|=STATUS_ALL;
     }
}

VOID
listSynthesis::setOrderFlag()          // figure out the order
{
     bool set=FALSE;

     GETPARAMVAL("order");
     if (m_pValBuf[0] != '\0') {
          INT arrit=0;
          while (orderArray[arrit].pparamVal != NULL) {
               if (sameas(orderArray[arrit].pparamVal,m_pValBuf)) {
                    m_flags|=orderArray[arrit].flag;
                    set=TRUE;
                    break;
               }
              ++arrit;
          }
     }
     if (!set) {
          m_flags|=ORDER_ALPHASC;
     }
}

VOID
listSynthesis::queuePollsGT()
{
     const CHAR *pollPtr;
     do {
          if (ISCREATE) {
               m_listPoll=NULL;
               if ((pollPtr=m_pAPI->getDateGT(m_nameBuf,TRUE,m_startDate)) != NULL) {
                    m_listPoll=m_pAPI->getPollEQ(pollPtr);
               }
          }
          else if (ISCLOSE) {
               m_listPoll=NULL;
               if ((pollPtr=m_pAPI->getDateGT(m_nameBuf,FALSE,m_startDate)) != NULL) {
                    m_listPoll=m_pAPI->getPollEQ(pollPtr);
               }
          }
          else if (ISALPHA) {
               m_listPoll=m_pAPI->getPollGT(m_startAt);
          }
          if (m_listPoll != NULL) {
               if (isOkToList(m_listPoll)) {
                    m_pAPI->pushFrontQueue(strdup(m_listPoll->getName()));
                    if (++m_count >= m_listCount) {
                         m_listPoll=NULL;
                         break;
                    }
               }
               if (ISALPHA) {
                    stlcpy(m_startAt,m_listPoll->getName(),PNAMELEN);
               }
               else if (ISCLOSE) {
                    m_startDate=m_listPoll->getCloseDate();
                    stlcpy(m_nameBuf,m_listPoll->getName(),PNAMELEN);
               }
               else {
                    m_startDate=m_listPoll->getCreateDate();
                    stlcpy(m_nameBuf,m_listPoll->getName(),PNAMELEN);
               }
          }
     } while(m_listPoll != NULL && m_cyc.haveTime());
}

VOID
listSynthesis::queuePollsLT()
{
     const CHAR *pollPtr;
     do {
          if (ISCREATE) {
               m_listPoll=NULL;
               if ((pollPtr=m_pAPI->getDateLT(m_nameBuf,TRUE,m_startDate)) != NULL) {
                    m_listPoll=m_pAPI->getPollEQ(pollPtr);
               }
          }
          else if (ISCLOSE) {
               m_listPoll=NULL;
               if ((pollPtr=m_pAPI->getDateLT(m_nameBuf,FALSE,m_startDate)) != NULL) {
                    m_listPoll=m_pAPI->getPollEQ(pollPtr);
               }
          }
          else if (ISALPHA) {
               m_listPoll=m_pAPI->getPollLT(m_startAt);
          }
          if (m_listPoll != NULL) {
               if (isOkToList(m_listPoll)) {
                    m_pAPI->pushBackQueue(strdup(m_listPoll->getName()));
                    if (++m_count >= m_listCount) {
                         m_listPoll=NULL;
                         break;
                    }
               }
               if (ISALPHA) {
                    stlcpy(m_startAt,m_listPoll->getName(),PNAMELEN);
               }
               else if (ISCLOSE) {
                    m_startDate=m_listPoll->getCloseDate();
                    stlcpy(m_nameBuf,m_listPoll->getName(),PNAMELEN);
               }
               else {
                    m_startDate=m_listPoll->getCreateDate();
                    stlcpy(m_nameBuf,m_listPoll->getName(),PNAMELEN);
               }
          }
     } while(m_listPoll != NULL && m_cyc.haveTime());
}

VOID
listSynthesis::queuePollsGE()
{
     const CHAR *pollPtr;
     do {
          if (ISCREATE) {
               if (m_listPoll == NULL) {
                    if ((pollPtr=m_pAPI->getDateGE(TRUE,m_startDate))
                     != NULL) {
                         m_listPoll=m_pAPI->getPollEQ(pollPtr);
                    }
               }
               else {
                    m_listPoll=NULL;
                    if ((pollPtr=m_pAPI->getDateGT(m_nameBuf,TRUE,m_startDate))
                     != NULL) {
                         m_listPoll=m_pAPI->getPollEQ(pollPtr);
                    }
               }
          }
          else if (ISCLOSE) {
               if (m_listPoll == NULL) {
                    if ((pollPtr=m_pAPI->getDateGE(FALSE,m_startDate))
                     != NULL) {
                         m_listPoll=m_pAPI->getPollEQ(pollPtr);
                    }
               }
               else {
                    m_listPoll=NULL;
                    if ((pollPtr=m_pAPI->getDateGT(m_nameBuf,FALSE,m_startDate))
                     != NULL) {
                         m_listPoll=m_pAPI->getPollEQ(pollPtr);
                    }
               }
          }
          else if (ISALPHA) {
               if (m_listPoll == NULL) {
                    m_listPoll=m_pAPI->getPollGE(m_startAt);
               }
               else {
                    m_listPoll=m_pAPI->getPollGT(m_startAt);
               }
          }
          if (m_listPoll != NULL) {
               if (isOkToList(m_listPoll)) {
                    m_pAPI->pushFrontQueue(strdup(m_listPoll->getName()));
                    if (++m_count >= m_listCount) {
                         m_listPoll=NULL;
                         break;
                    }
               }
               if (ISALPHA) {
                    stlcpy(m_startAt,m_listPoll->getName(),PNAMELEN);
               }
               else if (ISCREATE) {
                    m_startDate=m_listPoll->getCreateDate();
                    stlcpy(m_nameBuf,m_listPoll->getName(),PNAMELEN);
               }
               else {
                    m_startDate=m_listPoll->getCloseDate();
                    stlcpy(m_nameBuf,m_listPoll->getName(),PNAMELEN);
               }
          }
     } while(m_listPoll !=NULL && m_cyc.haveTime());
}

VOID
listSynthesis::queuePollsLE()
{
     const CHAR *pollPtr;
     do {
          if (ISCREATE) {
               if (m_listPoll == NULL) {
                    if ((pollPtr=m_pAPI->getDateLE(TRUE,m_startDate))
                     != NULL) {
                         m_listPoll=m_pAPI->getPollEQ(pollPtr);
                    }
               }
               else {
                    m_listPoll=NULL;
                    if ((pollPtr=m_pAPI->getDateLT(m_nameBuf,TRUE,m_startDate))
                     != NULL) {
                         m_listPoll=m_pAPI->getPollEQ(pollPtr);
                    }
               }
          }
          else if (ISCLOSE) {
               if (m_listPoll == NULL) {
                    if ((pollPtr=m_pAPI->getDateLE(FALSE,m_startDate))
                     != NULL) {
                         m_listPoll=m_pAPI->getPollEQ(pollPtr);
                    }
               }
               else {
                    m_listPoll=NULL;
                    if ((pollPtr=m_pAPI->getDateLT(m_nameBuf,FALSE,m_startDate))
                     != NULL) {
                         m_listPoll=m_pAPI->getPollEQ(pollPtr);
                    }
               }
          }
          else if (ISALPHA) {
               if (m_listPoll == NULL) {
                    m_listPoll=m_pAPI->getPollLE(m_startAt);
               }
               else {
                    m_listPoll=m_pAPI->getPollLT(m_startAt);
               }
          }
          if (m_listPoll != NULL) {
               if (isOkToList(m_listPoll)) {
                    m_pAPI->pushBackQueue(strdup(m_listPoll->getName()));
                    if (++m_count >= m_listCount) {
                         m_listPoll=NULL;
                         break;
                    }
               }
               if (ISALPHA) {
                    stlcpy(m_startAt,m_listPoll->getName(),PNAMELEN);
               }
               else if (ISCREATE) {
                    m_startDate=m_listPoll->getCreateDate();
                    stlcpy(m_nameBuf,m_listPoll->getName(),PNAMELEN);
               }
               else {
                    m_startDate=m_listPoll->getCloseDate();
                    stlcpy(m_nameBuf,m_listPoll->getName(),PNAMELEN);
               }
          }
     } while(m_listPoll != NULL && m_cyc.haveTime());
}


LISTSTATE
listSynthesis::establishQueue()    // setup Queue
{
     LISTSTATE retval=AH_QUEUE;

     if (!m_cyc.start()) {
          return(retval);
     }
     if (m_flags&DIRECT_GT) {
          queuePollsGT();
     }
     else if (m_flags&DIRECT_GE) {
          queuePollsGE();
     }
     else if (m_flags&DIRECT_LE) {
          queuePollsLE();
     }
     else if (m_flags&DIRECT_LT) {
          queuePollsLT();
     }
     if (m_listPoll == NULL) {
          retval=AH_MORELO;
          m_pQueue=m_pAPI->getQueuePtr();
     }
     return(retval);
}

VOID
listSynthesis::setStatusVb()       // set up our status text variable
{
     SHORT arrit=0;
     t_ListStatus="";
     while (statusArray[arrit].pparamVal != NULL) {
          if (m_flags&statusArray[arrit].flag) {
               t_ListStatus+=statusArray[arrit].pparamVal;
               t_ListStatus+=",";
          }
          ++arrit;
     }
     t_ListStatus.remove(t_ListStatus.length()-1);
}

VOID
listSynthesis::setPriorityVb()     // set up our priority i.e. logon text variable
{
     SHORT arrit=0;
     t_Priority="";
     while (logonArray[arrit].pparamVal != NULL) {
          if (m_flags&logonArray[arrit].flag) {
               t_Priority+=logonArray[arrit].pparamVal;
               t_Priority+=",";
          }
          ++arrit;
     }
     t_Priority.remove(t_Priority.length()-1);
}

VOID
listSynthesis::setOrderVb()        // set up our order text variable
{
     SHORT arrit=0;
     while (orderArray[arrit].pparamVal != NULL) {
          if (m_flags&orderArray[arrit].flag) {
               t_Order=orderArray[arrit].pparamVal;
               break;
          }
          ++arrit;
     }
}

VOID
listSynthesis::setListContextVbs() // set up our list context variables
{
     if (m_pQueue != NULL && !m_pQueue->empty() && m_dnfPtr->rowNumber() == 0) {
          poll *backPoll=new poll(m_pQueue->back());
          poll *frontPoll=new poll(m_pQueue->front());

          if (ISALPHA) {
               m_ploStr=m_pQueue->back();
               m_phiStr=m_pQueue->front();
          }
          else if (ISCLOSE) {
               m_ploStr=ncdatel(backPoll->getCloseDate());
               m_phiStr=ncdatel(frontPoll->getCloseDate());
          }
          else {
               m_ploStr=ncdatel(backPoll->getCreateDate());
               m_phiStr=ncdatel(frontPoll->getCreateDate());
          }
          delete backPoll;
          delete frontPoll;
     }
     t_Count=m_listCount;
     setStatusVb();
     setPriorityVb();
     setOrderVb();
     m_moreLo ? t_PollMoreLo=1 : t_PollMoreLo=0;
     m_moreHi ? t_PollMoreHi=1 : t_PollMoreHi=0;
     t_Hi=m_phiStr.c_str();
     t_Low=m_ploStr.c_str();
}

VOID
listSynthesis::getPollCloseByAscend() // get polls by closing date in asc order
{
     const CHAR *pollPtr;
     if (m_dnfPtr->rowNumber() == 0) {          // first time
          pollPtr=m_pAPI->pollDateLow(FALSE);
          if (pollPtr != NULL) {
               m_listPoll=m_pAPI->getPollEQ(pollPtr);
          }
          else {
               m_listPoll=NULL;
          }
     }
     else {
          pollPtr=m_pAPI->getDateGT(m_listPoll->getName(),FALSE
           ,m_listPoll->getCloseDate());
          if (pollPtr != NULL) {
               m_listPoll=m_pAPI->getPollEQ(pollPtr);
          }
          else {
               m_listPoll=NULL;
          }
     }
}

VOID
listSynthesis::getPollCloseByDescend() // get polls by close date in desc order
{
     const CHAR *pollPtr;
     if (m_dnfPtr->rowNumber() == 0) {
          pollPtr=m_pAPI->pollDateHi(FALSE);
          if (pollPtr != NULL) {
               m_listPoll=m_pAPI->getPollEQ(pollPtr);
          }
          else {
               m_listPoll=NULL;
          }
     }
     else {
          pollPtr=m_pAPI->getDateLT(m_listPoll->getName(),FALSE
           ,m_listPoll->getCloseDate());
          if (pollPtr != NULL) {
               m_listPoll=m_pAPI->getPollEQ(pollPtr);
          }
          else {
               m_listPoll=NULL;
          }
     }
}

VOID
listSynthesis::getPollCreateByAscend() // get polls by create date in asc order
{
     const CHAR *pollPtr;
     if (m_dnfPtr->rowNumber() == 0) {
          pollPtr=m_pAPI->pollDateLow(TRUE);
          if (pollPtr != NULL) {
               m_listPoll=m_pAPI->getPollEQ(pollPtr);
          }
          else {
               m_listPoll=NULL;
          }
     }
     else {
          pollPtr=m_pAPI->getDateGT(m_listPoll->getName(),TRUE
           ,m_listPoll->getCreateDate());
          if (pollPtr != NULL) {
               m_listPoll=m_pAPI->getPollEQ(pollPtr);
          }
          else {
               m_listPoll=NULL;
          }
     }
}

VOID
listSynthesis::getPollCreateByDescend()  // get polls by create date in desc order
{
     const CHAR *pollPtr;
     if (m_dnfPtr->rowNumber() == 0) {
          pollPtr=m_pAPI->pollDateHi(TRUE);
          if (pollPtr != NULL) {
               m_listPoll=m_pAPI->getPollEQ(pollPtr);
          }
          else {
               m_listPoll=NULL;
          }
     }
     else {
          pollPtr=m_pAPI->getDateLT(m_listPoll->getName(),TRUE
           ,m_listPoll->getCreateDate());
          if (pollPtr != NULL) {
               m_listPoll=m_pAPI->getPollEQ(pollPtr);
          }
          else {
               m_listPoll=NULL;
          }
     }
}

bool
listSynthesis::showPoll(        // see if poll should be listed based on attrib and key
poll *p)
{
     if (!m_usrPtr->hasKey(p->getTakeKey())
      && p->getAccessAttrib() == HIDE) {
          return(FALSE);
     }
     return(TRUE);
}

bool
listSynthesis::isOkToList(         // check status, and logon
poll *pollPtr)
{
     ASSERT(pollPtr != NULL);

     bool retval=TRUE;

     if (!showPoll(pollPtr)) {
          return(FALSE);
     }
     if (!(m_flags&STATUS_ALL)) {
          if (pollPtr->getStatus(m_usrPtr->userid()) == STAT_NEW
            && !(m_flags&STATUS_NEW)) {
               retval=FALSE;
          }
          else if (pollPtr->getStatus(m_usrPtr->userid()) == STAT_DONE
            && !(m_flags&STATUS_DONE)) {
               retval=FALSE;
          }
          else if (pollPtr->getStatus(m_usrPtr->userid()) == STAT_MAINT
            && !(m_flags&STATUS_MAINT)) {
               retval=FALSE;
          }
          else if (pollPtr->getStatus(m_usrPtr->userid()) == STAT_DEL
           && !(m_flags&STATUS_DEL)) {
               retval=FALSE;
          }
     }
     if (!(m_flags&LOGON_ALL)) {
          if (pollPtr->getPriority() == SKIP && !(m_flags&LOGON_SKIP)) {
               retval=FALSE;
          }
          else if(pollPtr->getPriority() == ANNOUNCE
           && !(m_flags&LOGON_ANNOUNCE)) {
               retval=FALSE;
          }
          else if (pollPtr->getPriority() == ASK && !(m_flags&LOGON_ASK)) {
               retval=FALSE;
          }
          else if (pollPtr->getPriority() == INSIST
           && !(m_flags&LOGON_INSIST)) {
               retval=FALSE;
          }
     }
     return(retval);
}

VOID
listSynthesis::start(              // seed start value (alphabetic)
CHAR *ptr)
{
     stlcpy(m_startAt,strupr(ptr),PNAMELEN);
}

bool
listSynthesis::canLookup()
{
     ASSERT(m_usrPtr != NULL);
     ASSERT(m_listPoll != NULL);

     return (m_usrPtr->hasKey(m_listPoll->getLookupKey())
      && (m_listPoll->getStorageMethod() == BTRIEVE
      || m_listPoll->getStorageMethod() == BOTH));
}

ACTHCODE
listSynthesis::dynafile()          // overriden dynafile
{
     ACTHCODE retval=ACTHMORE;

     if (!m_cyc.start()) {
          return(retval);
     }

     do {
          if (m_noPollsFound) {
               m_pTvb->setListVariables(NULL,m_usrPtr->userid());
          }
          if (m_listPoll != NULL) {
               m_pTvb->setListVariables(m_listPoll,m_usrPtr->userid());
          }
          if (!(ISLOOKUP) && !(ISALL) && !(ISRESULTS)) {
               setListContextVbs();
          }

          switch(m_dnfPtr->process()) {
          case DNFBEGIN:
               if (!(ISASCEND)) {
                    stlcpy(m_startAt,m_pAPI->getPollNameHi(),PNAMELEN);
                    if (m_startAt[0] != '\0') {
                         m_startAt[0]=++(m_startAt[0]);
                    }
               }
               break;
          case DNFROWBEGIN:
               if (ISLOOKUP) {          // handle a lookup request
                    if ((m_listPoll=m_pAPI->getPollGT(m_startAt)) != NULL) {
                         stlcpy(m_startAt,m_listPoll->getName(),PNAMELEN);
                         if (!canLookup()) {
                              m_dnfPtr->sayAgain();
                              break;
                         }
                         ++m_pollsFound;
                    }
               }
               else if (ISALL || ISRESULTS) {  // handle stuff that hasn't been queued
                    if (ISALPHA) {
                         if (ISASCEND) {
                              if ((m_listPoll=m_pAPI->getPollGT(m_startAt))
                               != NULL) {
                                   stlcpy(m_startAt,m_listPoll->getName()
                                    ,PNAMELEN);
                                   if (ISRESULTS && (m_listPoll->getType() == QUESTIONNAIRE
                                    || m_listPoll->getAnswerType() == ACCUMULATE
                                    || !m_usrPtr->hasKey(m_listPoll->getResultKey()))) {
                                        m_dnfPtr->sayAgain();
                                        break;
                                   }
                                   else if (!(ISRESULTS) && !showPoll(m_listPoll)) {
                                        m_dnfPtr->sayAgain();
                                        break;
                                   }
                                   ++m_pollsFound;
                              }
                         }
                         else {
                              if ((m_listPoll=m_pAPI->getPollLT(m_startAt))
                               != NULL) {
                                   stlcpy(m_startAt,m_listPoll->getName()
                                    ,PNAMELEN);
                                   if (ISRESULTS && (m_listPoll->getType() == QUESTIONNAIRE
                                    || m_listPoll->getAnswerType() == ACCUMULATE
                                    || !m_usrPtr->hasKey(m_listPoll->getResultKey()))) {
                                        m_dnfPtr->sayAgain();
                                        break;
                                   }
                                   else if (!(ISRESULTS) && !showPoll(m_listPoll)) {
                                        m_dnfPtr->sayAgain();
                                        break;
                                   }
                                   ++m_pollsFound;
                              }
                         }
                    }
                    else if (ISCLOSE) {
                         if (ISASCEND) {
                              getPollCloseByAscend();
                         }
                         else {
                              getPollCloseByDescend();
                         }
                         if (m_listPoll != NULL) {
                              if (!showPoll(m_listPoll)) {
                                   m_dnfPtr->sayAgain();
                                   break;
                              }
                              ++m_pollsFound;
                         }
                    }
                    else if (ISCREATE) {
                         if (ISASCEND) {
                              getPollCreateByAscend();
                         }
                         else {
                              getPollCreateByDescend();
                         }
                         if (m_listPoll != NULL) {
                              if (!showPoll(m_listPoll)) {
                                   m_dnfPtr->sayAgain();
                                   break;
                              }
                              ++m_pollsFound;
                         }
                    }
               }
               else {                   // handle queued stuff
                    if (m_pQueue->empty()) {
                         m_listPoll=NULL;
                         m_dnfPtr->tableDone();
                         if (m_pollsFound == 0) {
                              m_noPollsFound=TRUE;
                         }
                         break;
                    }
                    if (ISASCEND) {
                         m_listPoll=new poll(m_pQueue->back());
                         delete m_pQueue->back();
                         m_pQueue->pop_back();
                         ++m_pollsFound;
                    }
                    else {
                         m_listPoll=new poll(m_pQueue->front());
                         delete m_pQueue->front();
                         m_pQueue->pop_front();
                         ++m_pollsFound;
                    }
               }
               if (m_listPoll == NULL) {
                    m_dnfPtr->tableDone();
                    if (m_pollsFound == 0) {
                         m_noPollsFound=TRUE;
                    }
               }
               else {
                    m_pTvb->setListVariables(m_listPoll,m_usrPtr->userid());
               }
               break;
          case DNFEND:
               retval=ACTHDONE;
          }
     } while (m_cyc.haveTime() && retval != ACTHDONE);

     return(retval);
}
