/***************************************************************************
 *                                                                         *
 *   FILESYN.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   File Synthesis Class.                                                 *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "filesyn.h"
#include "dnf.h"
#include "dnfmgr.h"

#define FILEDIR "file/"

// dynafile stuff

dnfStep dnfFileSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfFileMap(PPFIX FILEDIR "index.htm","File Steps",dnfFileSteps);

// class method defs

MARKSOURCE(filesyn);

fileSynthesis::fileSynthesis(   // default constructor
                   acthSession *_ses):  // session object
                   pollSynthesis(_ses)
{
}

fileSynthesis::~fileSynthesis()   // destructor
{
}

ACTHCODE
fileSynthesis::proceed()       // proceed entry point
{
     ACTHCODE retval;
     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }
     if (m_dnfPtr == NULL) {
          m_dnfPtr=dnfCreateHandlerURL(ses,&dnfFileMap,PPFIX);
          if (m_dnfPtr != NULL) {
               CHAR fileExtension[GCMAXEXT+1];
               const CHAR* fileName=m_dnfPtr->getMap().getFile();
               fileparts(GCPART_EXTN,fileName,fileExtension,GCMAXEXT+1);
               ses->contypeFext(fileExtension);
          }
     }
     dnfSetTemplateTvb(m_dnfPtr);
     if (m_cyc.start()) {
          do {
               retval=dynafile();
          } while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}
