/***************************************************************************
 *                                                                         *
 *   DLSYN.CPP                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Download Synthesis Class.                                             *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "dlsyn.h"
#include "fioapi.h"
#include "galpnqah.h"
#include "pollmsg.h"
#include "dnf.h"
#include "dnfmgr.h"
#include "majorbbs.h"
#include "ahutil.h"

#define FILREV "$Revision: 10 $"

static BYTE                        // value of the hex digit
hexVal(                            // get the value of a hex character
CHAR ch);                          // char to evaluate

const CHAR *                      // decoded String
cgiDecode(                        // decode a String for CGI "safety"
const CHAR* str);                 // original String

// dynafile stuff

dnfStep dnfdlErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfdlErrMap(PPFIX "download/error.htm","Download error",dnfdlErrSteps);

// class method defs

MARKSOURCE(dlsyn);

downloadSynthesis::downloadSynthesis(   // default constructor
                   acthSession *_ses):  // session object
                   pollSynthesis(_ses)
{
}

downloadSynthesis::~downloadSynthesis()   // destructor
{
}

const CHAR *
downloadSynthesis::getSynthDir()   // synth directory
{
     return(PPFIX "download/");
}

ACTHCODE
downloadSynthesis::proceed()       // proceed entry point
{
     ACTHCODE retval;

     if ((retval=isUserOK()) != ACTHMORE) {
          return (retval);
     }
     if (ses->urlargc() >= 2) {
          if ((m_pPoll=m_pAPI->getPollEQ(cgiDecode(ses->urlargv(1)))) != NULL) {
               if (m_pPoll->isComplete(m_usrPtr->userid())) {
                    if (isfile(m_pPoll->getGrantFile())) {
                         ses->sndfile(m_pPoll->getGrantFile());
                         return(ACTHDONE);
                    }
                    else {
                         setError(ERRGFNF,m_pPoll->getGrantFile());
                    }
               }
               else {
                    setError(ERRPNC);
               }
          }
          else {
               setError(ERRGPNF,cgiDecode(ses->urlargv(1)));
          }
     }
     else {
          return(ACTHNOTFND);
     }
     if (m_dnfPtr == NULL) {
          if (m_onErrorBuf[0] != '\0') {
               if (isURLTemplate(m_onErrorBuf)) {
                    ses->redirect(m_onErrorBuf);
                    return(ACTHDONE);
               }
               else {
                    getHandler(TRUE,&dnfdlErrMap);
               }
          }
          else {
               m_dnfPtr=new dnfHandler(dnfdlErrMap,bout);
          }
     }
     dnfSetTemplateTvb(m_dnfPtr);
     return(dynafile());
}

const CHAR *                      // decoded String
cgiDecode(                        // decode a String for CGI "safety"
const CHAR* str)                  // original String
{
     string st(str);
     static string result("");

     ASSERT(str != NULL);
     result="";
     for (int count = 0; count < st.length(); ++count )
     {
          BYTE ch=st[count] ;

          if (ch == '+') {
               result+=' ';
          }
          else if ((ch == '%')
           && (count < (st.length() - 2))
           && isxdigit( st[ count + 1 ] )
           && isxdigit( st[ count + 2 ] )) {
               ch=(hexVal(st[count+1] ) << 4)|(hexVal(st[count+2]));
               result+=ch;
               count+=2;
          }
          else {
               result+=(char)ch;
          }
     }
     return(result.c_str());
}

static BYTE                        // value of the hex digit
hexVal(                            // get the value of a hex character
CHAR ch)                           // char to evaluate
{
     BYTE result=isdigit(ch ) ? (ch - '0') :
                                   ((tolower( ch ) - 'a') + 10);

     ASSERT(result <= 15);

     return(result);
}
