/***************************************************************************
 *                                                                         *
 *   GALPNQR.C                                                             *
 *                                                                         *
 *   Copyright (c) 1988-1997 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *                                                                         *
 *                                          - M. Timothy Stark 11/01/93    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "excphand.h"
#include "gcspsrv.h"
#undef DELETE
#include "galpnqh.h"

#define FILREV "$Revision: 13 $"

#define INPLEN        80           /* input length for command parsing     */
#define DFTOUT       "s"           /* output to users screen               */
#define PSSIZ  (PNAMELEN)          /* poll selection size                  */

#define BLKWHT      0x70           /* Black on white                       */
#define YELWHT      0x7E           /* Yellow on white                      */
#define YELCYN      0x3E           /* Yellow on cyan                       */
#define WHTBLK      0x0F           /* White on black                       */
#define YELBLU      0x1E           /* Yellow on blue                       */
#define WHTBLU      0x1F           /* White on blue                        */
#define GRNBLU      0x1A           /* Green on blue                        */
#define CYNBLU      0x1B           /* Cyan on blue                         */
#define REDBLU      0x1C           /* Red on blue                          */
#define BLKBLU      0x10           /* Black on blue                        */

#define DELFLAG       256          /* flag to show poll is tagged for del. */

static CHAR dosscn[GVIDSCNSIZ];    /* saved DOS screen image               */
static CHAR savbak[GVIDSCNSIZ];    /* saved background (for help screen)   */
static CHAR scrsav1[GVIDSCNSIZ];
static CHAR scrsav2[GVIDSCNSIZ];
static CHAR scrsav3[GVIDSCNSIZ];
extern CHAR scntbl[][GVIDSCNSIZ];  /* array of screens (c/o MAKESCNS)      */

CHAR uid[UIDSIZ],                  /* storage for user-id                  */
     repchr[2];

CHAR *polllst,                     /* poll list                            */
     **selptr;                     /* poll selector                        */

HMCVFILE polmb;                    /* pollester message file handle        */

DFAFILE *sbb,                      /* user statistic data file pointer     */
        *pbb,                      /* general poll data file pointer       */
        *qbb,                      /* poll question data file pointer      */
        *abb,                      /* poll answer data file pointer        */
        *tbb;                      /* poll tally data file pointer         */

CHAR *msgptr,                      /* pointer to last message gotten       */
     *plnams[10];                  /* array of poll names                  */

static
CHAR *type[]={
     "Questionnaire",
     "Poll",
     "Questionnaire"               /* fixes type[dp->polltype] == 2        */
};

static
CHAR *repopts[]={
     " User-ID",
     " Polls",
     " Questionnaires"
};

static
CHAR *pqopts[]={
     " Summary Report",
     " Template Report"
};

static
CHAR *rpthdr[]={
     "Polls and Questionnaires User Report for \"%s\"",
     "Poll Summary Report for %s \"%s\"",
     "Questionnaire Summary Report for %s \"%s\""
};

INT cnt,                           /* global counter for poll selection    */
    redir=0,
    pagbrk=0,
    line=-1,
    ques,
    expuid,                        /* explode get user-id box? 1=YES 0=NO  */
    explst,                        /* explode poll listing?    1=YES 0=NO  */
    explst2;                       /* explode pnq option listing?          */

CHAR inpnam[15],
     outnam[15];

FILE *outf=NULL;

struct pollstat *sp;
struct polldata *dp;
struct quesdata *qp;
struct ansrdata *ap;
struct quescomp qcomp;
struct ansrcomp acomp;
struct statcomp scomp;
struct polltally tally;

VOID iniwin (VOID);
VOID gohome (INT mode);
INT Getopt (VOID);
INT uidrpt (VOID);
GBOOL val_uid (INT c,CHAR *stg);
INT GetPoll (INT mode);
VOID lodopt (INT opt);
VOID lodpol (INT opt, INT mode);
INT haspols (VOID);
GBOOL valout (INT c, CHAR *stg);
VOID dourpt (INT mode);
INT whrout (VOID);
INT ismult (VOID);
INT ShowMult (INT mode);
INT getfil (VOID);
static VOID prfsp (CHAR *fmat,...);
INT finup (INT mode);
INT ispols (INT mode);
VOID dosrpt (INT mode);
VOID doprpt (INT mode);
VOID usrrpt (CHAR *usr, CHAR *pq, CHAR *out);
VOID polrpt (CHAR *poll, CHAR *out);
VOID qusrpt (CHAR *ques, CHAR *out);
VOID init (VOID);
VOID fmtuid (CHAR *stg);
INT isuplo (CHAR *stg);
VOID stripb (CHAR *stg);
VOID pshutdown (VOID);
VOID stamp (VOID);
CHAR *rsltper(INT num,INT tot);

INT
main(argc,argv)                    /* main loop                            */
INT argc;                          /* number of command-line params        */
CHAR *argv[];                      /* parsed command-line params           */
{
TRY
     INT ropt,opt,i,mode,cat;
     CHAR inp[INPLEN];
     CHAR *ip;
     CHAR usr[UIDSIZ];
     CHAR pq[PNAMELEN];
     CHAR out[PTHFILSIZ];

#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONINFORMATION|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#endif // GCWINNT
     outf=stdout;
     initvid();
     mode=cat=0;
     iniwin();
     if (argc > 1) {
          if (sameas(argv[1],"/u")) {
               init();
               i=2;
               do {
                    stzcpy(inp,argv[i++],INPLEN);
                    ip=inp;
                    if (*ip == '/') {
                         ip++;
                         mode++;
                         cat=0;
                    }
                    switch (mode) {
                    case 0:
                    case 1:
                         if (!cat && strlen(ip) < (mode == 0 ? UIDSIZ
                                 : PNAMELEN)) {
                              strcpy(mode == 0 ? usr : pq,ip);
                              cat=1;
                         }
                         else if (strlen(mode == 0 ? usr : pq)+strlen(ip)
                      < (mode == 0 ? UIDSIZ : PNAMELEN)) {
                              strcat(mode == 0 ? usr : pq," ");
                              strcat(mode == 0 ? usr : pq,ip);
                         }
                         break;
                    case 2:
                         if (!cat) {
                              if (strlen(ip) == 0) {
                                   strcpy(out,DFTOUT);
                              }
                              else if (strlen(ip) < PTHFILSIZ) {
                                   strcpy(out,ip);
                              }
                              cat=1;
                         }
                         else if (strlen(ip)+strlen(out) < PTHFILSIZ) {
                              strcat(out,ip);
                         }
                    }
               } while (i < argc);
               usrrpt(usr,pq,out);
          }
          else if (sameas(argv[1],"/p")) {
               init();
               i=2;
               do {
                    stzcpy(inp,argv[i++],INPLEN);
                    ip=inp;
                    if (*ip == '/') {
                         ip++;
                         mode++;
                         cat=0;
                    }
                    switch(mode) {
                    case 0:
                         if (!cat && strlen(ip) < PNAMELEN) {
                              strcpy(pq,ip);
                              cat=1;
                         }
                         else if (strlen(ip)+strlen(pq)+1 < PNAMELEN) {
                              strcat(pq," ");
                              strcat(pq,ip);
                         }
                         break;
                    case 1:
                         if (!cat) {
                              if (strlen(ip) == 0) {
                                   strcpy(out,DFTOUT);
                              }
                              else if (strlen(ip) < PTHFILSIZ) {
                                   strcpy(out,ip);
                              }
                              cat=1;
                         }
                         else if (strlen(ip)+strlen(out) < PTHFILSIZ) {
                              strcat(out,ip);
                         }
                    }
               } while (i < argc);
               polrpt(pq,out);
          }
          else if (sameas(argv[1],"/q")) {
               init();
               i=2;
               do {
                    stzcpy(inp,argv[i++],INPLEN);
                    ip=inp;
                    if (*ip == '/') {
                         ip++;
                         mode++;
                         cat=0;
                    }
                    switch (mode) {
                    case 0:
                         if (!cat && strlen(ip) < PNAMELEN) {
                              strcpy(pq,ip);
                              cat=1;
                         }
                         else if (strlen(ip)+strlen(pq)+1 < PNAMELEN) {
                              strcat(pq," ");
                              strcat(pq,ip);
                         }
                         break;
                    case 1:
                         if (!cat) {
                              if (strlen(ip) == 0) {
                                   strcpy(out,DFTOUT);
                              }
                              else if (strlen(ip) < PTHFILSIZ) {
                                   strcpy(out,ip);
                              }
                              cat=1;
                         }
                         else if (strlen(ip)+strlen(out) < PTHFILSIZ) {
                              strcat(out,ip);
                         }
                    }
               } while (i < argc);
               qusrpt(pq,out);
          }
          else {
               scblank(NULL,curatr.attrib);
               explodeto(scntbl[3],0,0,79,22,0,0);
               locate(0,23);
               cursiz(GVIDLILCURS);
               pshutdown();
               return(0);
          }
          gohome(0);
          pshutdown();
          return(0);
     }
     else {
          init();
          while ((ropt=Getopt()) != -ESC) {
               if (ropt == 0) {
                    do {
                         if (uidrpt()) {
                              while ((opt=GetPoll(ropt)) != -ESC) {
                                   lodopt(opt);
                                   if (whrout()) {
                                        dourpt(1);
                                        break;
                                   }
                              }
                              free(polllst);
                              free(selptr);
                              opt=ESC;
                         }
                         else {
                              if (edtvalc != ESC) {
                                   scn2mem(savbak,0,GVIDSCNSIZ);
                                   explodeto(scntbl[0],0,19,41,22,18,14);
                                   proff(0,0);
                                   cursiz(GVIDNOCURS);
                                   if (getchc() == ESC) {
                                        break;
                                   }
                                   rstcur();
                                   mem2scn(savbak,0,GVIDSCNSIZ);
                              }
                              else {
                                   opt=ESC;
                              }
                         }
                    } while (opt != ESC);
               }
               else {
                    if (ispols(ropt)) {
                         while ((opt=GetPoll(ropt)) != -ESC) {
                              lodpol(opt,ropt);
                              if (ropt == 2) { /* questionnaire report      */
                       if (whrout()) {
                         dosrpt(1);
                                        break;
                                   }
                              }
                              else {              /* poll report           */
                                   if (whrout()) {
                                        doprpt(1);
                                        break;
                                   }
                              }
                         }
                         free(polllst);
                         free(selptr);
                    }
                    else {
                         scn2mem(scrsav1,0,GVIDSCNSIZ);
                         if (ropt == 1) {
                              explodeto(scntbl[0],45,19,78,23,23,10);
                         }
                         else {
                              explodeto(scntbl[0],45,14,78,18,23,10);
                         }
                         proff(0,0);
                         cursiz(GVIDNOCURS);
                         if (getchc() == ESC) {
                              break;
                         }
                         rstcur();
                         mem2scn(scrsav1,0,GVIDSCNSIZ);
                    }
               }
          }
     }
     gohome(1);
     pshutdown();
     return(0);
EXCEPT
#ifdef GCWINNT
     return(1);
#endif // GCWINNT
}

VOID
iniwin(VOID)                       /* initialize the windowing system      */
{
     INT i;

     scn2mem(dosscn,0,GVIDSCNSIZ);
     monorcol();
     for (i=0 ; i < 5 ; i++) {
          cvtscn(scntbl[i]);
     }
     cursiz(GVIDNOCURS);
}

VOID
init(VOID)
{
     sbb=dfaOpen("galpnqs2.dat",sizeof(struct pollstat),NULL);
     pbb=dfaOpen("galpnqp2.dat",sizeof(struct polldata),NULL);
     qbb=dfaOpen("galpnqq2.dat",sizeof(struct quesdata),NULL);
     abb=dfaOpen("galpnqa2.dat",sizeof(struct ansrdata),NULL);
     tbb=dfaOpen("galpnqt2.dat",sizeof(struct polltally),NULL);
     sp=(struct pollstat *)alczer(sizeof(struct pollstat));
     dp=(struct polldata *)alczer(sizeof(struct polldata));
     qp=(struct quesdata *)alczer(sizeof(struct quesdata));
     ap=(struct ansrdata *)alczer(sizeof(struct ansrdata));
}

VOID
dourpt(mode)
INT mode;
{
     INT done=0;
     CHAR *tps;

     explode(scntbl[2],0,0,79,24);
     locate(2,1);
     setatr(WHTBLU);
     printf(rpthdr[0],uid);
     setwin(0L,2,3,77,22,1);
     locate(2,3);
     setatr(WHTBLU);
     if (redir) {
          fprintf(outf,"\nUser Report for \"%s\", %s %s:\n",
               sp->uid,type[dp->polltype],dp->pname);
     }
     dfaSetBlk(qbb);
     ques=0;
     do {
          qcomp.qnum=ques++;
          strncpy(qcomp.pollname,sp->pname,PNAMELEN);
          if (dfaAcqEQ(qp,&qcomp,0)) {
               acomp.qnum=qp->qnum;
               strncpy(acomp.pollname,sp->pname,PNAMELEN);
               strncpy(acomp.uid,sp->uid,UIDSIZ);
               dfaSetBlk(abb);
               if (dfaAcqEQ(ap,&acomp,0)) {
                    for (tps=ap->answer ; *tps != '\0' ; tps++) {
                         if (*tps == '\r') {
                              line++;
                              *tps='\n';
                         }
                    }
                    if (mode && line > pagbrk) {
                         if (finup(0) == 0) {
                              done=1;
                         }
                    }
                    prfsp("\nAnswer for Question #%d: %s\n",
                 qp->qnum+1,qp->qtype == DISONLY ? "<Display Only>"
                 : ap->answer);
                    line++;
               }
               dfaRstBlk();
          }
          if (ques >= MAXQUES) {
               done=1;
          }
     } while (!done);
     if (mode) {
          printf("\nPress RETURN to continue.");
          getchc();
     }
     mem2scn(dosscn,0,GVIDSCNSIZ);
}

VOID
doprpt(mode)                       /* polls summary report                 */
INT mode;
{
     INT done=0;
     CHAR *tps;

     explode(scntbl[2],0,0,79,24);
     locate(2,1);
     setatr(WHTBLU);
     printf(rpthdr[1],type[dp->polltype],dp->pname);
     setwin(0L,2,3,77,22,1);
     locate(2,2);
     setatr(WHTBLU);
     if (redir) {
          fprintf(outf,"\nReport for %s '%s':\n",type[dp->polltype],dp->pname);
     }
     ques=0;
     do {
          dfaSetBlk(qbb);
          qcomp.qnum=ques++;
          strncpy(qcomp.pollname,dp->pname,PNAMELEN);
          if (dfaAcqEQ(qp,&qcomp,0)) {
               for (tps=qp->txtmsg ; *tps != '\0' ; tps++) {
                    if (*tps == '\r') {
                         line++;
                         *tps='\n';
                    }
               }
               if (mode && line > pagbrk) {
                    if (finup(0) == 0) {
                         done=1;
                    }
               }
               if (ismult()) {
                    if (ShowMult(mode) == 0) {
                         done=1;
                    }
               }
               prfsp("\n");
               line++;
               if (mode && finup(0) == 0) {
                    done=1;
               }
               else {
                    setatr(WHTBLU);
                    printf("\f");
                    locate(2,2);
               }
          }
          if (ques >= MAXQUES) {
               done=1;
          }
     } while (!done);
     mem2scn(scrsav3,0,GVIDSCNSIZ);
}

VOID
dosrpt(mode)                       /* questionnaires summary report        */
INT mode;
{
     INT done=0,ques,fnd;
     CHAR *tps;

     explode(scntbl[2],0,0,79,24);
     setatr(YELBLU);
     locate(2,1);
     setatr(WHTBLU);
     printf(rpthdr[2],type[dp->polltype],dp->pname);
     setwin(0L,2,3,77,22,1);
     locate(2,3);
     setatr(WHTBLU);
     if (redir) {
          fprintf(outf,"\nReport for %s '%s':\n",type[dp->polltype],dp->pname);
     }
     ques=0;
     do {
          dfaSetBlk(qbb);
          qcomp.qnum=ques++;
          strncpy(qcomp.pollname,dp->pname,PNAMELEN);
          if (dfaAcqEQ(qp,&qcomp,0)) {
               for (tps=qp->txtmsg ; *tps != '\0' ; tps++) {
                    if (*tps == '\r') {
                         line++;
                         *tps='\n';
                    }
               }
               if (mode && line > pagbrk) {
                    if (finup(0) == 0) {
                         done=1;
                    }
               }
               if (ismult()) {
                    if (ShowMult(mode) == 0) {
                         done=1;
                    }
               }
               else {
                    setatr(WHTBLU);
                    prfsp("\nQuestion #%d:\n",qp->qnum+1);
                    setatr(GRNBLU);
                    prfsp("%s\n",qp->txtmsg);
               }
               prfsp("\n");
               line++;
               if (mode && finup(0) == 0) {
                    done=1;
               }
               else {
                    setatr(WHTBLU);
                    printf("\f");
                    locate(2,2);
               }
          }
          if (ques >= MAXQUES) {
               done=1;
          }
     } while (!done);
     ques=0;
     dfaSetBlk(abb);
     if (dfaAcqLO(ap,2)) {
          do {
               qcomp.qnum=ques;
               strncpy(qcomp.pollname,dp->pname,PNAMELEN);
               dfaSetBlk(qbb);
               if (dfaAcqEQ(qp,&qcomp,0)) {
                    fnd=0;
                    do {
                         acomp.qnum=qp->qnum;
                         strncpy(acomp.pollname,dp->pname,PNAMELEN);
                         strncpy(acomp.uid,ap->uid,UIDSIZ);
                         dfaSetBlk(abb);
                         if (dfaAcqEQ(ap,&acomp,0)) {
                              if (!sameas(ap->pollname,dp->pname)) {
                                   break;
                              }
                              if (fnd == 0) {
                                   setatr(WHTBLU);
                                   prfsp("\nAnswers for User-ID \"%s\":\n\n",
                                        ap->uid);
                                   line+=4;
                                   fnd=1;
                              }
                              for (tps=ap->answer ; *tps != '\0' ; tps++) {
                                   if (*tps == '\r') {
                                        *tps='\n';
                                        line++;
                                   }
                              }
                              setatr(GRNBLU);
                              prfsp("Question #%d: %s\n",
                                   qp->qnum+1,ap->answer);
                              if (line++ > pagbrk) {
                                   if (mode && finup(0) == 0) {
                                        mem2scn(scrsav3,0,GVIDSCNSIZ);
                                        return;
                                   }
                              }
                         }
                         qcomp.qnum++;
                         dfaRstBlk();
                    } while (dfaAcqEQ(qp,&qcomp,0));
               }
               dfaSetBlk(abb);
          } while (dfaAcqGT(ap,ap->uid,2));
     }
     if (mode) {
          finup(1);
     }
     mem2scn(scrsav3,0,GVIDSCNSIZ);
}

INT
ismult(VOID)
{
     if (qp->qtype == 4 || qp->qtype == 7 || qp->qtype == 8) {
          return(1);
     }
     return(0);
}

INT
ShowMult(                          /* show multiple choice answers         */
INT mode)
{
     INT i,showstat=0,tot=0;

     dfaSetBlk(tbb);
     if (dfaAcqEQ(&tally,dp->pname,0)) {
          showstat=1;
          for (i=0,tot=0 ; i < MAXASTGS ; i++) {
               tot+=tally.answer[qp->qnum][i];
          }
          if (tot == 0) {
               showstat=0;
          }
     }
     setatr(WHTBLU);
     if (dp->polltype == 1) {
          prfsp("\nQuestion #%d (%d response%s):\n",qp->qnum+1,tot,
               tot == 1 ? "" : "s");
     }
     else {
          prfsp("\nQuestion #%d:\n",qp->qnum+1);
     }
     setatr(GRNBLU);
     prfsp("%s\n",qp->txtmsg);
     line+=2;
     for (i=0 ; i < MAXASTGS ; i++) {
          if (strlen(qp->ansstg[i]) > 0) {
               line++;
               setatr(CYNBLU);
               prfsp("\n%c",(CHAR)(65+i));
               setatr(YELBLU);
               prfsp(" ... %-35.35s",qp->ansstg[i]);
               if (showstat) {
                    setatr(GRNBLU);
                    prfsp(" %s ",rsltper(tally.answer[qp->qnum][i],tot));
                    setatr(WHTBLU);
                    printf("[");
                    setatr(YELBLU);
                    prfsp("%-22.22s",bargph(22,tally.answer[qp->qnum][i],tot));
                    setatr(WHTBLU);
                    printf("]");
               }
          }
          if (mode && line > pagbrk) {
               if (finup(0) == 0) {
                    return(0);
               }
          }
     }
     return(1);
}

VOID
gohome(mode)                       /* get ready to go back to DOS now      */
INT mode;
{
     setatr(0x07);
     printf(" ");
     locate(0,24);
     if (mode == 1) {
          mem2scn(dosscn,0,GVIDSCNSIZ);
     }
     cursiz(GVIDLILCURS);
}


INT
Getopt(VOID)                       /* get main option                      */
{
     INT savexp;
     static INT first=1;

     if (first) {
          first=0;
          explodeto(scntbl[0],0,0,55,13,12,4);
     }
     else {
          mem2scn(dosscn,0,GVIDSCNSIZ);
          savexp=explodem;
          explodem=0;
          explodeto(scntbl[0],0,0,55,13,12,4);
          explodem=savexp;
     }
     expuid=explst=1;
     proff(0,0);
     selatr=YELWHT;
     nslatr=YELCYN;
     return(choose(3,repopts,19,12,59,15,TRUE));
}

INT
GetPoll(mode)                      /* get poll to use                      */
INT mode;
{
     INT savexp;

     explst2=1;
     if (explst) {
          explst=0;
          explodeto(scntbl[1],0,0,43,13,18,6);
          locate(30,6);
          setatr(BLKWHT);
          printf("%s ",mode == 2 ? "Questionnaire"
           : mode == 1 ? "Poll" : "Poll or Questionnaire");
     }
     else {
          savexp=explodem;
          explodem=0;
          explodeto(scntbl[1],0,0,43,13,18,6);
          locate(30,6);
          setatr(BLKWHT);
          printf("%s ",mode == 2 ? "Questionnaire"
           : mode == 1 ? "Poll" : "Poll or Questionnaire");
          explodem=savexp;
     }
     proff(0,0);
     selatr=YELWHT;
     nslatr=YELCYN;
     return(choose(cnt,selptr,25,10,54,16,TRUE));
}

INT
uidrpt(VOID)                       /* User-ID report option                */
{
     INT savexp;

     setmem(uid,UIDSIZ,0);
     if (expuid) {
          expuid=0;
          explodeto(scntbl[0],0,14,44,18,18,10);
     }
     else {
          savexp=explodem;
          explodem=0;
          explodeto(scntbl[0],0,14,44,18,18,10);
          explodem=savexp;
     }
     proff(0,0);
     setatr(WHTBLK);
     rstcur();
     if (edtval(30,12,UIDSIZ,uid,val_uid,0)) {
          cursiz(GVIDNOCURS);
          setatr(WHTBLK);
          locate(30,12);
          fmtuid(uid);
          printf("%s",uid);
          if (haspols()) {
               return(1);
          }
     }
     return(0);
}

INT
getpqo(VOID)                       /* get poll and questionnaire option    */
{
     if (explst2) {
          explst2=0;
          explodeto(scntbl[1],43,13,78,20,20,8);
     }
     else {
          mem2scn(scrsav3,0,GVIDSCNSIZ);
     }
     proff(0,0);
     selatr=YELWHT;
     nslatr=YELCYN;
     return(choose(2,pqopts,23,12,51,13,TRUE));
}

INT
haspols(VOID)                      /* check a specific User-ID for pnq's   */
{
     INT i,j;
     CHAR tmp[PSSIZ];

     cnt=0;
     dfaSetBlk(sbb);
     if (dfaAcqEQ(sp,uid,1)) {
          do {
               dfaSetBlk(pbb);
               if (dfaAcqEQ(dp,sp->pname,0)) {
                    if (!(dp->flags&DELFLAG)) {
                         cnt++;
                    }
               }
               dfaRstBlk();
          } while (dfaAcqNX(sp));
          if (cnt == 0) {
               return(0);
          }
          polllst=alczer(cnt*PSSIZ);
          selptr=(CHAR **)alczer((cnt+1)*sizeof(CHAR *));
          for (i=0 ; i < cnt ; i++) {
               selptr[i]=&polllst[i*PSSIZ];
          }
          selptr[cnt]=NULL;
          for (i=0 ; i < cnt ; ) {
               if (i == 0) {
                    dfaAcqEQ(sp,uid,1);
               }
               else {
                    dfaAcqNX(sp);
               }
               dfaSetBlk(pbb);
               if (dfaAcqEQ(dp,sp->pname,0)) {
                    if (!(dp->flags&DELFLAG)) {
                         setmem(tmp,PSSIZ,0);
                         strcpy(tmp," ");
                         strcat(tmp,dp->pname);
                         for (j=strlen(tmp) ; j < PSSIZ ; j++) {
                              tmp[j]=' ';
                         }
                         tmp[PSSIZ-1]='\0';
                         strcpy(&polllst[i*PSSIZ],tmp);
                         i++;
                    }
               }
               dfaRstBlk();
          }
          return(1);
     }
     return(0);
}


INT
ispols(mode)                       /* check for presence of any pnq's      */
INT mode;
{
     INT i,j,first;
     CHAR tmp[PSSIZ];

     cnt=0;
     dfaSetBlk(pbb);
     if (dfaQueryLO(0)) {
          do {
               dfaAbsRec(dp,0);
               if (!(dp->flags&DELFLAG) && dp->polltype == mode) {
                    cnt++;
               }
          } while (dfaQueryNX());
          if (cnt == 0) {
               return(0);
          }
          polllst=alczer(cnt*PSSIZ);
          selptr=(CHAR **)alczer((cnt+1)*sizeof(CHAR *));
          for (i=0 ; i < cnt ; i++) {
               selptr[i]=&polllst[i*PSSIZ];
          }
          selptr[cnt]=NULL;
          for (i=0,first=1 ; i < cnt ; ) {
               dfaSetBlk(pbb);
               if (first) {
                    dfaQueryLO(0);
                    first=0;
               }
               else {
                    dfaQueryNX();
               }
               dfaAbsRec(dp,0);
               if (!(dp->flags&DELFLAG) && dp->polltype == mode) {
                    setmem(tmp,PSSIZ,0);
                    strcpy(tmp," ");
                    strcat(tmp,dp->pname);
                    for (j=strlen(tmp) ; j < PSSIZ ; j++) {
                         tmp[j]=' ';
                    }
                    tmp[PSSIZ-1]='\0';
                    strcpy(&polllst[i*PSSIZ],tmp);
                    i++;
               }
          }
          return(1);
     }
     return(0);
}

GBOOL
val_uid(
INT c,
CHAR *stg)                         /* valid User-ID entry routine          */
{
     (VOID)stg;
     return(isuidc(c));
}

GBOOL
valout(
INT c,
CHAR *stg)                         /* check for valid output device        */
{
     switch(c) {
     case '1':
          strcpy(stg,"1");
          break;
     case '2':
          strcpy(stg,"2");
          break;
     case '3':
          strcpy(stg,"3");
          break;
     default:
          return(TRUE);
     }
     return(FALSE);
}

GBOOL
valfil(                            /* validate file name                   */
INT c)
{
     if (c <= 255 && isprint(c)) {
          return(TRUE);
     }
     return(FALSE);
}

VOID
lodopt(opt)                        /* load up selected option              */
INT opt;
{
     INT cnt=0;
     dfaSetBlk(sbb);
     if (dfaAcqEQ(sp,uid,1)) {
          do {
               dfaSetBlk(pbb);
               if (dfaAcqEQ(dp,sp->pname,0)) {
                    if (!(dp->flags&DELFLAG)) {
                         if (opt == cnt++) {
                              dfaRstBlk();
                              return;
                         }
                    }
               }
               dfaRstBlk();
          } while (dfaAcqNX(sp));
     }
}

VOID
lodpol(opt,mode)                   /* load up selected pnq                 */
INT opt;
INT mode;
{
     INT cnt=0;
     dfaSetBlk(pbb);
     dfaQueryLO(0);
     do {
          dfaAbsRec(dp,0);
          if (!(dp->flags&DELFLAG) && dp->polltype == mode) {
               if (opt == cnt++) {
                    dfaRstBlk();
                    return;
               }
          }
     } while (dfaQueryNX());
}

INT
whrout(VOID)                       /* find out where to put output         */
{
     scn2mem(scrsav3,0,GVIDSCNSIZ);
     strcpy(repchr,"1");
     explodeto(scntbl[1],0,14,37,23,19,8);
     do {
          rstcur();
          if (!(edtval(51,16,sizeof(repchr),repchr,valout,0))) {
               return(0);
          }
     } while(repchr[0] == '\0');
     switch (repchr[0]) {
     case '1':
          outnam[0]='\0';
          pagbrk=17;
          line=-1;
          redir=0;
          break;
     case '2':
          pagbrk=0;
          line=-1;
          strcpy(inpnam,"PRN");
          if ((outf=fopen(inpnam,FOPWA)) == NULL) {
               scn2mem(scrsav2,0,GVIDSCNSIZ);
               explodeto(scntbl[1],44,0,76,3,19,7);
               getchc();
               mem2scn(scrsav2,0,GVIDSCNSIZ);
               inpnam[0]='\0';
          }
          redir=1;
          break;
     case '3':
          pagbrk=17;
          line=-1;
          if (getfil()) {
               strcpy(outnam,inpnam);
               redir=1;
          }
          else {
               mem2scn(scrsav3,0,GVIDSCNSIZ);
               inpnam[0]='\0';
               return(0);
          }
          break;
     }
     mem2scn(scrsav3,0,GVIDSCNSIZ);
     return(1);
}

INT
getfil(VOID)                       /* if out to file, get the file name    */
{
     inpnam[0]='\0';
     scn2mem(scrsav2,0,GVIDSCNSIZ);
     explodeto(scntbl[1],44,8,77,12,22,9);
     do {
          if (!edtval(35,12,sizeof(inpnam),inpnam,valfil,0)) {
               mem2scn(scrsav2,0,GVIDSCNSIZ);
               return(0);
          }
          if (!rsvnam(inpnam)) {
               if ((outf=fopen(inpnam,FOPWA)) == NULL) {
                    scn2mem(scrsav2,0,GVIDSCNSIZ);
                    explodeto(scntbl[1],44,4,76,7,22,9);
                    getchc();
                    mem2scn(scrsav2,0,GVIDSCNSIZ);
                    inpnam[0]='\0';
               }
          }
          else {
               scn2mem(scrsav2,0,GVIDSCNSIZ);
               explodeto(scntbl[1],44,4,76,7,22,9);
               getchc();
               mem2scn(scrsav2,0,GVIDSCNSIZ);
               inpnam[0]='\0';
          }
     } while (inpnam[0] == '\0');
     return(1);
}

static
VOID
prfsp(CHAR *fmat,...)              /* print to proper places during output */
{
     va_list args;
     CHAR buffer[1024];

     va_start(args,fmat);
     vsprintf(buffer,fmat,args);
     va_end(args);
     if (redir) {
          fprintf(outf,"%s",buffer);
     }
     printf("%s",buffer);
}


INT
finup(mode)                        /* Hit any key to continue              */
INT mode;
{
     INT c,savex,savey;

     savex=curcurx();
     savey=curcury();
     setatr(BLKWHT);
     locate(18,23);
     if (mode == 0) {
          printf("<< Hit Any Key to Continue or ESC to abort >>");
     }
     else {
          printf("<<  End of Report Hit Any Key to Continue  >>");
     }
     c=getchc();
     setatr(CYNBLU);
     locate(18,23);
     printf("");
     if (c == ESC) {
          return(0);
     }
     else {
          line=-1;
          locate(savex,savey);
          return(1);
     }
}

VOID
usrrpt(usr,pq,out)                 /* user report                          */
CHAR *usr, *pq, *out;
{
     CHAR *op=strupr(out);

     fmtuid(usr);
     stzcpy(scomp.uid,usr,UIDSIZ);
     stzcpy(scomp.pname,strupr(pq),PNAMELEN);
     dfaSetBlk(sbb);
     if (dfaAcqEQ(sp,&scomp,0)) {
          dfaSetBlk(pbb);
          if (dfaAcqEQ(dp,sp->pname,0)) {
               if (!(dp->flags&DELFLAG)) {
                    switch(*op) {
                    case 'S':
                         outnam[0]='\0';
                         pagbrk=17;
                         line=-1;
                         redir=0;
                         break;
                    case 'P':
                         pagbrk=0;
                         line=-1;
                         strcpy(inpnam,"PRN");
                         if ((outf=fopen(inpnam,FOPWA)) == NULL) {
                              explodeto(scntbl[1],44,0,76,3,19,7);
                              *op='\0';
                              return;
                         }
                         redir=1;
                         break;
                    case 'F':
                         op++;
                         if (!rsvnam(op)) {
                              if ((outf=fopen(op,FOPWA)) == NULL) {
                                   explodeto(scntbl[1],44,4,76,7,22,9);
                                   gcdelay(500);
                                   *op='\0';
                              }
                              else {
                                   stamp();
                              }
                         }
                         else {
                              explodeto(scntbl[1],44,4,76,7,22,9);
                              gcdelay(500);
                              *op='\0';
                         }
                         strcpy(outnam,op);
                         if (strlen(outnam) > 0) {
                              redir=1;
                         }
                    }
                    dourpt(0);
                    gcdelay(500);
               }
          }
     }
}

VOID
polrpt(poll,out)                   /* poll report                          */
CHAR *poll, *out;
{
     CHAR *op=strupr(out);

     dfaSetBlk(pbb);
     if (dfaAcqEQ(dp,strupr(poll),0)) {
          if (!(dp->flags&DELFLAG)) {
               switch(*op) {
               case 'S':
                    outnam[0]='\0';
                    pagbrk=17;
                    line=-1;
                    redir=0;
                    break;
               case 'P':
                    pagbrk=0;
                    line=-1;
                    strcpy(inpnam,"PRN");
                    if ((outf=fopen(inpnam,FOPWA)) == NULL) {
                         explodeto(scntbl[1],44,0,76,3,19,7);
                         *op='\0';
                         return;
                    }
                    redir=1;
                    break;
               case 'F':
                    op++;
                    if (!rsvnam(op)) {
                         if ((outf=fopen(op,FOPWA)) == NULL) {
                              explodeto(scntbl[1],44,4,76,7,22,9);
                              gcdelay(500);
                              *op='\0';
                         }
                         else {
                              stamp();
                         }
                    }
                    else {
                         explodeto(scntbl[1],44,4,76,7,22,9);
                         gcdelay(500);
                         *op='\0';
                    }
                    strcpy(outnam,op);
                    if (strlen(outnam) > 0) {
                         redir=1;
                    }
               }
               doprpt(0);
               gcdelay(500);
          }
     }

}

VOID
qusrpt(                            /* questionnaire report                 */
CHAR *ques,
CHAR *out)
{
     CHAR *op=strupr(out);

     dfaSetBlk(pbb);
     if (dfaAcqEQ(dp,strupr(ques),0)) {
          if (!(dp->flags&DELFLAG)) {
               switch(*op) {
               case 'S':
                    outnam[0]='\0';
                    pagbrk=17;
                    line=-1;
                    redir=0;
                    break;
               case 'P':
                    pagbrk=0;
                    line=-1;
                    strcpy(inpnam,"PRN");
                    if ((outf=fopen(inpnam,FOPWA)) == NULL) {
                         explodeto(scntbl[1],44,0,76,3,19,7);
                         *op='\0';
                         return;
                    }
                    redir=1;
                    break;
               case 'F':
                    op++;
                    if (!rsvnam(op)) {
                         if ((outf=fopen(op,FOPWA)) == NULL) {
                              explodeto(scntbl[1],44,4,76,7,22,9);
                              gcdelay(500);
                              *op='\0';
                         }
                         else {
                              stamp();
                         }
                    }
                    else {
                         explodeto(scntbl[1],44,4,76,7,22,9);
                         gcdelay(500);
                         *op='\0';
                    }
                    strcpy(outnam,op);
                    if (strlen(outnam) > 0) {
                         redir=1;
                    }
               }
               dosrpt(0);
               gcdelay(500);
          }
     }
}

VOID
fmtuid(stg)                        /* format User-ID                       */
CHAR *stg;
{
     CHAR *inpptr;
     INT space=1,format;

     stripb(stg);
     format=isuplo(stg);
     for (inpptr=stg ; *inpptr != '\0' ; inpptr++) {
          if (format) {
               if (*inpptr == ' ') {
                    space=1;
               }
               else if (space) {
                    *inpptr=toupper(*inpptr);
                    space=0;
               }
               else {
                    *inpptr=tolower(*inpptr);
               }
          }
     }
     while (++inpptr-stg < UIDSIZ) {
          *inpptr='\0';
     }
}

INT
isuplo(stg)                        /* is stg formated correctly up/low case*/
CHAR *stg;
{
     CHAR *ptr;

     for (ptr=stg ; *ptr != '\0' ; ptr++) {
          if (isalpha(*ptr) && !islower(*ptr)) {
               break;
          }
     }
     if (*ptr == '\0') {
          return(1);
     }
     for (ptr=stg ; *ptr != '\0' ; ptr++) {
          if (isalpha(*ptr) && !isupper(*ptr)) {
               break;
          }
     }
     if (*ptr == '\0') {
          return(1);
     }
     return(0);
}

VOID
stripb(stg)                        /* "strip" blank spaces after input     */
CHAR *stg;
{
     INT len;
     CHAR *inpptr;

     len=strlen(stg);
     for (inpptr=stg+len-1 ; inpptr >= stg && isspace(*inpptr) ; ) {
          *inpptr--='\0';
     }
}

VOID
pshutdown(VOID)                     /* system shutdown routine              */
{
     dfaClose(sbb);
     dfaClose(pbb);
     dfaClose(qbb);
     dfaClose(abb);
     dfaClose(tbb);
     fclose(outf);
     clsvid();
}

VOID
stamp(VOID)                        /* output date and time                 */
{
     fprintf(outf,"%s %s\n",ncdatel(today()),nctime(now()));
}

CHAR *
rsltper(                           /* results percentage calculation       */
INT num,
INT tot)
{
     LONG comp;

     if (tot == 0) {
          comp=0L;
     }
     else {
          comp=(LONG)num*1000L/(LONG)tot;
          comp-=comp/10L*10L;
     }
     return(spr("(%3ld.%1.1ld%%)",tot == 0 ? 0L : (LONG)num*100L/(LONG)tot,
          tot == 0 ? 0L : comp));
}
