/***************************************************************************
 *                                                                         *
 *   RESETSYN.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Reset Poll Synthesis Class.                                           *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "resetsyn.h"
#include "dnfmgr.h"
#include "majorbbs.h"

#define FILREV "$Revision: 3 $"

#define RESETDIR "reset/"

enum {RESETPARAM,RESETWORK,RESETRESP};

// dynafile stuff

dnfStep dnfRstErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfRstDefSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfRstErrMap(PPFIX RESETDIR "error.htm","Reset Error Steps",dnfRstErrSteps);
dnfMap dnfRstDefMap(PPFIX RESETDIR "index.htm","Reset Index Steps",dnfRstDefSteps);

// class method defs

MARKSOURCE(resetsyn);

resetSynthesis::resetSynthesis(   // default constructor
                   acthSession *_ses):// session object
                   pManSynthesis(_ses)
{
     m_ahState=RESETPARAM;
}

resetSynthesis::~resetSynthesis() // destructor
{
     if (m_pPoll != NULL) {
          delete m_pPoll;
          m_pPoll=NULL;
     }
}

ACTHCODE
resetSynthesis::proceed()        // proceed entry point
{
     ACTHCODE retval;
     bool error=false;
     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }
     if (m_cyc.start()) {
          do {
               switch (m_ahState) {
               case RESETPARAM:
                    GETPARAMVAL("pollname");
                    if (m_pValBuf[0] == '\0') {
                         setError(NOPARAM,"pollname");
                         error=true;
                    }
                    else if (!m_pAPI->isPoll(m_pValBuf)) {
                         setError(POLLNFND,m_pValBuf);
                         error=true;
                    }
                    if (error) {
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfRstErrMap,PPFIX);
                         m_ahState=RESETRESP;
                    }
                    else {
                         m_pPoll=new poll(m_pValBuf);
                         m_ahState=RESETWORK;
                    }
                    break;
               case RESETWORK:
                    if (m_pAPI->resetAnswers(m_pPoll->getName())) {
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfRstDefMap,PPFIX);
                         m_ahState=RESETRESP;
                    }
                    bout << "<!---->";  // keep-alive
                    break;
               case RESETRESP:
                    retval=dynafile();
                    break;
               }
          } while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}
