/***************************************************************************
 *                                                                         *
 *   POLLAPI.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll API Class.                                                       *
 *                                                  - N.C. Osterc  9/11/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __POLLAPI_H
#define __POLLAPI_H

#pragma option -w-aus
#include <deque>
#pragma option -w-aus
#include "poll.h"
#include "cyctimer.h"
#include "mapcomp.h"

typedef deque <const CHAR *> POLLQUEUE, *PPOLLQUEUE;
typedef std::map<mapCompare, CHAR *, less<mapCompare> > CLSDATEMMAP;
typedef std::map<mapCompare, CHAR *, less<mapCompare> > CRTDATEMMAP;

extern bool g_mapsInited;                            // have maps been inited?
extern VOID (*oldMod)(const struct polldata);         // old vector

extern CLSDATEMMAP g_mMapClose;
extern CRTDATEMMAP g_mMapCreate;

VOID
updateMap(                               // update map
const struct polldata pdata);

class pollAPI {
public:

     pollAPI();                    // default constructor

     ~pollAPI();                   // destructor

     bool
     isPoll(                       // is this a valid poll?
     const CHAR *pollname);

     bool                          // returns false when done
     resetAnswers(                 // reset answers for poll
     const CHAR *pollname);        // poll to reset answers for

     bool                          // returns false when done
     clearTallyAndStat(            // clear tally and stats
     struct pollstat pStat,        // status structure
     poll *p);                     // poll object pointer

     const CHAR *
     getPollNameHi();              // hi poll name

     poll *                        // poll object or NULL
     getPollEQ(                    // get poll by its name
     const CHAR *pollname);        // exact name

     poll *
     getPollGE(                    // get greater-than equal poll
     const CHAR *startString);

     poll *
     getPollGT(                    // get greater-than poll
     const CHAR *startString);

     poll *
     getPollLE(                    // get less-than-equal poll
     const CHAR *startString);

     poll *
     getPollLT(
     const CHAR *startString);     // get less-than poll

     PPOLLQUEUE
     getQueuePtr();                // get pointer to queue object

     const CHAR *
     pollDateLow(                  // get poll name w/ lowest date
     bool create);

     const CHAR *
     pollDateHi(                   // get poll name w/ highest date
     bool create);

     const CHAR *
     getDateGE(                    // is there a poll greater-than-equal
     bool create,                  // create or close?
     USHORT date);                 // polldate

     const CHAR *
     getDateLE(                    // is there a poll less-than equal
     bool create,                  // create or close?
     USHORT date);                 // poll date

     const CHAR *
     getDateGT(                    // is there a poll greater?
     const CHAR *pollname,         // pollname
     bool create,                  // create or close?
     USHORT date);                 // poll date

     const CHAR *
     getDateLT(                    // is there a poll less?
     const CHAR *pollname,         // poll name
     bool create,                  // create or close?
     USHORT date);                 // poll date

     const CHAR *
     getDateEQ(                    // is there a poll equal
     const CHAR *pollname,         // poll name
     bool create,                  // create or close?
     USHORT date);                 // poll date

     VOID
     setFrames(                    // set frames
     bool on,                      // set on or off
     const CHAR *userid);          // the userid

     bool
     getSettings(                  // get all settings
     LONG *settings,               // pointer to pointer to get settings into
     const CHAR *userid);          // userid in question

     bool
     userFramesOn(                 // are frames on for this user?
     const CHAR *userid);          // the userid

     bool
     userFramesOff(                // are frames off for this user?
     const CHAR *userid);          // the userid

     VOID
     initMaps();                   // initialize our maps

     VOID
     emptyQueue();                 // empty out queue

     VOID
     pushBackQueue(                // push back a poll name
     const CHAR *pollname);

     VOID
     pushFrontQueue(               // push front a poll name
     const CHAR *pollname);

private:

     VOID
     deletePollPtr();              // delete and NULL m_pollPtr

     poll *m_pollPtr;              // pointer to poll
     struct polldata m_pdata;      // poll data structure instance
     USHORT m_date;                // date being used
     PPOLLQUEUE m_pQueue;          // pointer to poll queue
     CLSDATEMMAP::iterator m_cli;  // close map iterator
     CRTDATEMMAP::iterator m_cri;  // create map iterator
     SHORT m_curAnswer;            // current answer
     LONG m_savPos;                // save the current btrieve position
     struct ansrdata m_adata;      // answer data structure instance
};

#endif                             // __POLLAPI_H
