/***************************************************************************
 *                                                                         *
 *   PMANVAR.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll Variables Class.                                                 *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __PMANVAR_H
#define __PMANVAR_H

#undef min(a,b)
#undef max(a,b)

#include "enctvb.h"
#include "poll.h"
#include "question.h"
#include "pmanmsg.h"

#define SEL "SELECTED"
#define SPRINTFSIZ 1024

class pManVar {                    // Class objectifies "poll-manager" text variables
public:

     pManVar();                    // default constructor (not used)

     ~pManVar();                   // destructor

     VOID
     setPollEditVbs(               // set up poll variables
     poll *pobj);

     VOID
     setQuesEditVbs(               // set up question variables
     question *qobj);

     VOID
     setQuesListVbs(               // set up question list variables
     question *qobj);

     VOID
     setVarsDefault();             // clear all text variables

     const CHAR *
     format(                       // format a string
     const CHAR *fmt,              // string to format
     ...);                         // specifiers

private:

     pManMsg *m_pMessage;          // pointer to poll-manager message object
     CHAR m_formatBuf[SPRINTFSIZ]; // buffer used to put formatting string in
};

// Text variable declarations

extern htmlEncodedTvb t_ErrMessage;                // PMAN_ERR_MESSAGE
extern urlEncodedTvb t_UrlPollName;                // PMAN_NAME_U
extern htmlEncodedTvb t_PollName;                  // PMAN_NAME
extern htmlEncodedTvb t_PollDesc;                  // PMAN_DESC

// poll/edit Tvbs

extern basicTvb t_AccessKey;                       // PMAN_ACCESS_KEY
extern basicTvb t_AccumSel;                        // PMAN_ACCU_SELECTED
extern basicTvb t_AnnounceSel;                     // PMAN_ANNO_SELECTED
extern basicTvb t_AsciiSel;                        // PMAN_ASCII_SELECTED
extern basicTvb t_AskSel;                          // PMAN_ASK_SELECTED
extern basicTvb t_BothSel;                         // PMAN_BOTH_SELECTED
extern basicTvb t_BtrieveSel;                      // PMAN_BTRIEVE_SELECTED
extern basicTvb t_CloseDate;                       // PMAN_CLDATE
extern basicTvb t_CreateDate;                      // PMAN_CRDATE
extern basicTvb t_NoClearScrSel;                   // PMAN_DCNO_SELECTED
extern basicTvb t_YesClearScrSel;                  // PMAN_DCYES_SELECTED
extern basicTvb t_DimSel;                          // PMAN_DIM_SELECTED
extern basicTvb t_DiscardSel;                      // PMAN_DISC_SELECTED
extern basicTvb t_Class2Grant;                     // PMAN_GRANT_CLASS
extern basicTvb t_Creds2Grant;                     // PMAN_GRANT_CREDS
extern basicTvb t_File2Grant;                      // PMAN_GRANT_FILE
extern basicTvb t_Key2Grant;                       // PMAN_GRANT_KEY
extern basicTvb t_HideSel;                         // PMAN_HIDE_SELECTED
extern basicTvb t_InsistSel;                       // PMAN_INSIST_SELECTED
extern basicTvb t_IsCreate;                        // PMAN_ISCREATE
extern basicTvb t_LogonKey;                        // PMAN_LOGON_KEY
extern basicTvb t_LookupKey;                       // PMAN_LOOKUP_KEY
extern basicTvb t_ResultsKey;                      // PMAN_RESULTS_KEY
extern basicTvb t_OnceSel;                         // PMAN_ONCE_SELECTED
extern basicTvb t_TypePollSel;                     // PMAN_PTPOLL_SELECTED
extern basicTvb t_TypeQuesSel;                     // PMAN_PTQUES_SELECTED
extern basicTvb t_ReplaceSel;                      // PMAN_REPL_SELECTED
extern basicTvb t_NoSaveBrSel;                     // PMAN_SBNO_SELECTED
extern basicTvb t_YesSaveBrSel;                    // PMAN_SBYES_SELECTED
extern basicTvb t_ShowSel;                         // PMAN_SHOW_SELECTED
extern basicTvb t_SkipSel;                         // PMAN_SKIP_SELECTED

// question/edit tvbs

extern basicTvb t_NumAnswerChoices;                // PMAN_ANSCHOICE_NUM
extern basicTvb t_CCSel;                           // PMAN_CREDIT_SELECTED
extern basicTvb t_DateSel;                         // PMAN_DATE_SELECTED
extern basicTvb t_DisplaySel;                      // PMAN_DISPLAY_SELECTED
extern basicTvb t_NoEnableBr;                      // PMAN_EBNO_SELECTED
extern basicTvb t_YesEnableBr;                     // PMAN_EBYES_SELECTED
extern basicTvb t_MultiSel;                        // PMAN_MULTI_SELECTED
extern basicTvb t_NumericSel;                      // PMAN_NUMERIC_SELECTED
extern basicTvb t_OpenSel;                         // PMAN_OPEN_SELECTED
extern basicTvb t_NoClsSel;                        // PMAN_QCLSNO_SELECTED
extern basicTvb t_YesClsSel;                       // PMAN_QCLSYES_ISCREATE
extern basicTvb t_QIsCreate;                       // PMAN_QEDIT_ISCREATE
extern basicTvb t_IsPoll;                          // PMAN_QEDIT_ISPOLL
extern basicTvb t_Next;                            // PMAN_QEDIT_NEXT
extern basicTvb t_Prev;                            // PMAN_QEDIT_PREV
extern basicTvb t_TfSel;                           // PMAN_TF_SELECTED
extern basicTvb t_UacSel;                          // PMAN_UAC_SELECTED
extern basicTvb t_NoExemptSel;                     // PMAN_XMTNO_SELECTED
extern basicTvb t_YesExemptSel;                    // PMAN_XMTYES_SELECTED
extern basicTvb t_YesNoSel;                        // PMAN_YN_SELECTED
extern basicTvb t_NameSel;                         // PMAN_NAME_SELECTED
extern basicTvb t_Adr1Sel;                         // PMAN_ADR1_SELECTED
extern basicTvb t_Adr2Sel;                         // PMAN_ADR2_SELECTED
extern basicTvb t_Adr3Sel;                         // PMAN_ADR3_SELECTED
extern basicTvb t_Adr4Sel;                         // PMAN_ADR4_SELECTED
extern basicTvb t_PhoneSel;                        // PMAN_PHONE_SELECTED
extern basicTvb t_BdaySel;                         // PMAN_BIRTHDAY_SELECTED
extern basicTvb t_SexSel;                          // PMAN_SEX_SELECTED
extern basicTvb t_AnsiSel;                         // PMAN_ANSI_SELECTED
extern basicTvb t_EditorSel;                       // PMAN_EDITOR_SELECTED
extern basicTvb t_PasswordSel;                     // PMAN_PASSWORD_SELECTED

extern htmlEncodedTvb t_AnswerString1;             // PMAN_QEDIT_ANSSTG1
extern htmlEncodedTvb t_AnswerString2;             // PMAN_QEDIT_ANSSTG2
extern htmlEncodedTvb t_AnswerString3;             // PMAN_QEDIT_ANSSTG3
extern htmlEncodedTvb t_AnswerString4;             // PMAN_QEDIT_ANSSTG4
extern htmlEncodedTvb t_AnswerString5;             // PMAN_QEDIT_ANSSTG5
extern htmlEncodedTvb t_AnswerString6;             // PMAN_QEDIT_ANSSTG6
extern htmlEncodedTvb t_AnswerString7;             // PMAN_QEDIT_ANSSTG7
extern htmlEncodedTvb t_AnswerString8;             // PMAN_QEDIT_ANSSTG8
extern htmlEncodedTvb t_AnswerString9;             // PMAN_QEDIT_ANSSTG9
extern htmlEncodedTvb t_AnswerString10;            // PMAN_QEDIT_ANSSTG10
extern htmlEncodedTvb t_AnswerString11;            // PMAN_QEDIT_ANSSTG11
extern htmlEncodedTvb t_AnswerString12;            // PMAN_QEDIT_ANSSTG12
extern htmlEncodedTvb t_AnswerString13;            // PMAN_QEDIT_ANSSTG13
extern htmlEncodedTvb t_AnswerString14;            // PMAN_QEDIT_ANSSTG14
extern htmlEncodedTvb t_AnswerString15;            // PMAN_QEDIT_ANSSTG15
extern htmlEncodedTvb t_AnswerString16;            // PMAN_QEDIT_ANSSTG16
extern basicTvb t_Branch1;                         // PMAN_QEDIT_BRANCH1
extern basicTvb t_Branch2;                         // PMAN_QEDIT_BRANCH2
extern basicTvb t_Branch3;                         // PMAN_QEDIT_BRANCH3
extern basicTvb t_Branch4;                         // PMAN_QEDIT_BRANCH4
extern basicTvb t_Branch5;                         // PMAN_QEDIT_BRANCH5
extern basicTvb t_Branch6;                         // PMAN_QEDIT_BRANCH6
extern basicTvb t_Branch7;                         // PMAN_QEDIT_BRANCH7
extern basicTvb t_Branch8;                         // PMAN_QEDIT_BRANCH8
extern basicTvb t_Branch9;                         // PMAN_QEDIT_BRANCH9
extern basicTvb t_Branch10;                        // PMAN_QEDIT_BRANCH10
extern basicTvb t_Branch11;                        // PMAN_QEDIT_BRANCH11
extern basicTvb t_Branch12;                        // PMAN_QEDIT_BRANCH12
extern basicTvb t_Branch13;                        // PMAN_QEDIT_BRANCH13
extern basicTvb t_Branch14;                        // PMAN_QEDIT_BRANCH14
extern basicTvb t_Branch15;                        // PMAN_QEDIT_BRANCH15
extern basicTvb t_Branch16;                        // PMAN_QEDIT_BRANCH16
extern htmlEncodedTvb t_QuestionText;              // PMAN_QEDIT_QTEXT

// list/questions tvbs

extern basicTvb t_BranchVal;                       // PMAN_QLIST_BRANCH
extern basicTvb t_CanCreate;                       // PMAN_QLIST_CANCREATE
extern basicTvb t_QNext;                           // PMAN_QLIST_NEXT
extern basicTvb t_NoQuestions;                     // PMAN_QLIST_NOQUES
extern basicTvb t_QNumber;                         // PMAN__NUM
extern basicTvb t_QNumDisplay;                     // PMAN__NUM_DISPLAY
extern basicTvb t_QPrev;                           // PMAN_QLIST_PREV
extern basicTvb t_QText;                           // PMAN_QLIST_QUEST
extern basicTvb t_QType;                           // PMAN_QLIST_TYPE

#endif                             // __PMANVAR_H
