/***************************************************************************
 *                                                                         *
 *   PMANVAR.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll-Manager Variables Class.                                         *
 *                                                 - N.C. Osterc  10/08/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "galpmah.h"
#include "pmanvar.h"
#include "galpnqh.h"
#include "locknkey.h"
#include "dntapi.h"
#include "majorbbs.h"

#define FILREV "$Revision: 3 $"

#define ANSWER1   0                // character buffer index of first answer in mc q
#define MAXEXERPT 35               // size of question exerpt text
#define CLOSEADVDATE 90            // days from create date to close poll by dft

CHAR* qTypeArray[]={
     "CREDIT",
     "DATE",
     "DISONLY",
     "MULTICHC",
     "NUMERIC",
     "OPEN_ENDED",
     "TRUEFALSE",
     "YESNO",
     "USERACCT",
     "NULL",
};

CHAR shortDays[7][6]={"Sun","Mon","Tue","Wed","Thurs","Fri","Sat"};

// Text variable instantiations

htmlEncodedTvb t_ErrMessage("PMAN_ERR_MESSAGE");
htmlEncodedTvb t_PollDesc("PMAN_DESC");
htmlEncodedTvb t_PollName("PMAN_NAME");
urlEncodedTvb t_UrlPollName("PMAN_NAME_U");
basicTvb t_PollType("PMAN_PTYPE");

// poll/edit Tvbs

basicTvb t_AccessKey("PMAN_ACCESS_KEY");
basicTvb t_AccumSel("PMAN_ACCUM_SELECTED");
basicTvb t_AnnounceSel("PMAN_ANNO_SELECTED");
basicTvb t_AsciiSel("PMAN_ASCII_SELECTED");
basicTvb t_AskSel("PMAN_ASK_SELECTED");
basicTvb t_BothSel("PMAN_BOTH_SELECTED");
basicTvb t_BtrieveSel("PMAN_BTRIEVE_SELECTED");
basicTvb t_CloseDate("PMAN_CLDATE");
basicTvb t_CreateDate("PMAN_CRDATE");
basicTvb t_NoClearScrSel("PMAN_DCNO_SELECTED");
basicTvb t_YesClearScrSel("PMAN_DCYES_SELECTED");
basicTvb t_DimSel("PMAN_DIM_SELECTED");
basicTvb t_DiscardSel("PMAN_DISC_SELECTED");
basicTvb t_Class2Grant("PMAN_GRANT_CLASS");
basicTvb t_Creds2Grant("PMAN_GRANT_CREDS");
basicTvb t_File2Grant("PMAN_GRANT_FILE");
basicTvb t_Key2Grant("PMAN_GRANT_KEY");
basicTvb t_HideSel("PMAN_HIDE_SELECTED");
basicTvb t_InsistSel("PMAN_INSIST_SELECTED");
basicTvb t_IsCreate("PMAN_ISCREATE");
basicTvb t_LogonKey("PMAN_LOGON_KEY");
basicTvb t_LookupKey("PMAN_LOOKUP_KEY");
basicTvb t_ResultsKey("PMAN_RESULTS_KEY");
basicTvb t_OnceSel("PMAN_ONCE_SELECTED");
basicTvb t_TypePollSel("PMAN_PTPOLL_SELECTED");
basicTvb t_TypeQuesSel("PMAN_PTQUES_SELECTED");
basicTvb t_ReplaceSel("PMAN_REPL_SELECTED");
basicTvb t_NoSaveBrSel("PMAN_SBNO_SELECTED");
basicTvb t_YesSaveBrSel("PMAN_SBYES_SELECTED");
basicTvb t_ShowSel("PMAN_SHOW_SELECTED");
basicTvb t_SkipSel("PMAN_SKIP_SELECTED");

// question/edit tvbs

basicTvb t_NumAnswerChoices("PMAN_ANSCHOICE_NUM");
basicTvb t_CCSel("PMAN_CREDIT_SELECTED");
basicTvb t_DateSel("PMAN_DATE_SELECTED");
basicTvb t_DisplaySel("PMAN_DISPLAY_SELECTED");
basicTvb t_NoEnableBr("PMAN_EBNO_SELECTED");
basicTvb t_YesEnableBr("PMAN_EBYES_SELECTED");
basicTvb t_MultiSel("PMAN_MULTI_SELECTED");
basicTvb t_NumericSel("PMAN_NUMERIC_SELECTED");
basicTvb t_OpenSel("PMAN_OPEN_SELECTED");
basicTvb t_NoClsSel("PMAN_QCLSNO_SELECTED");
basicTvb t_YesClsSel("PMAN_QCLSYES_SELECTED");
basicTvb t_QIsCreate("PMAN_QEDIT_ISCREATE");
basicTvb t_IsPoll("PMAN_QEDIT_ISPOLL");
basicTvb t_Next("PMAN_NEXT_DISP");
basicTvb t_Prev("PMAN_PREV_DISP");
basicTvb t_TfSel("PMAN_TF_SELECTED");
basicTvb t_UacSel("PMAN_UAC_SELECTED");
basicTvb t_NoExemptSel("PMAN_XMTNO_SELECTED");
basicTvb t_YesExemptSel("PMAN_XMTYES_SELECTED");
basicTvb t_YesNoSel("PMAN_YN_SELECTED");
basicTvb t_NameSel("PMAN_NAME_SELECTED");
basicTvb t_Adr1Sel("PMAN_ADR1_SELECTED");
basicTvb t_Adr2Sel("PMAN_ADR2_SELECTED");
basicTvb t_Adr3Sel("PMAN_ADR3_SELECTED");
basicTvb t_Adr4Sel("PMAN_ADR4_SELECTED");
basicTvb t_PhoneSel("PMAN_PHONE_SELECTED");
basicTvb t_BdaySel("PMAN_BIRTHDAY_SELECTED");
basicTvb t_SexSel("PMAN_SEX_SELECTED");
basicTvb t_AnsiSel("PMAN_ANSI_SELECTED");
basicTvb t_EditorSel("PMAN_EDITOR_SELECTED");
basicTvb t_PasswordSel("PMAN_PASSWORD_SELECTED");

htmlEncodedTvb t_AnswerString1("PMAN_QEDIT_ANSSTG1");
htmlEncodedTvb t_AnswerString2("PMAN_QEDIT_ANSSTG2");
htmlEncodedTvb t_AnswerString3("PMAN_QEDIT_ANSSTG3");
htmlEncodedTvb t_AnswerString4("PMAN_QEDIT_ANSSTG4");
htmlEncodedTvb t_AnswerString5("PMAN_QEDIT_ANSSTG5");
htmlEncodedTvb t_AnswerString6("PMAN_QEDIT_ANSSTG6");
htmlEncodedTvb t_AnswerString7("PMAN_QEDIT_ANSSTG7");
htmlEncodedTvb t_AnswerString8("PMAN_QEDIT_ANSSTG8");
htmlEncodedTvb t_AnswerString9("PMAN_QEDIT_ANSSTG9");
htmlEncodedTvb t_AnswerString10("PMAN_QEDIT_ANSSTG10");
htmlEncodedTvb t_AnswerString11("PMAN_QEDIT_ANSSTG11");
htmlEncodedTvb t_AnswerString12("PMAN_QEDIT_ANSSTG12");
htmlEncodedTvb t_AnswerString13("PMAN_QEDIT_ANSSTG13");
htmlEncodedTvb t_AnswerString14("PMAN_QEDIT_ANSSTG14");
htmlEncodedTvb t_AnswerString15("PMAN_QEDIT_ANSSTG15");
htmlEncodedTvb t_AnswerString16("PMAN_QEDIT_ANSSTG16");
basicTvb t_Branch1("PMAN_QEDIT_BRANCH1");
basicTvb t_Branch2("PMAN_QEDIT_BRANCH2");
basicTvb t_Branch3("PMAN_QEDIT_BRANCH3");
basicTvb t_Branch4("PMAN_QEDIT_BRANCH4");
basicTvb t_Branch5("PMAN_QEDIT_BRANCH5");
basicTvb t_Branch6("PMAN_QEDIT_BRANCH6");
basicTvb t_Branch7("PMAN_QEDIT_BRANCH7");
basicTvb t_Branch8("PMAN_QEDIT_BRANCH8");
basicTvb t_Branch9("PMAN_QEDIT_BRANCH9");
basicTvb t_Branch10("PMAN_QEDIT_BRANCH10");
basicTvb t_Branch11("PMAN_QEDIT_BRANCH11");
basicTvb t_Branch12("PMAN_QEDIT_BRANCH12");
basicTvb t_Branch13("PMAN_QEDIT_BRANCH13");
basicTvb t_Branch14("PMAN_QEDIT_BRANCH14");
basicTvb t_Branch15("PMAN_QEDIT_BRANCH15");
basicTvb t_Branch16("PMAN_QEDIT_BRANCH16");
htmlEncodedTvb t_QuestionText("PMAN_QEDIT_QTEXT");

// list/questions tvbs

basicTvb t_BranchVal("PMAN_QLIST_BRANCH");
basicTvb t_CanCreate("PMAN_QLIST_CANCREATE");
basicTvb t_QNext("PMAN_QLIST_NEXT");
basicTvb t_NoQuestions("PMAN_QLIST_NOQUES");
basicTvb t_QPrev("PMAN_QLIST_PREV");
basicTvb t_QText("PMAN_QLIST_QUEST");
basicTvb t_QType("PMAN_QLIST_TYPE");

basicTvb t_QNumber("PMAN_NUM");
basicTvb t_QNumDisplay("PMAN_NUM_DISPLAY");

basicTvb *t_AnswerStringArray[]={
     &t_AnswerString1,
     &t_AnswerString2,
     &t_AnswerString3,
     &t_AnswerString4,
     &t_AnswerString5,
     &t_AnswerString6,
     &t_AnswerString7,
     &t_AnswerString8,
     &t_AnswerString9,
     &t_AnswerString10,
     &t_AnswerString11,
     &t_AnswerString12,
     &t_AnswerString13,
     &t_AnswerString14,
     &t_AnswerString15,
     &t_AnswerString16,
};

basicTvb *t_BranchArray[]={
     &t_Branch1,
     &t_Branch2,
     &t_Branch3,
     &t_Branch4,
     &t_Branch5,
     &t_Branch6,
     &t_Branch7,
     &t_Branch8,
     &t_Branch9,
     &t_Branch10,
     &t_Branch11,
     &t_Branch12,
     &t_Branch13,
     &t_Branch14,
     &t_Branch15,
     &t_Branch16,
};

MARKSOURCE(pManVar);

pManVar::pManVar()                 // default constructor
{
}

pManVar::~pManVar()                // destructor
{
}

VOID
pManVar::setQuesEditVbs(           // set up take/lookup text variables
question *qobj)                    // pointer to question object
{
     ASSERT(qobj != NULL);

     t_NumAnswerChoices=qobj->getNumAnswers();
     switch (qobj->getQType()) {
     case CREDIT:
          t_CCSel=SEL;
          break;
     case DATE:
          t_DateSel=SEL;
          break;
     case DISONLY:
          t_DisplaySel=SEL;
          break;
     case MULTICHC:
          t_MultiSel=SEL;
          break;
     case OPEN_ENDED:
          t_OpenSel=SEL;
          break;
     case NUMERIC:
          t_NumericSel=SEL;
          break;
     case TRUEFALSE:
          t_TfSel=SEL;
          break;
     case YESNO:
          t_YesNoSel=SEL;
          break;
     case USERACCT:
          t_UacSel=SEL;
          break;
     default:
          ASSERTM(false,"Invalid Question Type Selected");
     }

     switch(qobj->getAccountField()) {
     case ACCFLD_NAME0:
     case ACCFLD_NAME1:
          t_NameSel=SEL;
          break;
     case ACCFLD_ADR_LINE_1:
          t_Adr1Sel=SEL;
          break;
     case ACCFLD_ADR_LINE_2:
          t_Adr2Sel=SEL;
          break;
     case ACCFLD_ADR_LINE_3:
          t_Adr3Sel=SEL;
          break;
     case ACCFLD_ADR_LINE_4:
          t_Adr4Sel=SEL;
          break;
     case ACCFLD_PHONE:
          t_PhoneSel=SEL;
          break;
     case ACCFLD_SEX:
          t_SexSel=SEL;
          break;
     case ACCFLD_BDAY:
          t_BdaySel=SEL;
          break;
     case ACCFLD_ANSI:
          t_AnsiSel=SEL;
          break;
     case ACCFLD_EDITOR:
          t_EditorSel=SEL;
          break;
     case ACCFLD_PASSWORD:
          t_PasswordSel=SEL;
          break;
     default:
          ASSERTM(false,"Invalid Account Type Selected");
     }

     qobj->getFlags()&BRANCH ? t_YesEnableBr=SEL: t_NoEnableBr=SEL;
     qobj->getFlags()&CLRSCN ? t_YesClsSel=SEL: t_NoClsSel=SEL;
     poll *p=new poll(qobj->getPollName());
     if (p->getType() != QUEST) {
          t_IsPoll=1;
     }
     if (qobj->getNumber() < MAXQUES-1) {
          t_Next=qobj->getNext()+1;
     }
     if (qobj->getNumber() != 0) {
          t_Prev=qobj->getPrevious()+1;
     }
     qobj->getFlags()&EXMPT ? t_YesExemptSel=SEL : t_NoExemptSel=SEL;
     t_QNumber=qobj->getNumber();
     t_QNumDisplay=qobj->getNumber()+1;
     t_QuestionText=qobj->getTextMsg();
     for (SHORT ansit=ANSWER1; ansit < MAXASTGS; ansit++) {
          if (strlen(qobj->getAnswerString(ansit)) == 0) {
               continue;
          }
          *t_AnswerStringArray[ansit]=qobj->getAnswerString(ansit);
          if (qobj->getFlags()&BRANCH) {
               *t_BranchArray[ansit]=qobj->getBranch(ansit)+1; // "+1" for display
          }
     }
     USHORT ait=0;
     while (ait < MAXASTGS) {
        if ((*t_BranchArray[ait]).length() == 0) {
             *t_BranchArray[ait]=qobj->getNext()+1; // "+1" for display
        }
        ++ait;
     }

     delete p;
}

VOID
pManVar::setPollEditVbs(
poll *pobj)
{
     ASSERT(pobj != NULL);

     t_UrlPollName=t_PollName=pobj->getName();
     t_PollDesc=pobj->getDescription();
     t_AccessKey=pobj->getTakeKey();
     switch (pobj->getAnswerType()) {
     case ACCUMULATE:
          t_AccumSel=SEL;
          break;
     case ONCE:
          t_OnceSel=SEL;
          break;
     case REPLACE:
          t_ReplaceSel=SEL;
          break;
     default:
          ASSERTM(false,"Invalid Poll Answer Type");
     }
     switch(pobj->getPriority()) {
     case ASK:
          t_AskSel=SEL;
          break;
     case ANNOUNCE:
          t_AnnounceSel=SEL;
          break;
     case INSIST:
          t_InsistSel=SEL;
          break;
     case SKIP:
          t_SkipSel=SEL;
          break;
     default:
          ASSERTM(false,"Invalid Poll Priority Type");
     }
     switch(pobj->getStorageMethod()) {
     case DISCARD:
          t_DiscardSel=SEL;
          break;
     case BTRIEVE:
          t_BtrieveSel=SEL;
          break;
     case BOTH:
          t_BothSel=SEL;
          break;
     case ASCII:
          t_AsciiSel=SEL;
          break;
     default:
          ASSERTM(false,"Invalid Storage Type");
     }

     if (pobj->getType() != QUEST) {
          t_PollType="POLL";
     }
     else {
          t_PollType="QUESTIONNAIRE";
     }

     t_CloseDate=ncdatel(pobj->getCloseDate());
     t_CreateDate=ncdatel(pobj->getCreateDate());
     pobj->getFlags()&CLRDFLT ? t_YesClearScrSel=SEL : t_NoClearScrSel=SEL;
     switch(pobj->getAccessAttrib()) {
     case SHOW:
          t_ShowSel=SEL;
          break;
     case DIM:
          t_DimSel=SEL;
          break;
     case HIDE:
          t_HideSel=SEL;
          break;
     default:
          ASSERTM(false,"Invalid Access Attrib");
     }

     t_Class2Grant=pobj->getGrantClass();
     t_Creds2Grant=pobj->getGrantCredits();
     t_File2Grant=pobj->getGrantFile();
     t_Key2Grant=pobj->getGrantKey();
     t_LogonKey=pobj->getLogonKey();
     t_LookupKey=pobj->getLookupKey();
     t_ResultsKey=pobj->getResultKey();
     pobj->getType() == QUEST ? t_TypeQuesSel=SEL : t_TypePollSel=SEL;
     pobj->getFlags()&DISBRANCH ? t_NoSaveBrSel=SEL : t_YesSaveBrSel=SEL;
}

VOID
pManVar::setQuesListVbs(
question *qobj)
{
     ASSERT(qobj != NULL);

     if (qobj->getFlags()&BRANCH) {
          t_BranchVal="YES";
     }
     poll *p=new poll(qobj->getPollName());
     if (!p->isQuestion(MAXQUES-1)) {
         t_CanCreate=1;
     }
     if (qobj->getNumber() < MAXQUES-1) {
          t_QNext=qobj->getNext();
     }
     t_QNumber=qobj->getNumber();
     t_QNumDisplay=qobj->getNumber()+1;
     if (qobj->getNumber() > 0) {
          t_QPrev=qobj->getPrevious();
     }
     const CHAR *qtxtptr=qobj->getTextMsg();
     CHAR xrptBuf[MAXEXERPT];
     stlcpy(xrptBuf,qtxtptr,MAXEXERPT);
     t_QText=xrptBuf;
     ASSERT(qobj->getQType() >= CREDIT && qobj->getQType() <= USERACCT);
     t_QType=qTypeArray[qobj->getQType()-1];

     delete p;
}

const CHAR *
pManVar::format(                   // variable argument formatter
const CHAR *fmt
...)
{
     setmem(m_formatBuf,SPRINTFSIZ,0);
     va_list ap;
     va_start(ap,fmt);
     vsprintf(m_formatBuf,fmt,ap);
     return(m_formatBuf);
}

VOID
pManVar::setVarsDefault()            // set tvbs to default values
{
     t_ErrMessage="";

     t_AccessKey="";
     t_AccumSel="";
     t_ResultsKey="";
     t_AnnounceSel="";
     t_AsciiSel="";
     t_AskSel="";
     t_BothSel="";
     t_BtrieveSel="";
     t_CloseDate=ncdatel(datofc(cofdat(today())+CLOSEADVDATE));
     t_CreateDate=ncdatel(today());
     t_NoClearScrSel="";
     t_YesClearScrSel="";
     t_DimSel="";
     t_DiscardSel="";
     t_Class2Grant="";
     t_Creds2Grant="0";
     t_File2Grant="";
     t_Key2Grant="";
     t_HideSel="";
     t_InsistSel="";
     t_IsCreate="0";
     t_LogonKey="";
     t_LookupKey="SYSOP";
     t_OnceSel="";
     t_TypePollSel="";
     t_TypeQuesSel="";
     t_ReplaceSel="";
     t_NoSaveBrSel="";
     t_YesSaveBrSel="";
     t_ShowSel="";
     t_SkipSel="";

     t_NumAnswerChoices="1";
     t_CCSel="";
     t_DateSel="";
     t_DisplaySel="";
     t_NoEnableBr="";
     t_YesEnableBr="";
     t_MultiSel="";
     t_NumericSel="";
     t_OpenSel="";
     t_NoClsSel="";
     t_YesClsSel="";
     t_QIsCreate="0";
     t_IsPoll=0;
     t_Next="N/A";
     t_Prev="N/A";
     t_TfSel="";
     t_UacSel="";
     t_NoExemptSel="";
     t_YesExemptSel="";
     t_YesNoSel="";
     t_AnswerString1="";
     t_AnswerString2="";
     t_AnswerString3="";
     t_AnswerString4="";
     t_AnswerString5="";
     t_AnswerString6="";
     t_AnswerString7="";
     t_AnswerString8="";
     t_AnswerString9="";
     t_AnswerString10="";
     t_AnswerString11="";
     t_AnswerString12="";
     t_AnswerString13="";
     t_AnswerString14="";
     t_AnswerString15="";
     t_AnswerString16="";
     t_Branch1="";
     t_Branch2="";
     t_Branch3="";
     t_Branch4="";
     t_Branch5="";
     t_Branch6="";
     t_Branch7="";
     t_Branch8="";
     t_Branch9="";
     t_Branch10="";
     t_Branch11="";
     t_Branch12="";
     t_Branch13="";
     t_Branch14="";
     t_Branch15="";
     t_Branch16="";
     t_QuestionText="";

     t_BranchVal="NO";
     t_CanCreate=0;
     t_QNext="";
     t_NoQuestions="";
     t_QNumber="";
     t_QPrev="N/A";
     t_QText="N/A";
     t_QType="";
     t_QNumDisplay="";

     t_PollDesc="";
     t_PollName="";
     t_UrlPollName="";
     t_PollType="";
}
