/***************************************************************************
 *                                                                         *
 *   PMANSYN.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll-Manager Class.                                                   *
 *                                                 - N.C. Osterc  10/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __PMANSYN_H
#define __PMANSYN_H

#include "poll.h"
#include "galacth.h"
#include "dnf.h"
#include "pmanvar.h"
#include "question.h"
#include "cyctimer.h"
#include "pollapi.h"

#define URLSIZ 1024
#define PVALBUFSIZ 16384
#define PPFIX "galacth/galpmah/"
#define GETPARAMVAL(x) ses->param(x,m_pValBuf,PVALBUFSIZ)
#define ISPARAM(x) ses->paramIndex(x,m_index)
#define QUESTIONNAIRE 2

class pManSynthesis: public acthSynthesis {
public:

     pManSynthesis(                // default constructor
     acthSession *_ses);           // session object

     virtual
     ~pManSynthesis();             // destructor

     virtual
     ACTHCODE
     proceed();                    // proceed entry point

protected:

     VOID
     setError(                     // set up error tvbs
     INT messageOpt,               // the message option
     const CHAR *arg1=NULL,        // first argument
     const CHAR *arg2=NULL);       // second argument

     VOID
     setErrorVbs();                // set error tvbs up

     virtual ACTHCODE
     dynafile();                   // dynafile

     bool
     hasAgentAccess();             // does user have access?

     bool
     hasSuperAccess();             // key for super-poll access

     ACTHCODE
     initRequest();                // initialize request stuff

     ACTHCODE
     isUserOK();                   // check user specific stuff

     acthUserID *m_usrPtr;         // user object
     dnfHandler *m_dnfPtr;         // dnfhandler object
     pManVar *m_pTvb;              // point to poll variables object
     pollAPI *m_pAPI;              // pointer to poll API
     poll *m_pPoll;                // point to poll object
     question *m_pQues;            // point to question object
     CHAR m_pValBuf[PVALBUFSIZ];   // buffer - stores parameter values
     cycleTimer m_cyc;             // cyctle timer instance
     INT m_index;                  // index - used in ISPARAM
     SHORT m_ahState;              // state-tracking variable
     string m_errMessage;          // save error message
     bool m_errorStatus;           // did error occur?
};

#endif                             // __PMANSYN_H
