/***************************************************************************
 *                                                                         *
 *   PMANSYN.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll Synthesis Class.                                                 *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "pmansyn.h"
#include "dnfmgr.h"
#include "cstring.h"
#include "pmanmsg.h"
#include "galpmah.h"
#include "ahutil.h"
#include "majorbbs.h"

#define FILREV "$Revision: 3 $"

// Dynafile defs

dnfStep dnfFrameSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap defMap(PPFIX "index.htm","Default",dnfFrameSteps);

// class method defs

MARKSOURCE(pmansyn);

pManSynthesis::pManSynthesis(       // default constructor
               acthSession *_ses):
               acthSynthesis(_ses),
               m_usrPtr(NULL),
               m_dnfPtr(NULL),
               m_pTvb(NULL),
               m_pPoll(NULL),
               m_pQues(NULL),
               m_pAPI(NULL),
               m_errorStatus(false)
{
     m_pTvb=new pManVar();
     m_pAPI=new pollAPI();
     m_cyc.setSlice(timslc);
     m_pValBuf[0]='\0';
}

pManSynthesis::~pManSynthesis()     // destructor
{
     if (m_dnfPtr != NULL) {
          delete m_dnfPtr;
          m_dnfPtr=NULL;
     }
     if (m_pTvb != NULL) {
          delete m_pTvb;
          m_pTvb=NULL;
     }
     if (m_pAPI != NULL) {
          delete m_pAPI;
          m_pAPI=NULL;
     }
}

ACTHCODE
pManSynthesis::initRequest()
{
     if ((strchr(ses->urlsfx(),'.')) == NULL) {
          if (ses->forceDir()) {
               return(ACTHDONE);
          }
     }
     m_pTvb->setVarsDefault();
     if (m_errorStatus) {
          setErrorVbs();
     }
     return(ACTHMORE);
}

ACTHCODE
pManSynthesis::isUserOK()          // check some basic stuff about user and session
{
     if ((m_usrPtr=ses->getUser()) == NULL) {
          return(ACTHNOANON);
     }
     if (!hasAgentAccess()) {
          return(ACTHFORBID);
     }
     return(initRequest());
}

ACTHCODE
pManSynthesis::proceed()           // proceed entry point
{
     ACTHCODE retval;

     if (ses->urlargc() > 0 && strchr(ses->urlargv(0),'.') == NULL) {
          return(ACTHNOTFND);
     }
     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }
     if (m_dnfPtr == NULL) {
          m_dnfPtr=dnfCreateHandlerURL(ses,&defMap,PPFIX);
     }
     if (m_cyc.start()) {
          do {
               retval=dynafile();
          } while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}

ACTHCODE
pManSynthesis::dynafile()          // dynafile
{
     ASSERT(m_dnfPtr != NULL);

     ACTHCODE retval=ACTHMORE;

     switch(m_dnfPtr->process()) {
     case DNFEND:
          retval=ACTHDONE;
          break;
     }
     return(retval);
}

bool
pManSynthesis::hasSuperAccess()    // does user have super access?
{
     ASSERT(m_usrPtr != NULL);

     return(m_usrPtr->hasKey(supkey));
}

bool
pManSynthesis::hasAgentAccess()    // does user have access?
{
     ASSERT(m_usrPtr != NULL);

     return(m_usrPtr->hasKey(hpmankey) && m_usrPtr->hasKey(pllopkey));
}

VOID
pManSynthesis::setError(           // set error text variables
INT messageOpt,                    // given message opt
const CHAR *arg1,                  // argument for prfmsg
const CHAR *arg2)                  // argument for prfmsg
{
     setmbk(pManAHmsg);
     clrprf();
     if (arg1 != NULL && arg2 != NULL) {
          prfmsg(messageOpt,arg1,arg2);
     }
     else if (arg1 != NULL) {
          prfmsg(messageOpt,arg1);
     }
     else {
          prfmsg(messageOpt);
     }
     m_errorStatus=true;
     m_errMessage=stpans(prfbuf);
     setErrorVbs();
     rstmbk();
}

VOID
pManSynthesis::setErrorVbs()       // set up error text variables
{
     t_ErrMessage=m_errMessage;
}

