/***************************************************************************
 *                                                                         *
 *   PMANMSG.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll Message Options Class.                                           *
 *                                                  - N.C. Osterc  9/11/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "gcspsrv.h"
#include "galpmah.h"
#include "pmanmsg.h"

#define FILREV "$Revision: 3 $"

CHAR *hpmankey;                        // key to access poll manager
CHAR *noqfound;                        // no questions found message
INT timslc;                            // time slice to seed cyctimer
HMCVFILE pManAHmsg;                    // message file pointer

bool messagesInited=false;             // have message options been initialized

MARKSOURCE(pollmsg);

pManMsg::pManMsg()                     // default constructor
{
     if (messagesInited) {
          return;
     }
     pManAHmsg=opnmsg("GALPMAH.MCV");
     setmbk(pManAHmsg);
     hpmankey=stgopt(HPMANKEY);
     noqfound=stpans(stgopt(NOQFOUND));
     timslc=numopt(TIMSLC,1,1000);
     rstmbk();
     messagesInited=true;
}

pManMsg::~pManMsg()                    // destructor
{
     free(hpmankey);
     free(noqfound);
     clsmsg(pManAHmsg);
     messagesInited=false;
}
