/***************************************************************************
 *                                                                         *
 *   PMANAGT.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll-Manager Agent Class.                                             *
 *                                                  - N.C. Osterc 10/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "pmanagt.h"
#include "pmansyn.h"
#include "delpoll.h"
#include "delques.h"
#include "editpoll.h"
#include "editques.h"
#include "listques.h"
#include "resetsyn.h"
#include "majorbbs.h"

#define URLARG1(x) sameas(ses->urlargv(0),x)
#define URLARG2(x) sameas(ses->urlargv(1),x)

pManAgent *pAgent;                 // pointer to poll-manager agent
VOID delAgent(VOID);               // delete agent

MARKSOURCE(pmanagt);

pManAgent::pManAgent() : acthAgent("AH P&Q Management","poll-manager")  // default constructor
{
     init__galpnq();
     registerAgent(acthVersion);
     hook_finalshutdown(delAgent);
}

pManAgent::~pManAgent()            // destructor
{
}

acthSynthesis *                    // synth obj ptr
pManAgent::newSynthesis(           // return a new synthesis object
acthSession *ses)                  // session object
{
     pManSynthesis *pSynth=NULL;

     if (ses->urlargc() >= 1) {
          if (ses->urlargc() == 2) {
               if (URLARG1("polls")) {
                    if (URLARG2("delete")) {
                         pSynth=new delPollSynthesis(ses);
                    }
                    else if (URLARG2("edit")) {
                         pSynth=new editPollSynthesis(ses);
                    }
               }
               else if (URLARG1("questions")) {
                    if (URLARG2("delete")) {
                         pSynth=new delQuesSynthesis(ses);
                    }
                    else if (URLARG2("edit")) {
                         pSynth=new editQuesSynthesis(ses);
                    }
                    else if (URLARG2("list")) {
                         pSynth=new listQuesSynthesis(ses);
                    }
               }
          }
          else if (URLARG1("reset")) {
               pSynth=new resetSynthesis(ses);
          }
     } 
     if (pSynth == NULL) {
          pSynth=new pManSynthesis(ses);
     }
     return(pSynth);
}

extern "C" VOID EXPORT             // init our agent
init__galpmah(VOID)
{
     pAgent=new pManAgent;
}

VOID
delAgent(
VOID)
{
     delete pAgent;
}
