/***************************************************************************
 *                                                                         *
 *   MAPCOMP.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Map compare Class.                                                    *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "mapcomp.h"

#define FILREV "$Revision: 8 $"

MARKSOURCE(mapcomp);

mapCompare::mapCompare(            // constructor
const CHAR * pname,
USHORT date)
{
     ASSERT(pname != NULL);

     stlcpy(m_pollBuf,pname,PNAMELEN);
     m_date=date;
}

mapCompare::~mapCompare()          // destructor
{
}

USHORT
mapCompare::getDate()              // gets the date
{
     return(m_date);
}

bool
mapCompare::operator< (            // '<' operator definition
mapCompare const & rmc) const
{
     bool retval=FALSE;

     if (m_date == rmc.m_date) {
          if (strcmp(rmc.m_pollBuf,m_pollBuf) > 0) {
               retval=TRUE;
          }
     }
     else if (rmc.m_date > m_date) {
          retval=TRUE;
     }
     return(retval);
}

