/***************************************************************************
 *                                                                         *
 *   LISTQUES.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   List Questions Synthesis Class.                                       *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "listques.h"
#include "dnfmgr.h"
#include "majorbbs.h"

#define FILREV "$Revision: 3 $"

#define LISTQUESDIR "questions/list/"

// dynafile stuff

enum {LISTPARAM, LIST_ERR_RESP, LISTRESP, DEFAULTITEM};

dnfStep dnfListDefSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,DEFAULTITEM,"LISTITEM"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};

dnfStep dnfListErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfListDefMap(PPFIX LISTQUESDIR "index.htm","List Index Steps",dnfListDefSteps);
dnfMap dnfListErrMap(PPFIX LISTQUESDIR "error.htm","List Error Steps",dnfListErrSteps);

// class method defs

MARKSOURCE(listQues);

listQuesSynthesis::listQuesSynthesis(   // default constructor
                   acthSession *_ses):  // session object
                   pManSynthesis(_ses),
                   m_gotQuestion(false),
                   m_tableDone(false)
{
     m_ahState=LISTPARAM;
     m_pPoll=NULL;
     m_pQues=NULL;
}

listQuesSynthesis::~listQuesSynthesis() // destructor
{
     if (m_pPoll != NULL) {
          delete m_pPoll;
          m_pPoll=NULL;
     }
     if (m_pQues != NULL) {
          delete m_pQues;
          m_pQues=NULL;
     }
}

ACTHCODE
listQuesSynthesis::proceed()        // proceed entry point
{
     ACTHCODE retval;
     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }
     if (m_cyc.start()) {
          do {
               switch (m_ahState) {
               case LISTPARAM:
                    GETPARAMVAL("pollname");
                    if (m_pValBuf[0] == '\0') {
                         setError(NOPARAM,"pollname");
                         m_ahState=LIST_ERR_RESP;
                    }
                    else if (!m_pAPI->isPoll(m_pValBuf)) {
                         setError(POLLNFND,m_pValBuf);
                         m_ahState=LIST_ERR_RESP;
                    }
                    else {
                         m_pPoll=new poll(m_pValBuf);
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfListDefMap,PPFIX);
                         m_ahState=LISTRESP;
                    }
                    break;
               case LIST_ERR_RESP:
                    if (m_dnfPtr == NULL) {
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfListErrMap,PPFIX);
                    }
                    retval=pManSynthesis::dynafile();
                    break;
               case LISTRESP:
                    m_pTvb->setPollEditVbs(m_pPoll);
                    if (m_pQues != NULL) {
                         m_pTvb->setQuesEditVbs(m_pQues);
                         m_pTvb->setQuesListVbs(m_pQues);
                    }
                    retval=dynafile();
                    break;
               }
          } while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}

ACTHCODE
listQuesSynthesis::dynafile()
{
     ACTHCODE retval=ACTHMORE;

     if (!m_gotQuestion && m_tableDone) {
          t_NoQuestions=noqfound;
     }

     switch (m_dnfPtr->process()) {
     case DNFROWBEGIN:
          if (m_dnfPtr->rowNumber() >= MAXQUES) {
               m_dnfPtr->tableDone();
               m_tableDone=true;
          }
          else if (m_pPoll->isQuestion(m_dnfPtr->rowNumber())) {
                m_gotQuestion=true;
                m_pQues=new question(m_pPoll->getName(),m_dnfPtr->rowNumber());
                m_pTvb->setQuesEditVbs(m_pQues);
                m_pTvb->setQuesListVbs(m_pQues);
          }
          else {
               m_dnfPtr->tableDone();
               m_tableDone=true;
          }
          break;
     case DNFEND:
          retval=ACTHDONE;
          break;
     }
     return(retval);
}
