/***************************************************************************
 *                                                                         *
 *   EDITQUES.H                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Edit Questions Synthesis Class.                                       *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __EDITQUES_H
#define __EDITQUES_H

#include "pmansyn.h"

class editQuesSynthesis: public pManSynthesis {
public:

     editQuesSynthesis(        // default constructor
     acthSession *_ses);       // session object

     ~editQuesSynthesis();     // destructor

     ACTHCODE
     proceed();                // proceed entry point

     VOID
     setMap(                   // set up dynafile handler
     dnfMap *map);

     bool 
     saveQuestion();           // handle saving question

     bool
     getPollNameParam();       // handle "pollname" parameter

     bool
     getNumberParam();         // handle the "number" paramter

     bool
     getQTypeParam();          // handle the "qtype" parameter

     bool
     getAccFieldParam();       // handle the "accfield" parameter

     bool
     getNextParam();           // handle the "next" parameter

     bool
     getPrevParam();           // handle the "prev" parameter

     bool
     getXmtDataParam();        // handle the "xmtdata" parameter

     bool
     getDefClsParam();         // handle the "defcls" parameter
     
     bool
     getBranchParam();         // handle the "branch" parameter

     bool
     getChoicesParam();        // handle the "choices paramter"

     bool
     getQTextParam();          // handle the "qtext" parameter

     bool
     getAnsStringxParam();     // handle "ansstringx" parameter(s)

     bool
     getBranchxParam();        // handle "branchx" parameter(s)

private:
    
    bool m_bCreate;            // are we creating this question?
};

#endif                         // __EDITQUES_H
