/***************************************************************************
 *                                                                         *
 *   EDITPOLL.H                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Edit Poll Synthesis Class.                                            *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __EDITPOLL_H
#define __EDITPOLL_H

#include "pmansyn.h"

class editPollSynthesis: public pManSynthesis {
public:

     editPollSynthesis(        // default constructor
     acthSession *_ses);       // session object

     ~editPollSynthesis();     // destructor

     bool
     checkSuper();             // handle if user has super poll access

     bool
     isParamValid(             // check validity of paramter/value
     const CHAR *paramVal,     // value of parameter
     const CHAR *paramName,    // name of parameter
     INT paramLen);            // max len of parameter

     bool
     getPollNameParam();       // handle "pollname" parameter

     bool
     getDescParam();           // handle "desc" parameter

     bool
     getPTypeParam();          // handle "ptype" parameter

     bool
     getLogProcParam();        // handle "logproc" parameter

     bool
     getDataStorParam();       // handle "datastor" parameter

     bool
     getSaveBranchParam();     // handle "Savebranch" parameter

     bool
     getAnsTypeParam();        // handle "anstype" parameter

     bool
     getDefClsParam();         // handle "defcls" parameter

     bool
     getClDateParam();         // handle "cldate" parameter

     bool
     getLookupKeyParam();      // handle "lookupkey" parameter

     bool
     getResultsKeyParam();     // handle "results" key parameter

     bool
     getLogonKeyParam();       // handle "logonkey" parameter

     bool
     getAccessKeyParam();      // handle "accesskey" parameter

     bool
     getAccessAttParam();      // handle "accessatt" parameter

     bool
     getGrantKeyParam();       // handle "grantkey" parameter

     bool
     getGrantClsParam();       // handle "grantcls" parameter

     bool
     getGrantCredParam();      // handle "grantcred" parameter

     bool
     getGrantFileParam();      // handle "grantfile" parameter

     bool
     savePoll();               // handle saving poll

     ACTHCODE
     proceed();                // proceed entry point

private:

     bool m_bCreate;           // are we creating this poll?
};

#endif                         // __EDITPOLL_H
