/***************************************************************************
 *                                                                         *
 *   EDITPOLL.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Edit Poll Synthesis Class.                                            *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "editpoll.h"
#include "dnfmgr.h"
#include "galpnqh.h"
#include "majorbbs.h"
#include "ahutil.h"

#define FILREV "$Revision: 4 $"

#define EDITPOLLDIR "polls/edit/"
#define ISPARAMVAL (m_pValBuf[0] != '\0')
#define ISSAVE (ISPARAM("save"))
#define INRANGE(x) (stringInRange(' ','z',x))
#define MAXCREDLEN 9

enum {EDITPARAMS, EDITRESP};

// dynafile stuff

dnfStep dnfEditErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfEditDefSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfCreateDefSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfEditConfSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfEditErrMap(PPFIX EDITPOLLDIR "error.htm","Edit Error Steps",dnfEditErrSteps);
dnfMap dnfEditDefMap(PPFIX EDITPOLLDIR "indexe.htm","Edit Index Steps",dnfEditDefSteps);
dnfMap dnfCreateDefMap(PPFIX EDITPOLLDIR "indexc.htm","Create Index Steps",dnfCreateDefSteps);
dnfMap dnfEditConfMap(PPFIX EDITPOLLDIR "confedit.htm","Confirm Edit Steps",dnfEditConfSteps);

// class method defs

MARKSOURCE(editPoll);

editPollSynthesis::editPollSynthesis(   // default constructor
                   acthSession *_ses):// session object
                   pManSynthesis(_ses),
                   m_bCreate(false)
{
     m_pPoll=NULL;
     m_ahState=EDITPARAMS;
     setmem(&m_pValBuf,PVALBUFSIZ,0);
}

editPollSynthesis::~editPollSynthesis() // destructor
{
     if (m_pPoll != NULL) {
          delete m_pPoll;
          m_pPoll=NULL;
     }
}

ACTHCODE
editPollSynthesis::proceed()        // proceed entry point
{
     ACTHCODE retval=ACTHMORE;

     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }

     if (!m_cyc.start()) {
          return(retval);
     }

     do {
           switch (m_ahState) {
           case EDITPARAMS:
               if (!getPollNameParam()) {
                     m_dnfPtr=dnfCreateHandlerURL(ses,&dnfEditErrMap,PPFIX);
                     m_ahState=EDITRESP;
                     break;
               }
               if (ISSAVE && (!getDescParam() || !getPTypeParam()
                 || !getLogProcParam() || !getDataStorParam()
                 || !getSaveBranchParam() || !getAnsTypeParam()
                 || !getDefClsParam() || !getClDateParam()
                 || !getLookupKeyParam() || !getResultsKeyParam()
                 || !getLogonKeyParam() || !getAccessKeyParam()
                 || !getAccessAttParam() || !getGrantKeyParam()
                 || !getGrantClsParam() || !getGrantCredParam()
                 || !getGrantFileParam())) {
                     m_dnfPtr=dnfCreateHandlerURL(ses,&dnfEditErrMap,PPFIX);
               }
               else if (!ISSAVE) {
                    if (m_bCreate) {
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfCreateDefMap,PPFIX);
                    }
                    else {
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfEditDefMap,PPFIX);
                    }
               }
               else { // all parameters were gotten okay on a save
                    if (!savePoll()) {
                         setError(ERRSAVE,m_pPoll->getName());
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfEditErrMap,PPFIX);
                    }
                    else {
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfEditConfMap,PPFIX);
                    }
               }
               m_ahState=EDITRESP;
               break;
           case EDITRESP:
               if (m_bCreate) {
                    t_IsCreate=1;
               }
               if (m_pPoll != NULL) {
                    m_pTvb->setPollEditVbs(m_pPoll);
               }
               else {
                   initRequest();
               }
               retval=dynafile();
               break;
           }
     } while (m_cyc.haveTime() && retval != ACTHDONE);

     return(retval);
}

bool
editPollSynthesis::isParamValid(            // determine if param/value is valid
const CHAR *paramVal,
const CHAR *paramName,
INT paramLen)
{
     if (!INRANGE(paramVal)) {
          setError(BADCHAR,paramName);
          return(false);
     }
     else if (strlen(paramVal) > paramLen) {
          setError(TOOLONG,paramName,spr("%d",paramLen));
          return(false);
     }
     return(true);
}

bool
editPollSynthesis::getPollNameParam()       // handle "pollname" parameter
{
     GETPARAMVAL("pollname");
     if (ISSAVE) {
          if (!ISPARAMVAL) {
               setError(NOPARAM,"pollname");
               return(false);
          }
          else if (!isParamValid(m_pValBuf,"pollname",PNAMELEN)) {
               return(false);
          }
          else {
               m_pPoll=new poll(strupr(m_pValBuf));
          }
     }
     if (ISPARAMVAL && m_pAPI->isPoll(m_pValBuf)) {
          m_pPoll=new poll(m_pValBuf);
          if (m_pPoll->getFlags()&DELETEP) {
               setError(TAG4DEL);
               return(false);
          }
     }
     else {
          m_bCreate=true;
     }
     return(true);
}

bool
editPollSynthesis::getDescParam()           // handle "desc" parameter
{
     GETPARAMVAL("desc");
     if (ISPARAMVAL) {
          if (!isParamValid(m_pValBuf,"description",PDESCLEN)) {
               return(false);
          }
          m_pPoll->setDescription(m_pValBuf);
     }
     return(true);
}

bool
editPollSynthesis::getPTypeParam()          // handle "ptype" parameter
{
     GETPARAMVAL("ptype");
     if (ISPARAMVAL) {
          if (sameas(m_pValBuf,"POLL")) {
               m_pPoll->setType(POLL);
          }
          else if (sameas(m_pValBuf,"QUESTIONNAIRE")) {
               m_pPoll->setType(QUEST);
          }
          else {
               setError(UNXVAL,m_pValBuf,"poll type");
               return(false);
          }
     }
     else {
          setError(NOPARAM,"poll type");
          return(false);
     }
     return(true);
}

bool
editPollSynthesis::getLogProcParam()        // handle "logproc" parameter
{
     GETPARAMVAL("logproc");
     if (!ISPARAMVAL) {
          setError(NOPARAM,"logon process");
          return(false);
     }
     else {
          if (sameas(m_pValBuf,"ANNOUNCE")) {
               m_pPoll->setPriority(ANNOUNCE);
          }
          else if (sameas(m_pValBuf,"ASK")) {
               m_pPoll->setPriority(ASK);
          }
          else if (sameas(m_pValBuf,"INSIST")) {
               m_pPoll->setPriority(INSIST);
          }
          else if (sameas(m_pValBuf,"SKIP")) {
               m_pPoll->setPriority(SKIP);
          }
          else {
               setError(UNXVAL,m_pValBuf,"logon process");
               return(false);
          }
     }
     return(true);
}

bool
editPollSynthesis::getDataStorParam()       // handle "datastor" parameter
{
     GETPARAMVAL("datastor");
     if (!ISPARAMVAL) {
          setError(NOPARAM,"data storage type");
          return(false);
     }
     else {
          if (sameas(m_pValBuf,"BOTH")) {
               m_pPoll->setStorageMethod(BOTH);
          }
          else if (sameas(m_pValBuf,"BTRIEVE")) {
               m_pPoll->setStorageMethod(BTRIEVE);
          }
          else if (sameas(m_pValBuf,"ASCII")) {
               m_pPoll->setStorageMethod(ASCII);
          }
          else if (sameas(m_pValBuf,"DISCARD")) {
               m_pPoll->setStorageMethod(DISCARD);
          }
          else {
               setError(UNXVAL,m_pValBuf,"data storage type");
               return(false);
          }
     }
     return(true);
}

bool
editPollSynthesis::getSaveBranchParam()     // handle "Savebranch" parameter
{
     GETPARAMVAL("savebranch");
     if (!ISPARAMVAL) {
          setError(NOPARAM,"save branch");
          return(false);
     }
     else {
          if (sameas(m_pValBuf,"YES")) {
               m_pPoll->setSaveBranch(true);
          }
          else if (sameas(m_pValBuf,"NO")) {
               m_pPoll->setSaveBranch(false);
          }
          else {
               setError(UNXVAL,m_pValBuf,"save branch");
               return(false);
          }
     }
     return(true);
}

bool
editPollSynthesis::getAnsTypeParam()        // handle "anstype" parameter
{
     GETPARAMVAL("anstype");
     if (!ISPARAMVAL) {
          setError(NOPARAM,"answer type");
          return(false);
     }
     else {
          if (sameas(m_pValBuf,"ONCE")) {
               m_pPoll->setAnswerType(ONCE);
          }
          else if (sameas(m_pValBuf,"REPLACE")) {
               m_pPoll->setAnswerType(REPLACE);
          }
          else if (sameas(m_pValBuf,"ACCUMULATE")) {
               m_pPoll->setAnswerType(ACCUMULATE);
          }
          else {
               setError(UNXVAL,m_pValBuf,"answer type");
               return(false);
          }
     }
     return(true);
}

bool
editPollSynthesis::getDefClsParam()         // handle "defcls" parameter
{
     GETPARAMVAL("defcls");
     if (!ISPARAMVAL) {
          setError(NOPARAM,"default clear screen");
          return(false);
     }
     else {
          SHORT flags=m_pPoll->getFlags();
          if (sameas(m_pValBuf,"YES")) {
               flags|=CLRDFLT;
               m_pPoll->setFlags(flags);
          }
          else if (sameas(m_pValBuf,"NO")) {
               flags&=~CLRDFLT;
               m_pPoll->setFlags(flags);
          }
          else {
               setError(UNXVAL,m_pValBuf,"default clear screen");
               return(false);
          }
     }
     return(true);
}

bool
editPollSynthesis::getClDateParam()         // handle "cldate" parameter
{
     GETPARAMVAL("cldate");
     if (!ISPARAMVAL) {
          setError(NOPARAM,"close date");
          return(false);
     }
     else {
          USHORT sdate;
          if ((sdate=dcdate(m_pValBuf)) != GCINVALIDDOT) {
               m_pPoll->setCloseDate(sdate);
          }
          else {
               setError(UNXFMAT,"close date","MM/DD/YYYY");
               return(false);
          }
     }
     return(true);
}

bool
editPollSynthesis::getLookupKeyParam()      // handle "lookupkey" parameter
{
     GETPARAMVAL("lookupkey");
     if (ISPARAM("lookupkey")) {
          if (!ISPARAMVAL) {
               m_pPoll->setLookupKey("");
          }
          else if (!keynam(m_pValBuf)) {
               setError(INVVAL,"lookupkey");
               return(false);
          }
          else {
               m_pPoll->setLookupKey(m_pValBuf);
          }
     }
     return(true);
}

bool
editPollSynthesis::getResultsKeyParam()     // handle "results" key parameter
{
     GETPARAMVAL("resultskey");
     if (ISPARAM("resultskey")) {
          if (!ISPARAMVAL) {
               m_pPoll->setResultsKey("");
          }
          else if (!keynam(m_pValBuf)) {
               setError(INVVAL,"resultskey");
               return(false);
          }
          else {
               m_pPoll->setResultsKey(m_pValBuf);
          }
     }
     return(true);
}

bool
editPollSynthesis::getLogonKeyParam()       // handle "logonkey" parameter
{
     GETPARAMVAL("logonkey");
     if (ISPARAM("logonkey")) {
          if (!ISPARAMVAL) {
               m_pPoll->setLogonKey("");
          }
          else if (!keynam(m_pValBuf)) {
               setError(INVVAL,"logonkey");
               return(false);
          }
          else {
               m_pPoll->setLogonKey(m_pValBuf);
          }
     }
     return(true);
}

bool
editPollSynthesis::getAccessKeyParam()      // handle "accesskey" parameter
{
     GETPARAMVAL("accesskey");
     if (ISPARAM("accesskey")) {
          if (!ISPARAMVAL) {
               m_pPoll->setTakeKey("");
          }
          else if (!keynam(m_pValBuf)) {
               setError(INVVAL,"accesskey");
               return(false);
          }
          else {
               m_pPoll->setTakeKey(m_pValBuf);
          }
     }
     return(true);
}

bool
editPollSynthesis::getAccessAttParam()      // handle "accessatt" parameter
{
     GETPARAMVAL("accessatt");
     if (!ISPARAMVAL) {
          setError(NOPARAM,"access attribute");
          return(false);
     }
     else {
          if (sameas(m_pValBuf,"SHOW")) {
               m_pPoll->setAccessAttrib(SHOW);
          }
          else if (sameas(m_pValBuf,"DIM")) {
               m_pPoll->setAccessAttrib(DIM);
          }
          else if (sameas(m_pValBuf,"HIDE")) {
               m_pPoll->setAccessAttrib(HIDE);
          }
          else {
               setError(UNXVAL,m_pValBuf,"access attribute");
               return(false);
          }
     }
     return(true);
}

bool
editPollSynthesis::checkSuper()             // handle "super" access for user
{
     if (!hasSuperAccess()) {
          setError(GRANTAWD);
          return(false);
     }
     return(true);
}

bool
editPollSynthesis::getGrantKeyParam()       // handle "grantkey" parameter
{
     bool rc=checkSuper();
     if (rc) {
          GETPARAMVAL("grantkey");
          if (ISPARAMVAL) {
               if (!keynam(m_pValBuf)) {
                    setError(INVVAL,"logonkey");
                    rc=false;
               }
               else {
                    m_pPoll->setGrantKey(m_pValBuf);
               }
          }
     }
     return(rc);
}

bool
editPollSynthesis::getGrantClsParam()       // handle "grantcls" parameter
{
     bool rc=checkSuper();
     if (rc) {
          GETPARAMVAL("grantcls");
          if (ISPARAMVAL) {
              m_pPoll->setGrantClass(m_pValBuf);
          }
     }
     return(rc);
}

bool
editPollSynthesis::getGrantCredParam()      // handle "grantcred" parameter
{
     bool rc=checkSuper();
     if (rc) {
          GETPARAMVAL("grantcred");
          if (ISPARAMVAL) {
               CHAR *cPtr=m_pValBuf;
               if (m_pValBuf[0] == '-' && !alldgs((cPtr=&m_pValBuf[1]))) {
                    setError(UNXVAL,m_pValBuf,"grant credits");
                    rc=false;
               }
               else if (!alldgs(m_pValBuf)) {
                    setError(UNXVAL,m_pValBuf,"grant credits");
                    rc=false;
               }
               else if (strlen(cPtr) > MAXCREDLEN) {
                    setError(TOOLONG,"grant credits",spr("%d",MAXCREDLEN));
                    rc=false;
               }
               else {
                    m_pPoll->setGrantCredits(atol(m_pValBuf));
               }
          }
     }
     return(rc);
}

bool
editPollSynthesis::getGrantFileParam()      // handle "grantfile" parameter
{
     bool rc=checkSuper();
     if (rc) {
          GETPARAMVAL("grantfile");
          if (ISPARAMVAL) {
               m_pPoll->setGrantFile(m_pValBuf);
          }
     }
     return(rc);
}

bool
editPollSynthesis::savePoll()               // handle saving poll
{
     bool rc;
     if (m_pAPI->isPoll(m_pPoll->getName())) {
          rc=m_pPoll->update();
     }
     else {
          m_pPoll->setCreateDate(today());
          rc=m_pPoll->create();
     }
     return(rc);
}
