/***************************************************************************
 *                                                                         *
 *   DELQUES.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Delete Questions Synthesis Class.                                     *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "delques.h"
#include "dnfmgr.h"
#include "majorbbs.h"

#define FILREV "$Revision: 3 $"

#define DELQUESDIR "questions/delete/"

enum {DELQPARAM, DELQRESP};

// dynafile stuff

dnfStep dnfDelQErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfDelQDefSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfDelQErrMap(PPFIX DELQUESDIR "error.htm","Delete Error Steps",dnfDelQErrSteps);
dnfMap dnfDelQDefMap(PPFIX DELQUESDIR "index.htm","Delete Index Steps",dnfDelQDefSteps);

// class method defs

MARKSOURCE(delQues);

delQuesSynthesis::delQuesSynthesis(   // default constructor
                   acthSession *_ses):// session object
                   pManSynthesis(_ses)
{
     m_ahState=DELQPARAM;
}

delQuesSynthesis::~delQuesSynthesis() // destructor
{
     if (m_pPoll != NULL) {
          delete m_pPoll;
          m_pPoll=NULL;
     }
     if (m_pQues != NULL) {
          delete m_pQues;
          m_pQues=NULL;
     }
}

bool
delQuesSynthesis::getPollNameParam()
{
     bool rc=false;
     GETPARAMVAL("pollname");
     if (m_pValBuf[0] == '\0') {
          setError(NOPARAM,"pollname");
     }
     else if (!m_pAPI->isPoll(m_pValBuf)) {
          setError(POLLNFND,m_pValBuf);
     }
     else {
          m_pPoll=new poll(m_pValBuf);
          rc=true;
     }
     return(rc);
}

bool
delQuesSynthesis::getNumberParam()
{
     bool rc=false;
     GETPARAMVAL("number");
     if (m_pValBuf[0] == '\0') {
          setError(PVALNFND,"number");
     }
     else if (!m_pPoll->isQuestion(atoi(m_pValBuf))) {
          setError(QUESNFND,m_pValBuf);
     }
     else if (atoi(m_pValBuf) == 0) {
          setError(NODELONE);
     }
     else {
          m_pQues=new question(m_pPoll->getName(),atoi(m_pValBuf));
          rc=true;
     }
     return(rc);
}

ACTHCODE
delQuesSynthesis::proceed()        // proceed entry point
{
     ACTHCODE retval;
     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }
     if (m_cyc.start()) {
          do {
               switch(m_ahState) {
               case DELQPARAM:
                    if (!getPollNameParam() || !getNumberParam()) {
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfDelQErrMap,PPFIX);
                    }
                    else {
                         m_pQues->remove();
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfDelQDefMap,PPFIX);
                    }
                    m_ahState=DELQRESP;
                    break;
               case DELQRESP:
                    if (m_pPoll != NULL) {
                         m_pTvb->setPollEditVbs(m_pPoll);
                    }
                    if (m_pQues != NULL) {
                         m_pTvb->setQuesEditVbs(m_pQues);
                    }
                    retval=dynafile();
                    break;
               }
          } while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}
