/***************************************************************************
 *                                                                         *
 *   DELPOLL.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Delete Poll Synthesis Class.                                          *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "delpoll.h"
#include "dnfmgr.h"
#include "majorbbs.h"

#define FILREV "$Revision: 3 $"

#define DELPOLLDIR "polls/delete/"

enum {DELPARAM, DELRESP};

// dynafile stuff

dnfStep dnfDelErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfDelDefSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfDelErrMap(PPFIX DELPOLLDIR "error.htm","Delete Error Steps",dnfDelErrSteps);
dnfMap dnfDelDefMap(PPFIX DELPOLLDIR "index.htm","Delete Index Steps",dnfDelDefSteps);

 // class method defs

MARKSOURCE(delpoll);

delPollSynthesis::delPollSynthesis(   // default constructor
                   acthSession *_ses):// session object
                   pManSynthesis(_ses)
{
     m_ahState=DELPARAM;
}

delPollSynthesis::~delPollSynthesis() // destructor
{
     if (m_pPoll != NULL) {
          delete m_pPoll;
          m_pPoll=NULL;
     }
}

ACTHCODE
delPollSynthesis::proceed()        // proceed entry point
{
     ACTHCODE retval;
     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }
     if (m_cyc.start()) {
          do {
               switch(m_ahState) {
               case DELPARAM:
                    GETPARAMVAL("pollname");
                    if (m_pValBuf[0] == '\0') {
                         setError(NOPARAM,"pollname");
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfDelErrMap,PPFIX);
                    }
                    else if (!m_pAPI->isPoll(m_pValBuf)) {
                         setError(POLLNFND,m_pValBuf);
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfDelErrMap,PPFIX);
                    }
                    else {
                         m_pPoll=new poll(m_pValBuf);
                         m_pPoll->tag4delete();
                         m_pPoll->update();
                         m_dnfPtr=dnfCreateHandlerURL(ses,&dnfDelDefMap,PPFIX);
                    }
                    m_ahState=DELRESP;
                    break;
               case DELRESP:
                    if (m_pPoll != NULL) {
                         m_pTvb->setPollEditVbs(m_pPoll);
                    }
                    retval=dynafile();
                    break;
               }
          } while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}
