/***************************************************************************
 *                                                                         *
 *   GALNOGCV.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Conversion utility for Gcomm Notes Generic Database Records.          *
 *   NOTE: This utility should only be used for DOS 2.0 to NT and DOS 3.0  *
 *         to NT conversions, since the ffblk structure is different under *
 *         NT.                                                             *
 *                                                                         *
 *                                           - Bill Hyatt   8/1/96         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"
#include "majorbbs.h"
#include "dfcapi.h"

#define IDSTG "WGSNOGCV"           /* id stg for API calls                 */

/* Following taken from DOS 3.0 / NT version of GALNOTE.C */

struct ntgen {                     /* bbsgen.dat load/save structure       */
     CHAR userid[UIDSIZ];          /*     User-ID for load/save            */
     CHAR modnam[MNMSIZ];          /*     Module name (GCOMM NOTES)        */
     struct ffblk ntblk;           /*     ffblk for last read file         */
};
/* end GALNOTE.C declarations */

#define DSTDAT ((struct ntgen *)dstbb->data) /* cast for dest data         */

_NOSCNS_                           /* keep DFCDISP.C happy                 */

/* following based on struct ffblk in DOS.H (Borland include file), flat
   memory model version */

struct o_ffblk {
     CHAR ff_reserved[21];
     CHAR ff_attrib;
     USHORT ff_ftime;
     USHORT ff_fdate;
     LONG ff_fsize;
     CHAR ff_name[13];
};
/* end DOS.H declarations */

CHAR recbuf[GENSIZ];               /* buffer for generic db records        */

INT
main(INT argc,CHAR *argv[])
{
     INT cvtflg,srcflg=0,dstflg=0,keyno;
     GBOOL fnd;
     LONG srcfsiz;
     ULONG currec;
     struct o_ffblk o_ntblk;

TRY
     if (dfcCustInitGen(argc,argv,IDSTG) != 0) {
          catastro(dfcLastErr());
     }
     if (!dfcOpenFilesGen(GENSIZ,&srcfsiz,GENSIZ)) {
          catastro(dfcLastErr());
     }
     if (!dfcChkDskSpc(srcfsiz)) {
          catastro(dfcLastErr());
     }
     if (dfcSupFlags(&srcflg,&dstflg) != 0) {
          catastro(dfcLastErr());
     }
     if (dfaCountRec() > 0L) {
          keyno=atoi(itemidxd(argv[RECORDIDX],1,","));
          for (fnd=dfaAcqEQ(recbuf,argv[MODULEIDX],keyno),currec=0L ; fnd
                                                       ; fnd=dfaAcqNX(recbuf)) {
               dfcDspRecs(++currec,NODISP);
               memset(dstbb->data,0,sizeof(struct ntgen));
               takeInit(recbuf,dfaLastLen(),CVTPACKED,CVTSERVER);
               /* these calls based on struct ffblk in DOS.H (Borland include
                  file), non-flat memory model version */
               cvtflg=takeChar(DSTDAT->userid,UIDSIZ);
               cvtflg&=takeChar(DSTDAT->modnam,MNMSIZ);
               cvtflg&=takeChar(NULL,21);
               cvtflg&=takeChar(&o_ntblk.ff_attrib,1);
               cvtflg&=takeShort(&o_ntblk.ff_ftime,1);
               cvtflg&=takeShort(&o_ntblk.ff_fdate,1);
               cvtflg&=takeLong(&o_ntblk.ff_fsize,1);
               cvtflg&=takeChar(o_ntblk.ff_name,13);
               if (cvtflg&1) {
                    DSTDAT->ntblk.ff_fsize=o_ntblk.ff_fsize;
                    DSTDAT->ntblk.ff_attrib=(LONG)o_ntblk.ff_attrib;
                    DSTDAT->ntblk.ff_ftime=o_ntblk.ff_ftime;
                    DSTDAT->ntblk.ff_fdate=o_ntblk.ff_fdate;
                    strcpy(DSTDAT->ntblk.ff_name,o_ntblk.ff_name);
                    dfaSetBlk(dstbb);
                    dfaInsertV(NULL,sizeof(struct ntgen));
               }
               else {
                    catastro("WGSFLGCV: Error getting source data!");
               }
               dfaSetBlk(srcbb);
          }
     }
     dfaClose(srcbb);
     dfaClose(dstbb);
     dfcClrRecs();
     clsvid();
EXCEPT
     return(0);
}
