/***************************************************************************
 *                                                                         *
 *   EMLFOR.H                                                              *
 *                                                                         *
 *   Copyright (c) 1988-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   E-mail and Forums shared variable and function definitions            *
 *   (common to both ASCII/ANSI and Client/Server).                        *
 *                                                                         *
 *                                                - J. Alvrus  10/20/94    *
 *                                                                         *
 ***************************************************************************/

 #ifndef __EMLFOR_H
 #define __EMLFOR_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

                                   /* per-user, non-VDA or per-request     */
#define INEMAIL 0x0001             /*   user is in E-mail (not a Forum)    */
#define INEDIT  0x0002             /*   user is in the editor              */
#define INFTF   0x0004             /*   user is in file transfer           */
#define INFSD   0x0008             /*   user is in full-screen data service*/
#define INEDHLP 0x0010             /*   user is editing forum help message */
#define WRTIPG  0x0020             /*   write in progress on this channel  */

extern HMCVFILE efmb;              /* E-mail/Forums CNF options file       */
extern struct ffblk effb;          /* E-mail/Forums find block (one-shot)  */
extern struct qscfg *qsptr;        /* current user's quickscan             */
extern SHORT *peruflg;             /* per-user, non-VDA flags              */
extern struct message *msg;        /* current message header structure     */
extern
CHAR *msgtxt,                      /* current message text buffer          */
     *filatt,                      /* current file att path+file name      */
     *abvcmt,                      /* header above comment in message text */
     *blwcmt;                      /* header below comment in message text */
extern SHORT ccmax;                /* max # CCs to allow                   */
extern GBOOL alwcpy;               /* allow user to CC a message           */
extern VOID *efwork;               /* current GME request work area        */
extern SHORT numscans;             /* number of scan buffers available     */
extern struct otscan **usrscn;     /* per-user array of scan buffer ptrs   */

VOID
iniaa(VOID);                       /* initialize ASCII/ANSI stuff          */

VOID
inics(VOID);                       /* initialize Client/Server stuff       */

struct otscan *                    /*   returns NULL if not available      */
rsvscan(                           /* reserve a scan buffer                */
INT unum);                         /*   for this channel                   */

VOID
unrscan(                           /* unreserve scan buffer                */
INT unum);                         /*   for this channel                   */

GBOOL                              /*   returns TRUE if recip notified     */
wrtnot(                            /* notify recipient of new mail to them */
const CHAR *to,                    /*   to whom the message was written    */
const struct message *msg);        /*   message header structure           */

GBOOL                              /*   returns TRUE if recip notified     */
cpynot(                            /* notify recipient of copy to them     */
const CHAR *to);                   /*   to whom the message was copied     */

GBOOL                              /*   returns TRUE if recip notified     */
fwdnot(                            /* notify recipient of fwd to them      */
const CHAR *to);                   /*   to whom the message was forwarded  */

GBOOL                              /*   returns TRUE if recip notified     */
rrgnot(                            /* notify sender of receipt generation  */
const CHAR *to);                   /*   to whom the return receipt was sent*/

CHAR *                             /*   returns copy of pointer to string  */
lf2cr(                             /* change \n to \r in a string          */
CHAR *text);                       /*   string to change                   */

GBOOL
valfdfnam(                         /* is this a valid forum data file name?*/
const CHAR *nam);                  /*   file name to change                */

CHAR *                             /*   returns copy of pointer to buffer  */
fixfdfnam(                         /* fix up forum data file name          */
CHAR *nambuf);                     /*   file name buffer (must be MAXPATH) */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __EMLFOR_H                           */
