/***************************************************************************
 *                                                                         *
 *   EFUTL.C                                                               *
 *                                                                         *
 *   Copyright (c) 1988-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   E-mail and Forums utilities and common functions (for both            *
 *   ASCII/ANSI and Client/Server).                                        *
 *                                                                         *
 *                                                - J. Alvrus 8/2/94       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gme.h"
#include "galmsg.h"
#include "emlfor.h"

#define FILREV "$Revision: 9 $"

HMCVFILE efmb;                     /* E-mail/Forums .MSG file              */
struct ffblk effb;                 /* general-purpose find block           */
struct qscfg *qsptr;               /* current user's quickscan             */
SHORT *peruflg;                    /* per-user, non-VDA flags              */
struct message *msg;               /* current message header structure     */
CHAR *msgtxt,                      /* current message text buffer          */
     *filatt,                      /* current file att path+file name      */
     *abvcmt,                      /* header above comment in message text */
     *blwcmt;                      /* header below comment in message text */
GBOOL alwcpy;                      /* allow user to CC a message           */

SHORT numscans;                    /* number of scan buffers available     */
static INT *scanchan;              /* array of channel # associated w/scan */
static VOID *scanhead;             /* head of scan buffer array            */
struct otscan **usrscn=NULL;       /* per-user array of scan buffer ptrs   */

#define NOTINU -1                  /* scan buffer not-in-use code          */


VOID EXPORT
init__galmsg(VOID)
{
     INT i;

     init__galme();
     efmb=opnmsg("galmsg.mcv");
     peruflg=(SHORT *)alczer(nterms*sizeof(SHORT));
     alwcpy=ynopt(ALWCPY);
     abvcmt=strdup(stpans(rawmsg(ABVCMT)));
     blwcmt=strdup(stpans(rawmsg(BLWCMT)));
     numscans=numopt(NSCNPOOL,-1,256);
     if (numscans < 0 || numscans > nterms) {
          numscans=nterms;
     }
     if (numscans > 0) {
          scanhead=alcblok(numscans,
                           (sizeof(struct otscan)+sizeof(SHORT)*(maxqsf()-1)));
          scanchan=(INT *)alcmem((UINT)numscans*sizeof(INT));
          for (i=0 ; i < numscans ; ++i) {
               scanchan[i]=NOTINU;
          }
     }
     usrscn=(struct otscan **)alczer(nterms*sizeof(struct otscan *));
     iniaa();
     inics();
}

VOID EXPORT
initwc__galmsg(VOID)
{
     init__galmsg();
}


struct otscan *                    /*   returns NULL if not available      */
rsvscan(                           /* reserve a scan buffer                */
INT unum)                          /*   for this channel                   */
{
     INT i;

#ifdef DEBUG
     for (i=0 ; i < numscans ; ++i) {
       ASSERT(scanchan[i] != unum);
     }
#endif
     for (i=0 ; i < numscans && scanchan[i] != NOTINU ; ++i) {
     }
     if (i == numscans) {
          return(NULL);
     }
     scanchan[i]=unum;
     return((struct otscan *)ptrblok(scanhead,i));
}

VOID
unrscan(                           /* unreserve scan buffer                */
INT unum)                          /*   for this channel                   */
{
     INT i;

     for (i=0 ; i < numscans ; ++i) {
          if (scanchan[i] == unum) {
               scanchan[i]=NOTINU;
#ifdef DEBUG
            for ( ; i < numscans ; ++i) {
              ASSERT(scanchan[i] != unum);
            }
#endif
               return;
          }
     }
     ASSERTM(FALSE,"attempt to unreserve an unreserved scan buffer");
}

GBOOL                              /*   returns TRUE if recip notified     */
wrtnot(                            /* notify recipient of new mail to them */
const CHAR *to,                    /*   to whom the message was written    */
const struct message *msg)         /*   message header structure           */
{
     ASSERT(msg != NULL);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     if (onsys(usaptr->userid)) {
          if (onsys(to) && !sameas(usaptr->userid,to)) {
               setmbk(efmb);
               if (msg->forum == EMLID) {
                    if (msg->flags&PRIMSG) {
                         prfmlt(PTOUPG,usaptr->userid);
                    }
                    else {
                         prfmlt(ETOUPG,usaptr->userid);
                    }
               }
               else {
                    prfmlt(FTOUPG,usaptr->userid,getfnm(msg->forum));
               }
               rstmbk();
               return(injoth());
          }
     }
     return(FALSE);
}

GBOOL                              /*   returns TRUE if recip notified     */
cpynot(                            /* notify recipient of copy to them     */
const CHAR *to)                    /*   to whom the message was copied     */
{
     ASSERT(to != NULL);
     if (onsys(usaptr->userid)) {
          if (onsys(to) && !sameas(usaptr->userid,to)) {
               setmbk(efmb);
               prfmlt(CPYPG,usaptr->userid);
               rstmbk();
               return(injoth());
          }
     }
     return(FALSE);
}

GBOOL                              /*   returns TRUE if recip notified     */
fwdnot(                            /* notify recipient of fwd to them      */
const CHAR *to)                    /*   to whom the message was forwarded  */
{
     ASSERT(to != NULL);
     if (onsys(usaptr->userid)) {
          if (onsys(to) && !sameas(usaptr->userid,to)) {
               setmbk(efmb);
               prfmlt(FWDPG,usaptr->userid);
               rstmbk();
               return(injoth());
          }
     }
     return(FALSE);
}

GBOOL                              /*   returns TRUE if recip notified     */
rrgnot(                            /* notify sender of receipt generation  */
const CHAR *to)                    /*   to whom the return receipt was sent*/
{
     ASSERT(to != NULL);
     if (onsys(usaptr->userid)) {
          if (onsys(to) && !sameas(usaptr->userid,to)) {
               setmbk(efmb);
               prfmlt(RRGPG,usaptr->userid);
               rstmbk();
               return(injoth());
          }
     }
     return(FALSE);
}

CHAR *
lf2cr(                             /* replace '\n' with '\r'               */
CHAR *str)                         /*   in this string                     */
{
     return(strrpl(str,'\n','\r'));
}

GBOOL
valfdfnam(                         /* is this a valid forum data file name?*/
const CHAR *nam)                   /*   file name to change                */
{
     CHAR *cp;

     cp=strrchr(nam,'.');
     return(cp == NULL || sameas(cp,".dat"));
}

CHAR *                             /*   returns copy of pointer to buffer  */
fixfdfnam(                         /* fix up forum data file name          */
CHAR *nambuf)                      /*   file name buffer (must be MAXPATH) */
{
     CHAR *cp;

     cp=strrchr(nambuf,'.');
     if (cp != NULL) {
          *cp='\0';
     }
     return(stlcat(nambuf,".dat",MAXPATH));
}
