/***************************************************************************
 *                                                                         *
 *   CSEF.H                                                                *
 *                                                                         *
 *   Copyright (c) 1988-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Client/Server E-mail and Forums shared variable and function          *
 *   definitions.                                                          *
 *                                                                         *
 *                                                - J. Alvrus  10/20/94    *
 *                                                                         *
 ***************************************************************************/

#ifndef __CSEF_H
#define __CSEF_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define FLDSEP '\1'                /* message dynapak field separator      */

#define EMLAPID "GALEML"           /* E-mail agent App-ID                  */
#define FORAPID "GALFOR"           /* Forums agent App-ID                  */

#define EMLATT "emlatt "           /* get E-mail attachment dpk suffix     */
#define FORATT "foratt "           /* get forum attachment                 */
#define WRTNEW "wrtnew"            /* new message dynapak suffix           */
#define WRTRPL "wrtrpl"            /* reply dynapak suffix                 */
#define CCLSFX "cclist "           /* cc: list dynapak suffix              */
#define UPLATT "msgatt "           /* new message attachment suffix        */
#define LEXDPK "lex "              /* download spelling checker dpk        */

#define LEXDIR "galmsg\\lex\\"     /* spelling checker file path           */

#define WRTBUSY  1000              /* error code for "write buffer in use" */
#define PFNERR   1001              /* error code for too much profanity    */
#define BADADR   1002              /* error code for bad address           */
#define TOOMNY   1003              /* error code for too many cc: addresses*/
#define CMTERR   1004              /* unable to add comments error         */
#define CCEXP    FILAPV            /* cc: list coming for message flag     */
#define NOHDL    -1                /* returned from rsvarea() if none avail*/
#define ACPYSIZ  1024              /* chunk size when copying attachment   */
#define GRPSTKSZ 20                /* group ID stack size                  */

struct emlacc {                    /* E-mail access dynapak structure      */
     SHORT flags;                  /*   access flags                       */
     SHORT ccmax;                  /*   max # cc:s per message             */
     LONG txtlen;                  /*   message text buffer size           */
     CHAR dftuid[UIDSIZ-1];        /*   default/sysop User-ID              */
};
                                   /* E-mail/Forums access flags           */
#define EAWRITE  0x0001            /*   write E-mail other than "Sysop"    */
#define EAATTACH 0x0002            /*   attach files to messages           */
#define EARECREQ 0x0004            /*   request return receipts            */
#define EAPRIMSG 0x0008            /*   write priority message             */
#define EAFOROP  0x0010            /*   perform Forum-Op operations        */
#define EAINDATT 0x0020            /*   make indirect attachments to msgs  */
#define EAMSLST  0x0040            /*   use !MASS list                     */
#define EAEDLST  0x0080            /*   create/edit server-side lists      */

struct cdetail {                   /* carrier detail dynapak structure     */
     CHAR prefix[PFXSIZ-1];        /*   carrier prefix                     */
     CHAR name[EXPNSZ-1];          /*   carrier name                       */
     SHORT flags;                  /*   access flags                       */
     CHAR info[1];
};

                                   /* C/S write request states             */
#define WAIT4CC  1                 /*   waiting for cc: list               */
#define WAIT4ATT 2                 /*   waiting for attachment             */
#define UPINGATT 3                 /*   uploading attachment               */
#define CPYNGATT 4                 /*   copying attachment                 */
#define SENDING  5                 /*   writing message                    */

extern
struct wrtbuf {                    /* pool memory structure for msg writes */
     CHAR filatt[GCMAXPTH];        /*   file attachment                    */
     CHAR *cclist;                 /*   separately-allocated cc: list      */
     LONG primsg;                  /*   primary message ID                 */
     struct message msg;           /*   message header                     */
     CHAR text[1];                 /*   message text buffer                */
} *wrtbuf;

struct uplinf {                    /* attachment upload info               */
     INT othrqid;                  /*   request ID of primary write dynapak*/
     USHORT time;                  /*   file time stamp                    */
     USHORT date;                  /*   file date stamp                    */
     CHAR attpath[GCMAXPTH];       /*   path being uploaded to             */
};

struct grprqi {                    /* per-req info for forming group file  */
     USHORT grpid;                 /*   current group ID                   */
     CHAR name[FORNSZ];            /*   current forum/group name           */
     CHAR grpstr[GRPSTKSZ*FORNSZ]; /*   current group path string          */
     INT sp;                       /*   group ID stack pointer             */
     USHORT grpstk[GRPSTKSZ];      /*   group info stack                   */
};

extern
struct rqinfo {                    /* C/S E-mail/Forums per-request struct */
     SCHAR stt;                    /*   read direction/write state         */
     CHAR flags;                   /*   request control flags              */
     INT wrthdl;                   /*   handle of memory area for writing  */
     FILE *ifp;                    /*   input file                         */
     FILE *ofp;                    /*   output file                        */
     struct saunam dpknam;         /*   dynapak name storage               */
     union {
          LONG __dummy__;          /*   ensure alignment                   */
          CHAR work[GMEWRKSZ];     /*   GME work area                      */
          struct uplinf uplinf;    /*   attachment upload info             */
          CHAR tag[TSLENG];        /*   attachment download tag buffer     */
          struct grprqi g;         /*   group file download info           */
          char fornam[FORNSZ];     /*   current forum name for info file   */
     } u;
} *rqiptr;                         /* E-mail/Forums per-req memory ptr     */

                                   /* E-mail/Forums per-request flags      */
#define INCLTXT 0x01               /*   current read req includes msg text */
#define ISREPLY 0x01               /*   current write request is a reply   */
#define FORSYS  0x01               /*   making sysop forum file            */
#define GRPSYS  0x01               /*   making sysop group file            */
#define CLRTAG  0x02               /*   clear email tag after read         */
#define EXCERPT 0x02               /*   clear email tag after read         */
#define WDSTING 0x02               /*   current write op is distribution   */
#define WCCING  0x04               /*   current write op is carbon copying */
#define WCPYING 0x08               /*   copying attachment                 */
/*      RECREQ  0x10                    msg had return-receipt requested   */
#define SRVATT  0x10               /*   attachment not being uploaded      */
#define BUFINU  0x20               /*   request has reserved a write buffer*/

struct msgdpk {                    /* in-dynapak message structure         */
     USHORT forum;                 /*   ID of forum message belongs to     */
     CHAR axes;                    /*   access flags for forum this msg in */
     CHAR fornam[FORNSZ-1];        /*   name of forum this message is in   */
     LONG msgid;                   /*   unique message identifier          */
     struct globid gmid;           /*   unique global message identifier   */
     LONG thrid;                   /*   ID of thread message is part of    */
     CHAR attname[GCMAXFNM-1];     /*   attached file name                 */
     DOUBLE crdatim;               /*   message creation date and time     */
     struct globid rplto;          /*   global ID of msg this is a reply to*/
     SHORT nrpl;                   /*   number of times replied to         */
     SHORT flags;                  /*   message/attachment flag bits       */
     CHAR info[1];                 /*   info field (see below)             */
};

struct newdpk {                    /* in-dynapak new message structure     */
     USHORT orgfor;                /*   forum original message was in      */
     USHORT forum;                 /*   forum msg being written to         */
     LONG msgid;                   /*   unique message identifier          */
     struct globid gmid;           /*   unique global message identifier   */
     LONG thrid;                   /*   ID of thread message is part of    */
     CHAR attname[GCMAXFNM-1];     /*   attached file name                 */
     SHORT flags;                  /*   message/attachment flag bits       */
     CHAR info[1];                 /*   info field (see below)             */
};

struct wrterr {                    /* message write error structure        */
     SHORT flags;                  /*   what feature(s) caused the error   */
     SHORT rc;                     /*   type of error that occurred        */
};

                                   /* message write error flags            */
/*      PRIMSG  0x0001                  message is "priority"              */
#define FORUM   0x0002             /*   error in forum ID                  */
#define ADDRESS 0x0004             /*   error in address                   */
#define CCOPY   0x0008             /*   error in carbon copies             */
/*      RECREQ  0x0010                  error in return-receipt request    */
/*      FILIND  0x0020                  "indirect" att, direct has filespec*/
/*      FILATT  0x0040                  file is attached to this message   */
#define THEMSG  0x8000             /*   error occurred while writing msg   */

extern
INT wrmpool,                       /* E-mail/Forums write msg pool handle  */
    csmaxcc;                       /* max # cc:s for C/S users             */

                                   /* common FDAs                          */
extern struct flddef globidFDA[];  /*   global message ID                  */
extern struct flddef newdpkFDA[];  /*   new message dynapak                */
extern struct flddef msgdpkFDA[];  /*   read message dynapak               */

VOID
inicseml(VOID);                    /* initialize Client/Server E-mail agent*/

VOID
inicsfor(VOID);                    /* initialize Client/Server Forums agent*/

VOID
fordisc(VOID);                     /* forum-specific disconnect handler    */

VOID
cssetup(VOID);                     /* set up stuff for C/S E-mail/Forums   */

VOID
efcurreq(                          /* set current request for E-mail/Forums*/
INT reqid);                        /*   request ID to set to               */

VOID
crd4att(VOID);                     /* cycled read message for att dl       */

VOID
rd4att(VOID);                      /* read message in prep for att dl      */

VOID
wrtnew(                            /* C/S write new message handler        */
struct saunam *dpknam,             /*   dynapak name in use                */
struct newdpk *newdpk);            /*   new message dynapak                */

VOID
wrtrpl(                            /* C/S write new message handler        */
struct saunam *dpknam,             /*   dynapak name in use                */
struct newdpk *newdpk);            /*   new message dynapak                */

VOID
gcclst(                            /* got cc: list for message             */
struct saunam *dpknam,             /*   dynapak name in use                */
CHAR *cclist);                     /*   ';'-deliminated list of cc:s       */

VOID
uplatt(                            /* upload an attachment to a new msg    */
struct saunam *dpknam,             /*   dynapak name in use                */
struct filinf *finfo);             /*   file dynapak info structure        */

VOID
uladone(VOID);                     /* done uploading attachment to message */

VOID
uplabt(VOID);                      /* attachment upload aborted            */

VOID
wrtabt(VOID);                      /* message write request aborted        */

VOID
csfwd(                             /* C/S common forward-message function  */
struct saunam *dpknam,             /*   dynapak name in use                */
CHAR *fwdinf);                     /*   address to fwd to/comments         */

VOID
cscopy(                            /* C/S common copy-message function     */
struct saunam *dpknam,             /*   dynapak name in use                */
CHAR *cpyinf);                     /*   address to copy to/comments        */

SHORT                              /*   returns GME status code            */
readir(                            /* read message with direction          */
INT dir,                           /*   direction to read                  */
VOID *work,                        /*   GME work area                      */
struct message *msg,               /*   message header buffer              */
CHAR *text);                       /*   message text buffer                */

VOID
cswrtup(VOID);                     /* set global ptrs to current write buf */

ULONG
iotck(VOID);                       /* get # hrtval() tcks to use for I/O   */

VOID
vdamsg(VOID);                      /* set msg and msgtxt to point at vdatmp*/

LONG
s2mn(                              /* converts string to msg# w/ error chk */
CHAR *s);                          /*   string to convert                  */

INT
s2rq(                              /* converts string to reqid w/error chk */
CHAR *s);                          /*   string to convert                  */

CHAR *                             /*   returns pointer to static buffer   */
longstr(                           /* convert long int to left-padded str  */
LONG n);                           /*   number to convert                  */

CHAR *                             /*   copy of pointer to destination     */
chrcat(                            /* concatenate a character onto a string*/
CHAR *s,                           /*   string to add to                   */
CHAR c);                           /*   character to add                   */

struct msgdpk *                    /*   returns copy of pointer to dest    */
msg2dpk(                           /* copy message to dynapak form         */
struct message *msg,               /*   message header                     */
CHAR *text,                        /*   message text                       */
struct msgdpk *dpk,                /*   message dynapak buffer             */
GBOOL incltxt);                    /*   include message text in dmsg?      */

GBOOL
valtpc(                            /* is this an acceptible topic string?  */
const CHAR *topic);                /*   topic string                       */

VOID
getlex(                            /* get spelling checker file            */
struct saunam *dpknam);            /*   dpk name in use                    */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __CSEF_H                             */
