/***************************************************************************
 *                                                                         *
 *   AAEF.H                                                                *
 *                                                                         *
 *   Copyright (c) 1988-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   ASCII/ANSI E-mail and Forums shared variable and function             *
 *   definitions.                                                          *
 *                                                                         *
 *                                                - J. Alvrus 8/5/94       *
 *                                                                         *
 ***************************************************************************/

#ifndef __AAEF_H
#define __AAEF_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define LINLEN 80                  /* line length (for est. FSE needs)     */
#define MAXLSI 1024                /* max size of cycled list items        */
#define LISTIL 100                 /* stay in cycled list state til btuoba<*/
#define MAXPRV 5                   /* max # of previous positions stored   */

                                   /* cycled process substates             */
#define CHK4NEW  -1                /*   checking for new messages (logon)  */
#define SENDING  -2                /*   sending message                    */
#define CRDNEAR  -4                /*   read message                       */
#define CRDNEXT  -5                /*   read next message                  */
#define CRDPREV  -6                /*   read previous message              */
#define CREREAD  -7                /*   re-read current message            */
#define CMARKRD  -8                /*   mark message read                  */
#define RPLING   -9                /*   sending a reply                    */
#define DELING   -10               /*   deleting message                   */
#define MODING   -11               /*   modifying message                  */
#define FWDING   -12               /*   forwarding message                 */
#define COPYING  -13               /*   copying message                    */
#define XMTING   -14               /*   transmitting message text          */
#define CRDPRNT  -15               /*   reading parent of current message  */
#define LISTING  -16               /*   showing a cycled list              */
#define CINIFOR  -17               /*   initializing new forum definition  */
#define CRTFOR   -18               /*   waiting for OUTMT to create a forum*/
#define EDTFOR   -19               /*   waiting for OUTMT to edit a forum  */
#define CREATING -20               /*   creating a forum                   */
#define EDITING  -21               /*   editing a forum                    */
#define FDELING  -22               /*   deleting a forum                   */
#define MSGLST   -23               /*   listing forum messages             */
#define NAPVING  -24               /*   searching for next msg to approve  */
#define PAPVING  -25               /*   searching for prev msg to approve  */

struct formid {                    /* forum ID + message ID structure      */
     USHORT fid;                   /*   forum ID                           */
     LONG mid;                     /*   message ID                         */
};

extern
struct efvda {                     /* ASCII/ANSI E-mail/Forums VDA struct  */
     SHORT count;                  /*   generic counter (also # of echoes) */
     INT savstt;                   /*   which module currently in use      */
     LONG curmid;                  /*   current message ID                 */
     LONG tmpmid;                  /*   for saving a message ID            */
     LONG prethr;                  /*   msg being read @ start of thread   */
     USHORT tmpfid;                /*   for saving a forum ID              */
     CHAR *txtptr;                 /*   output position in message text    */
     CHAR prvidx;                  /*   scan previous position index       */
     struct formid prvlst[MAXPRV]; /*   array of previous scan positions   */
     CHAR tmpadr[MAXADR];          /*   general-use address buffer         */
     LONG attsiz;                  /*   size of attachment                 */
     SHORT numcc;                  /*   current number of cc: addresses    */
     CHAR *cclist;                 /*   pointer to cc: list buffer         */
     CHAR *ccptr;                  /*   current position in cc: list       */
     USHORT cclstsz;               /*   size of cc: list buffer            */
     USHORT cmtspc;                /*   space available for comments       */
     CHAR *fsdspc;                 /*   FSD - Memory for forum create/edit */
     CHAR *fsdtmp;                 /*   FSD - Pointer to answer strings    */
     FILE *fp;                     /*   general use file                   */
     SHORT flags;                  /*   general purpose flags              */
     SHORT cflags;                 /*   cycled process control flags       */
     SHORT savflg;                 /*   place to save message flags        */
     CHAR dftchr;                  /*   result of call to getdft()         */
     SHORT nearop;                 /*   current read near style            */
     CHAR inpsav[DFTIMX+1];        /*   buf for saving input while cycling */
     VOID (*whndun)(SHORT rc);     /*   current when-done routine          */
     GBOOL (*nxtlst)(VOID);        /*   current list output routine        */
     CHAR efwork[GMEWRKSZ];        /*   GME work area                      */
     CHAR tmppath[GCMAXPTH];       /*   temporary path buffer              */
     union {                       /*   large, overlaid buffer area        */
          struct {                 /* message reading/writing buffers      */
               CHAR filatt[GCMAXPTH];   /*   file attachment path+file name*/
               struct message msg;      /*   message header buffer         */
               CHAR msgtxt[1];          /*   message text buffer           */
          } m;
          struct {                      /* !QUICK list editing buffers     */
               struct qikdat qik;       /*   !QUICK list header structure  */
               CHAR l[MAXQKR-sizeof(struct qikdat)-1]; /* ensure size      */
          } q;
          struct {                      /* view/edit/create forum buffers  */
               union {
                    struct fordef def;  /*   edit forum buffer             */
                    struct fordsk dsk;  /*   create forum buffer           */
               } d;
               union {
                    CHAR echo[MAXADR];  /*   echo address buffer           */
                    CHAR v[MAXFDV];     /*   ensure size                   */
               } v;
          } f;
          struct foracc a;              /* configure user access structure */
     } u;
} *efvda;                          /* properly typed pointer to VDA        */

                                   /* efvda flags                          */
#define RAFIPG  0x0001             /*   "reply-after-forward" in progress  */
#define LSTFUL  0x0001             /*   listing full message               */
#define LSTBRF  0x0002             /*   listing brief message descriptions */
#define ATTOK   0x0002             /*   attachment has been validated      */
#define RRROK   0x0004             /*   return receipt has been validated  */
#define PRIOK   0x0008             /*   priority message has been validated*/
#define LONIPG  0x0010             /*   logon in progress                  */
#define JUMPED  0x0020             /*   user "jumped" to specific message  */
#define CCLST   0x0040             /*   include cc: list in message        */
#define LOFUPL  0x0080             /*   user wants to log off after upload */
#define QSCIPG  0x0100             /*   quickscan in progress (not search) */
#define FUPOK   0x0200             /*   file upload completed successfully */
#define ISRPL   0x0400             /*   current write operation is a reply */
#define RDFROM  0x0800             /*   reading messages from user         */
#define THRING  0x1000             /*   reading messages in a thread       */
#define CRTING  0x2000             /*   creating (not editing) forum flag  */
#define LONFIN  0x8000             /*   time-to-exit-from-logon flag       */

                                   /* efvda cflags                         */
#define DIDCYC  0x0001             /*   did a cycled routine flag          */
#define CKDCYC  0x0002             /*   have already checked for cycle     */
#define INJOSAV 0x0010             /*   user did not have NOINJO flag set  */
#define NOCUR   0x0020             /*   no current message while reading   */
#define WDSTING 0x0040             /*   current write op is distribution   */
#define WCCING  0x0080             /*   current write op is carbon copying */
#define WCPYING 0x0100             /*   copying attachment                 */
#define SCN4UA  0x0200             /*   scanning for unapproved attachments*/
#define UATFND  0x0400             /*   an unapproved attachment was found */
#define LSTDONE 0x0800             /*   forum message list finished        */

extern
INT emlstate,                      /* E-mail module state code             */
    forstate;                      /* Forums module state code             */
extern
struct qikdat *qikbuf;             /* !QUICK struct in VDA                 */
extern
struct fordef *fdef;               /* forum def struct in VDA              */
extern
struct fordsk *fdsk;               /* on-disk forum struct in VDA          */
extern
CHAR *desc,                        /* forum description buf in VDA         */
     *msgatr;                      /* ANSI message body color string       */
extern
adr_t *echo;                       /* forum echoes buffer in VDA           */
extern
GBOOL cb4hdr;                      /* A/A clear before message (non-browse)*/

/* functions from AAEML.C */

VOID
iniaaeml(VOID);                    /* initialize ASCII/ANSI E-mail module  */

VOID
dsetprf(                           /* display: set preferences menu        */
INT pmt);                          /*   which menu to show (normal or help)*/

/* functions from AAFOR.C */

VOID
iniaafor(VOID);                    /* initialize ASCII/ANSI Forums module  */

VOID
gfmain(                            /* go to main forum menu                */
GBOOL shortform);                  /*   show short form?                   */

const CHAR *
curfnm(VOID);                      /* name of current Forum                */

const CHAR *
curftpc(VOID);                     /* topic of current Forum               */

GBOOL
dnldok(                            /* can user download attachment (if any)*/
USHORT forum);                     /*   forum in which message resides     */

GBOOL
isauth(VOID);                      /* is current user author of current msg*/

VOID
gfoprdst(VOID);                    /* show forum-op post-read prompt       */

VOID
listfor(                           /* list forums                          */
INT retstt);                       /*   substate to go to when done        */

/* functions from AAEFU.C */

GBOOL
efcflck(                           /* E-mail/Forums conflict checker       */
VOID *work,                        /*   work area to check                 */
USHORT forum,                      /*   forum to check                     */
LONG msgid);                       /*   message ID to check                */

USHORT                             /*   updated spinner position           */
spin(                              /* output a spinner                     */
USHORT count);                     /*   spinner position index             */

VOID
setmeup(VOID);                     /* set up E-mail/Forums files & pointers*/

GBOOL                              /*   returns TRUE if user warned        */
pfnwrn(VOID);                      /* warn user about profanity            */

VOID
gostt(                             /* prompt and change substate           */
INT stt);                          /*   state to go to                     */

VOID
errhlp(                            /* display error/help message & reprompt*/
INT ehmsg,                         /*   error/help message to display      */
INT repmt);                        /*   reprompt with this message         */

VOID
startlst(                          /* fire up a cycled listing process     */
GBOOL (*nxtlst)(VOID),             /*   function to output next line       */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
lister(VOID);                      /* cycled show-a-list process           */

VOID
wrthlp(VOID);                      /* show help for who-to-write prompt    */

VOID
startwrt(                          /* start message write process          */
VOID (*whndun)(SHORT rc));         /*   function to invoke when finished   */

VOID
startrpl(                          /* start reply process                  */
VOID (*whndun)(SHORT rc));         /*   function to invoke when finished   */

VOID
susequo(VOID);                     /* state: use quoting when replying?    */

VOID
goedit(                            /* start editing a message              */
INT flags);                        /*   flags for editor                   */

GBOOL                              /*   returns TRUE if found spec'd msg   */
efimr(                             /* import message into editor           */
LONG msgid);                       /*   message ID to import               */

GBOOL                              /*   returns TRUE to stay in module     */
edtdone(                           /* finished editing message             */
SHORT edflgs);                     /*   edit result flags                  */

VOID
chkitout(VOID);                    /* check available post-write options   */

VOID
shopwm(VOID);                      /* show post-write menu                 */

VOID
shopwh(VOID);                      /* show post-write help                 */

VOID
spostwrt(VOID);                    /* state: E-mail/Forums post-write menu */

VOID
efupload(VOID);                    /* E-mail/Forums upload utility         */

VOID
clofwait(VOID);                    /* handle cycling during logoff wait    */

VOID
slofwait(VOID);                    /* handle user input during logoff wait */

VOID
snamatt(VOID);                     /* state: enter name of attachment      */

VOID
swhotocc(VOID);                    /* state: to whom to send cc            */

VOID
sender(VOID);                      /* cycled message send process          */

VOID
replyr(VOID);                      /* cycled reply process                 */

VOID
fnotify(                           /* do notification of message forward   */
SHORT rc);                         /*   result of forward operation        */

VOID
cnotify(                           /* do notification of message copy      */
SHORT rc);                         /*   result of copy operation           */

VOID
startmod(                          /* initiate modification of message     */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
cmodr(VOID);                       /* cycled message modify process        */

VOID
xmtext(                            /* transmit text of message             */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
cxmtxt(VOID);                      /* cycled text transmit process         */

VOID
xmtdone(                           /* done sending message text            */
GBOOL aborted);                    /*   TRUE if user aborted output        */

VOID
cfhlp(VOID);                       /* show help for copy/forward prompt    */

VOID
comment(                           /* check for comments when copy/fwd     */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
scmtpmt(VOID);                     /* state: add comments when copy/fwd?   */

VOID
fwdit(                             /* initiate message forward process     */
VOID (*whndun)(SHORT rc));         /*   function to invoke when finished   */

VOID
cfwdr(VOID);                       /* cycled message forward process       */

VOID
copyit(                            /* initiate message copy process        */
VOID (*whndun)(SHORT rc));         /*   function to invoke when finished   */

VOID
ccopyr(VOID);                      /* cycled message copy process          */

VOID
deletem(                           /* initiate cycled delete-message       */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
cdelm(VOID);                       /* cycled delete message process        */

GBOOL
srchipg(VOID);                     /* is there a message search in progress*/

VOID
getprnt(                           /* initiate read parent message process */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
cgetprnt(VOID);                    /* cycled read message parent process   */

VOID
getnear(                           /* initiate read near message process   */
SHORT nearop,                      /*   get near "style" to use            */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
cgetnear(VOID);                    /* cycled read near message process     */

VOID
reget(                             /* initiate re-read of current message  */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
creget(VOID);                      /* cycled re-read of current message    */

VOID
getnext(                           /* initiate read next message process   */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
cygetnext(VOID);                   /* cycled read next message process     */

VOID
getprev(                           /* initiate get previous message process*/
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
cgetprev(VOID);                    /* cycled get previous message process  */

VOID
markoff(                           /* mark message read, generate ret.rcp. */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
cmarkoff(VOID);                    /* cycled mark-message-read process     */

VOID
sdlnow(                            /* state: query to download attachment  */
VOID (*whndun)(SHORT rc));         /*   function to call when done         */

VOID
efdnload(                          /* E-mail/Forums download utility       */
VOID (*whndun)(SHORT rc));         /*   function to call when finished     */

VOID
docyc(                             /* switch from input mode to cycle mode */
GBOOL lock);                       /*   lock out input while cycling?      */

VOID
cycall(VOID);                      /* cncall() equivalent for cycled proc  */

VOID
chkcyc(VOID);                      /* return from cycling to input handler */

VOID
rstcnc(VOID);                      /* restore concat context after cycling */

VOID
sumams(                            /* generate message summary lines       */
INT txtblk,                        /*   level 6 text block to use          */
struct message *dspmsg);           /*   for given message                  */

CHAR *
anpstr(                            /* ALWAYS/NEVER/PROMPT string           */
SHORT flags,                       /*   flag field to check                */
SHORT pmtflg,                      /*   flag set when "PROMPT"             */
SHORT alwflg);                     /*   flag set when "ALWAYS"             */

CHAR *
ynstr(                             /* YES/NO string                        */
SHORT flags,                       /*   flag field to check                */
SHORT ynflg);                      /*   flag set when "YES"                */

CHAR *
rmodstr(                           /* read mode string (FULL/BROWSE)       */
SHORT flags,                       /*   flag field to check                */
SHORT modflg);                     /*   flag set when "FULL"               */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __AAEF_H                             */
