/***************************************************************************
 *                                                                         *
 *   GALINV.C                                                              *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Invisibility toggle monitor                                           *
 *                                                                         *
 *                                            - P. Henning  04/27/1998     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

#define FILREV "$Revision: 3 $"
/***************************************************************************
 * Global Variables                                                        *
 ***************************************************************************/

VOID (*oldInvisHook)(INT usrnum)=NULL;  /*  Old Invisibility hook */
GBOOL* invisArr=NULL;                   /*  Array of invisibilty status */

/***************************************************************************
 * Function Prototypes                                                     *
 ***************************************************************************/

static VOID
InvisDown(VOID);                        /*  Shutdown routine */

static VOID
InvisKick(VOID);                        /*  Invisibility monitor rtkick */

static VOID
InvisHook(                              /*  Invisibility hook function */
INT unum);                              /*    usrnum that changed */

/***************************************************************************
 * Source Code                                                             *
 ***************************************************************************/

MARKSOURCE(galinv);

VOID EXPORT
init__galinv(VOID)
{
     invisArr=(GBOOL*)alczer(nterms*sizeof(GBOOL));
     hook_shutdown(InvisDown);
     oldInvisHook=tlcInvisRou;
     tlcInvisRou=InvisHook;
     rtkick(1,InvisKick);
}

static VOID
InvisDown(VOID)                         /*  Shutdown routine */
{
     if (invisArr != NULL) {
          free(invisArr);
          invisArr=NULL;
     }
}

static VOID
InvisKick(VOID)                         /*  Invisibility monitor rtkick */
{
     INT idx;

     for (idx=0; idx < nterms; idx++) {
          if (usroff(idx)->usrcls == ACTUSR
           && invisArr[idx] != (usroff(idx)->flags&INVISB)) {
               if (tlcInvisRou != NULL) {
                    tlcInvisRou(idx);
               }
          }
     }
     rtkick(1,InvisKick);
}

static VOID
InvisHook(                              /*  Invisibility hook function */
INT unum)                               /*    usrnum that changed */
{
     invisArr[unum]=(GBOOL)(usroff(unum)->flags&INVISB);
     if (oldInvisHook != NULL) {
          oldInvisHook(unum);
     }
}