/***************************************************************************
 *                                                                         *
 *   GALHELLO.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    Freeware source code.    *
 *                                                                         *
 *   Please feel free to use this source code as a baseline to create      *
 *   your own Active HTML Agents or Applications, for use with a           *
 *   Worldgroup server.                                                    *
 *                                                                         *
 *   Sample "Hello World" Active HTML Application.                         *
 *                                                                         *
 *                                                - RNStein  7/10/96       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "galacth.h"

#define FILREV "$Revision: 2 $"

class hloAgent : public acthAgent { // hello-world agent
public:
     hloAgent() : acthAgent("Hello World Example Agent","hello")
     {
          registerAgent(acthVersion);
     }

     acthSynthesis *               //   my session info (NULL=can't)
     newSynthesis(                 // instantiate my Synthesis class
     acthSession *ses);            //   for passing to acthSynthesis's ctor
};

class hloSynthesis : public acthSynthesis { // hello-world response synthesis
public:
     hloSynthesis(acthSession *_ses) : acthSynthesis(_ses) { }

     ACTHCODE                      //   enumerated response (see galacth.h)
     proceed();                    // process request, synthesize response
};

hloAgent thehloAgent;              // the one and only instance of hloAgent

acthSynthesis *                    //   new session-specific structure
hloAgent::newSynthesis(            // instantiate Synthesis class
acthSession *ses)                  //   passed to acthSynthesis's constructor
{
     return(new hloSynthesis(ses));
}

ACTHCODE
hloSynthesis::proceed()            // proceed with HTML synthesis
{
     bout << "Hello world!" << crlf;
     return(ACTHDONE);
}

