////////////////////////////////////////////////////////////////////////////
//
//  msgatt.h
//
//  handle forum messages and attachments arriving separately
//
//                                                  - Paul Roub  10/29/97
//
/////////////////////////////////////////////////////////////////////////////

#if ! defined( MSGATT_H )
#  define MSGATT_H

#define AHUPDIR "ahupdir"

#include  "gme.h"

GBOOL                              //   TRUE if attachment exists or is in progress
attachInProgress(                  // check for attachments with a given ID
ULONG tmpid);                      //   ID to check

GBOOL                              //   TRUE if upload started OK
startFile(                         // begin a file attachment upload
ULONG tmpid,                       //   temp message/file ID
const CHAR *fname);                //   attachment file name

GBOOL                              //   TRUE if file renamed OK
renameFile(                        // rename an attachment file
ULONG tmpid,                       //   temp file/message ID
const CHAR *newname);              //   new name for attachment

GBOOL                              //   TRUE if upload finished OK
finishFile(                        // finish file attachment upload
ULONG tmpid);                      //   temp file/message id

GBOOL                              //   TRUE if data added OK
addFileData(                       // process file attachment upload data
ULONG tmpid,                       //   temp file/message id
const VOID *data,                  //   data to process
size_t bytes);                     //   size of data

GBOOL                              //   TRUE if message data stored OK
storeMessageData(                  // store forum message info
ULONG tmpid,                       //   temp file/message ID
GBOOL asReply,                     //   is this a reply?
const CHAR *workarea,              //   message work area
const CHAR *text,                  //   message text
const CHAR *cclist,                //   CC list
const message *mhdr                //   message header
);

GBOOL                              //   TRUE if message data here and any attachment is complete
readyToSend(                       // check whether we have all data for a message
ULONG tmpid);                      //   temp message/file ID

INT                                //   GME codes
sendMessage(                       // send a message (and any attachment)
ULONG tmpid);                      //   temp message/file ID

FILE *                             //   the attachment's handle or NULL
getFile(                           // get an in-progress attachments FILE pointer
ULONG tmpid);                      //   temp message/file ID

VOID
messageAborted(                    // cleanup dir/filename if message aborted     
ULONG tmpid);                      // temp message/file ID     

#endif
