/***************************************************************************
 *                                                                         *
 *   LOGSYN.CPP                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Library Log Synthesis Class.                                          *
 *                                                 - N.C. Osterc  11/17/98 *
 *                                                                         *
 ***************************************************************************/

#include "libinc.h"
#include "logsyn.h"

#define FILREV   "$Revision: 2 $"
#define LOGDIR  "library/log/"

enum {LOGPARAM, LOGRESP};

// Dynafile defs

dnfStep dnfLogErrSteps[]={
     dnfStep(DNFMAPEND)
};

enum {LOGLISTITEM};

dnfStep dnfDefLogSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,LOGLISTITEM,"LISTITEM"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};

dnfMap dnfLogErrMap(PPFIX LOGDIR "error.htm","Error",dnfLogErrSteps);
dnfMap dnfDefLogMap(PPFIX LOGDIR "index.htm","Default",dnfDefLogSteps);

// class method defs

MARKSOURCE(logsyn);

logSynthesis::logSynthesis(       // default constructor
               acthSession *_ses):
               libManSynthesis(_ses),
               m_tableDone(false),
               m_totLogged(0),
               m_lastLogFile(NULL),
               m_pathParam("")
{
     m_ahState=LOGPARAM;
}

logSynthesis::~logSynthesis()     // destructor
{
}

ACTHCODE
logSynthesis::proceed()           // proceed entry point
{
     ACTHCODE retval;

     if ((retval=isUserOK()) != ACTHMORE) {
          return(retval);
     }

     if (m_cyc.start()) {
          do {
               switch(m_ahState) {
               case LOGPARAM:
                    GETPARAMVAL("libname");
                    if (GOTPVAL) {
                         m_libraryPtr=new library(m_pValBuf);
                         if (!hasSysopPowers() && !hasLibOpAccess()) {
                              return(ACTHFORBID);
                         }
                         if (!m_libraryPtr->exists()) {
                              setError(NOTFOUND);
                              setMap(&dnfLogErrMap);
                              m_ahState=LOGRESP;
                              break;
                         }
                    }
                    else {
                         setError(NOTFOUND);
                         setMap(&dnfLogErrMap);
                         m_ahState=LOGRESP;
                         break;
                    }
                    if (m_libraryPtr->lib.flags&FLGDOS) {
                         setError(NOOSLOG);
                         setMap(&dnfLogErrMap);
                         m_ahState=LOGRESP;
                         break;
                    }
                    GETPARAMVAL("path");
                    if (GOTPVAL) {
                         if (isfile(m_pValBuf)) {
                              m_pathParam=m_pValBuf;
                         }
                         else {
                              setError(PATHINV);
                              setMap(&dnfLogErrMap);
                              m_ahState=LOGRESP;
                         }
                    }
                    setMap(&dnfDefLogMap);
                    m_ahState=LOGRESP;
                    break;
               case LOGRESP:
                    if (m_libraryPtr != NULL) {
                         m_pLibVars->setLibraryVars(m_libraryPtr);
                    }
                    retval=dynafile();
                    break;
               }
          } while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}

ACTHCODE
logSynthesis::dynafile()          // overriden dynafile
{
     ACTHCODE retval=ACTHMORE;

     ASSERT(m_dnfPtr != NULL);

     if (m_tableDone && m_totLogged == 0) {
          setmbk(ahLibManMsg);
          t_NoneLogged=getmsg(NONE2LOG);
          rstmbk();
     }
     if (m_lastLogFile != NULL) {
          t_LoggedFileEnc=t_LoggedFile=m_lastLogFile;
     }

     switch (m_dnfPtr->process()) {
     case DNFROWBEGIN:
          switch (m_libraryPtr->log((CHAR *)m_usrPtr->userid(),&m_lastLogFile,
           true,(CHAR *)m_pathParam.c_str())) {
          case FLMAN_WORKING:
               break;
          case FLMAN_SUCCESS:
               m_dnfPtr->tableDone();
               m_tableDone=true;
               break;
          default:
               ASSERTM(false,"Unhandled case in file log-in switch");
          }
          if (!m_tableDone && m_lastLogFile == NULL) {
               bout << "<!---->";  // prevent time-outs
               m_dnfPtr->sayAgain();
          }
          else if (m_lastLogFile != NULL) {
               t_LoggedFileEnc=t_LoggedFile=m_lastLogFile;  
               ++m_totLogged;
          }
          break;
     case DNFEND:
          retval=ACTHDONE;
          break;
     }
     return(retval);
}

