/***************************************************************************
 *                                                                         *
 *   LIBVAR.CPP                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Library Variables Class.                                              *
 *                                               - N.C. Osterc  11/06/98   *
 *                                                                         *
 ***************************************************************************/

#include "libinc.h"
#include "galfil.h"

#define FILREV "$Revision: 3 $"

#define TODAY 0

basicTvb t_AltPath("FLEDIT_ALTPATH");
basicTvb t_AuditDLs("FLEDIT_AUDITDOWN_CHECKED");
basicTvb t_AuditULs("FLEDIT_AUDITUP_CHECKED");
basicTvb t_CreateDate("FLEDIT_CRDATE");
basicTvb t_CreateTime("FLEDIT_CRTIME");
basicTvb t_DLKey("FLEDIT_DL_KEY");
basicTvb t_DLCharge("FLEDIT_DL_CHARGEFILE");
basicTvb t_DLChargeK("FLEDIT_DL_CHARGEK");
basicTvb t_OSOnly("FLEDIT_OS_ONLY");
basicTvb t_Hidden("FLEDIT_HIDDEN_CHECKED");
basicTvb t_IsCreate("FLEDIT_ISCREATE");
basicTvb t_LibOp("FLEDIT_LIBOP");
basicTvb t_LibOpKey("FLEDIT_LIBOP_KEY");
urlEncodedTvb t_LibOpEnc("FLEDIT_LIBOP_U");
basicTvb t_LongDesc("FLEDIT_LONGDESC");
basicTvb t_MaxBytes("FLEDIT_MAXBYTES");
basicTvb t_MaxFiles("FLEDIT_MAXFILES");
basicTvb t_MaxUpload("FLEDIT_MAXUPLOAD");
basicTvb t_Name("FLEDIT_NAME");
basicTvb t_NameEnc("FLEDIT_NAME_U");
basicTvb t_NoAuditDLs("FLEDIT_NO_AUDITDOWN_CHECKED");
basicTvb t_NoAuditULs("FLEDIT_NO_AUDITUP_CHECKED");
basicTvb t_NoTimeChargeDL("FLEDIT_NO_TIMECHARGE_DL_CHECKED");
basicTvb t_NoTimeChargeUL("FLEDIT_NO_TIMECHARGE_UL_CHECKED");
basicTvb t_NotHidden("FLEDIT_NOT_HIDDEN_CHECKED");
basicTvb t_NotOnCD("FLEDIT_NOT_ONCD_CHECKED");
basicTvb t_NotReadOnly("FLEDIT_NOT_READONLY_CHECKED");
basicTvb t_OnCD("FLEDIT_ONCD_CHECKED");
basicTvb t_OverwriteKey("FLEDIT_OVERWRITE_KEY");
basicTvb t_PreApproveKey("FLEDIT_PREAPV_KEY");
basicTvb t_ReadOnly("FLEDIT_READONLY_CHECKED");
basicTvb t_Royalty("FLEDIT_ROYALTY");
basicTvb t_ShortDesc("FLEDIT_SHORTDESC");
basicTvb t_TimeChargeDL("FLEDIT_TIMECHARGE_DL_CHECKED");
basicTvb t_TimeChargeUL("FLEDIT_TIMECHARGE_UL_CHECKED");
basicTvb t_UploadKey("FLEDIT_UL_KEY");
basicTvb t_VisibleKey("FLEDIT_VIS_KEY");
basicTvb t_ErrMessage("FLMAN_ERR_MESSAGE");
basicTvb t_FileDesc("FEDIT_DESC");
basicTvb t_FileName("FEDIT_FILENAME");
urlEncodedTvb t_FileNameEnc("FEDIT_FILENAME_U");
basicTvb t_FileSizeBytes("FEDIT_SIZE_BYTES");
basicTvb t_FileSizeK("FEDIT_SIZE_K");
basicTvb t_DateAdded("FEDIT_DATE_ADDED");
basicTvb t_TimeAdded("FEDIT_TIME_ADDED");
basicTvb t_TimeStamp("FEDIT_TIMESTAMP");
basicTvb t_DateStamp("FEDIT_DATESTAMP");
basicTvb t_Uploader("FEDIT_UPLOADER");
urlEncodedTvb t_UploaderEnc("FEDIT_UPLOADER_U");
basicTvb t_Downloads("FEDIT_DOWNLOADS");

basicTvb t_NumFilesInLib("FLEDIT_NUMFILES");
basicTvb t_NumFilesInLibPlusJoined("FLEDIT_NUMFILES_JOINED");
basicTvb t_AddedToday("FLEDIT_ADDED_TODAY");
basicTvb t_WeekAdded("FLEDIT_ADDED_THIS_WEEK");
basicTvb t_JoinedLib("FLEDIT_JOINED_LIB");
urlEncodedTvb t_JoinedLibEnc("FLEDIT_JOINED_LIB_U");
basicTvb t_NoneJoined("FLEDIT_NONE_JOINED");
basicTvb t_LoggedFile("FLEDIT_LOGFILE");
urlEncodedTvb t_LoggedFileEnc("FLEDIT_LOGFILE_U");
basicTvb t_NoneLogged("FLEDIT_NONE_LOGGED");

libManVar::libManVar()
{
}

libManVar::~libManVar()
{
}

VOID
libManVar::setLibraryVars(
library* libptr)
{
     t_AltPath=libptr->lib.path;
     if (libptr->lib.flags&FLGADL) {
          t_AuditDLs=CHK;
          t_NoAuditDLs="";
     }
     else {
          t_NoAuditDLs=CHK;
     }
     if (libptr->lib.flags&FLGAUL) {
          t_AuditULs=CHK;
          t_NoAuditULs="";
     }
     else {
          t_NoAuditULs=CHK;
     }
     t_CreateDate=ncdatel(libptr->lib.day);
     t_CreateTime=nctime(libptr->lib.time);
     t_DLKey=libptr->lib.dlkey;
     t_DLCharge=libptr->lib.dlchge;
     t_DLChargeK=libptr->lib.kdlchge;
     if (libptr->lib.flags&FLGDOS) {
          t_OSOnly=1;
     }
     if (libptr->lib.flags&FLGHID) {
          t_Hidden=CHK;
          t_NotHidden="";
     }
     else {
          t_NotHidden=CHK;
     }
     t_LibOp=libptr->lib.primary;
     t_LibOpEnc=t_LibOpKey=libptr->lib.libop;
     t_LongDesc=libptr->getLongDesc();
     t_MaxBytes=libptr->lib.maxbyt;
     t_MaxFiles=libptr->lib.maxfil;
     t_MaxUpload=libptr->lib.maxbup;
     t_NameEnc=t_Name=libptr->lib.libname;
     if (libptr->lib.flags&FLGFDL) {
          t_TimeChargeDL=CHK;
          t_NoTimeChargeDL="";
     }
     else {
          t_NoTimeChargeDL=CHK;
     }
     if (libptr->lib.flags&FLGFUL) {
          t_TimeChargeUL=CHK;
          t_NoTimeChargeUL="";
     }
     else {
          t_NoTimeChargeUL=CHK;
     }
     if (libptr->lib.flags&FLGCBD) {
          t_OnCD=CHK;
          t_NotOnCD="";
     }
     else {
          t_NotOnCD=CHK;
     }
     if (libptr->lib.flags&FLGRDO) {
          t_ReadOnly=CHK;
          t_NotReadOnly="";
     }
     else {
          t_NotReadOnly=CHK;
     }
     t_OverwriteKey=libptr->lib.overw;
     t_PreApproveKey=libptr->lib.autoap;
     t_Royalty=libptr->lib.royal;
     t_ShortDesc=libptr->lib.libdesc;
     t_UploadKey=libptr->lib.ulkey;
     t_VisibleKey=libptr->lib.keyreq;
     t_NumFilesInLib=libptr->lib.numfiles;
     t_NumFilesInLibPlusJoined=libptr->lib.totfiles;
     t_AddedToday=libptr->getFilesAdded(TODAY);
     t_WeekAdded=libptr->getFilesAddedWeekly();

     if (!libptr->exists()) {
          setCreateValues();
     }
}

VOID
libManVar::setFileVars(
file *filptr)
{
     t_FileDesc=filptr->desc;
     t_FileNameEnc=t_FileName=filptr->filname;
     t_FileSizeBytes=filptr->siz;
     t_FileSizeK=filptr->siz/1024;
     if (::sameas(filptr->udate,NOTAPPED)) {
          t_DateAdded="Unapproved";
     }
     else {
          t_DateAdded=srt2datl(filptr->udate);
     }
     t_TimeAdded=::nctime(filptr->utime);
     t_FileDesc=filptr->desc;
     t_DateStamp=::srt2datl(filptr->fdate);
     t_TimeStamp=::nctime(filptr->tim);
     t_UploaderEnc=t_Uploader=filptr->ulby;
     t_Downloads=::atoi(filptr->numdls);
}

VOID
libManVar::setCreateValues()
{
     setmbk(flmsg);
     t_DLKey=getmsg(FLDKEY);
     t_LibOpKey=getmsg(DEFLOP);
     t_MaxBytes=10000000;
     t_MaxFiles=10000;
     t_MaxUpload=200000;
     t_Royalty=0;
     t_DLCharge=0;
     t_DLChargeK=0;
     t_LibOp=getmsg(DEFPLOP);
     t_OverwriteKey=getmsg(DEFOVR);
     t_PreApproveKey=getmsg(DEFAPP);
     t_UploadKey=getmsg(DEFUL);
     t_VisibleKey=getmsg(FLVKEY);
     t_IsCreate=1;
     rstmbk();
}

VOID
libManVar::setVarsDefault()
{
     t_AltPath="";
     t_AuditDLs="";
     t_AuditULs="";
     t_CreateDate="";
     t_CreateTime="";
     t_OSOnly=0;
     t_Hidden="";
     t_IsCreate=0;
     t_LibOpEnc="";
     t_LongDesc="";
     t_Name="";
     t_NameEnc="";
     t_OnCD="";
     t_ReadOnly="";
     t_ShortDesc="";
     t_TimeChargeDL="";
     t_TimeChargeUL="";
     t_ErrMessage="";
     t_FileName="";
     t_FileNameEnc="";
     t_FileSizeBytes="";
     t_FileSizeK="";
     t_DateAdded="";
     t_TimeAdded="";
     t_DateStamp="";
     t_FileDesc="";
     t_TimeStamp="";
     t_Uploader="";
     t_UploaderEnc="";
     t_Downloads="";
     t_NoAuditDLs=CHK;
     t_NoAuditULs=CHK;
     t_NoTimeChargeDL=CHK;
     t_NoTimeChargeUL=CHK;
     t_NotHidden=CHK;
     t_NotOnCD=CHK;
     t_NotReadOnly=CHK;
     t_NumFilesInLib=0;
     t_NumFilesInLibPlusJoined=0;
     t_AddedToday="";
     t_WeekAdded="";
     t_JoinedLib="";
     t_JoinedLibEnc="";
     t_NoneJoined="";
     t_LoggedFile="";
     t_LoggedFileEnc="";
     t_NoneLogged="";
     setCreateValues();
}
