/***************************************************************************
 *                                                                         *
 *   LIBSYN.H                                                              *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Library-Manager Class.                                                *
 *                                                 - N.C. Osterc  11/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __LIBSYN_H
#define __LIBSYN_H

#define URLSIZ 1024
#define PVALBUFSIZ 16384
#define PPFIX "galacth/galflmah/"
#define GETPARAMVAL(x) ses->param(x,m_pValBuf,PVALBUFSIZ)
#define GOTPVAL    (m_pValBuf[0] != '\0')
#define ISPARAM(x) ses->paramIndex(x,m_index)

class libManSynthesis: public acthSynthesis {
public:

     libManSynthesis(                // default constructor
     acthSession *_ses);           // session object

     virtual
     ~libManSynthesis();             // destructor

     virtual
     ACTHCODE
     proceed();                    // proceed entry point

protected:

     VOID
     setError(                     // set up error tvbs
     INT messageOpt,               // the message option
     const CHAR *arg1=NULL,        // first argument
     const CHAR *arg2=NULL);       // second argument

     bool
     hasLibOpAccess();             // does user have lib-op access?

     bool
     hasSysopPowers();             // does user have sysop powers?

     VOID
     setErrorVbs();                // set error tvbs up

     VOID
     setMap(                       // set up m_dnfPtr
     dnfMap *map);

     virtual ACTHCODE
     dynafile();                   // dynafile

     bool
     hasAgentAccess();             // does user have access?

     ACTHCODE
     initRequest();                // initialize request stuff

     ACTHCODE
     isUserOK();                   // check user specific stuff

     VOID
     handleErrorCode(              // handle setting error from error code
     FLMANCODE flc);

     bool
     getLibName(                   // handle library name parameter
     bool requireName);            // is this param required?

     VOID
     setTemplate();                // set up the DNF_TEMPLATE tvb

     acthUserID *m_usrPtr;         // user object
     dnfHandler *m_dnfPtr;         // dnfhandler object
     libManVar *m_pLibVars;        // point to poll variables object
     libraryAPI *m_pLibAPI;        // pointer to API class
     CHAR m_pValBuf[PVALBUFSIZ];   // buffer - stores parameter values
     cycleTimer m_cyc;             // cyctle timer instance
     INT m_index;                  // index - used in ISPARAM
     SHORT m_ahState;              // state-tracking variable
     string m_errMessage;          // save error message
     bool m_errorStatus;           // did error occur?
     library *m_libraryPtr;        // pointer to library object
     file *m_filePtr;              // pointer to file object
};

#endif                             // __LIBSYN_H
