/***************************************************************************
 *                                                                         *
 *   LIBSYN.CPP                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Library Synthesis Class.                                              *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "libinc.h"
#include "libsyn.h"

#define FILREV "$Revision: 3 $"

// Dynafile defs

dnfStep dnfFrameSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap defMap(PPFIX "index.htm","Default",dnfFrameSteps);

// class method defs

MARKSOURCE(libsyn);

libManSynthesis::libManSynthesis(       // default constructor
               acthSession *_ses):
               acthSynthesis(_ses),
               m_usrPtr(0),
               m_dnfPtr(0),
               m_pLibVars(0),
               m_pLibAPI(0),
               m_libraryPtr(0),
               m_filePtr(0),
               m_errorStatus(false)
{
     m_cyc.setSlice(timslc);
     m_pValBuf[0]='\0';
     m_pLibVars=new libManVar();
     m_pLibAPI=new libraryAPI();
}

libManSynthesis::~libManSynthesis()     // destructor
{
     if (0 != m_dnfPtr) {
          delete m_dnfPtr;
     }
     if (0 != m_pLibVars) {
          delete m_pLibVars;
     }
     if (0 != m_pLibAPI) {
          delete m_pLibAPI;
     }
     if (0 != m_libraryPtr) {
          delete m_libraryPtr;
     }
     if (0 != m_filePtr) {
          delete m_filePtr;
     }
}

ACTHCODE
libManSynthesis::initRequest()
{
     if ((::strchr(ses->urlsfx(),'.')) == NULL) {
          if (ses->forceDir()) {
               return(ACTHDONE);
          }
     }
     m_pLibVars->setVarsDefault();
     if (m_errorStatus) {
          setErrorVbs();
     }
     setTemplate();
     return(ACTHMORE);
}

VOID
libManSynthesis::setTemplate()
{
     if (0 != m_dnfPtr) {
          dnfSetTemplateTvb(m_dnfPtr);
     }
     else {
          dnfClearTemplateTvb();
     }
}

ACTHCODE
libManSynthesis::isUserOK()          // check some basic stuff about user and session
{
     m_usrPtr=ses->getUser();
     if (0 == m_usrPtr) {
          return(ACTHNOANON);
     }
     if (!hasAgentAccess()) {
          return(ACTHFORBID);
     }
     return(initRequest());
}

ACTHCODE
libManSynthesis::proceed()           // proceed entry point
{
     if ((ses->urlargc() > 0) && (0 == ::strchr(ses->urlargv(0),'.'))) {
          return(ACTHNOTFND);
     }

     ACTHCODE retval=isUserOK();

     if (ACTHMORE == retval) {
          if (0 == m_dnfPtr) {
               m_dnfPtr=dnfCreateHandlerURL(ses,&defMap,PPFIX);
          }
          if (m_cyc.start()) {
               do {
                    retval=dynafile();
               } while ((ACTHDONE != retval) && m_cyc.haveTime());
          }
     }
     return(retval);
}

ACTHCODE
libManSynthesis::dynafile()          // dynafile
{
     ASSERT(0 != m_dnfPtr);

     ACTHCODE retval=ACTHMORE;

     switch(m_dnfPtr->process()) {
     case DNFEND:
          retval=ACTHDONE;
          break;
     }
     return(retval);
}

VOID
libManSynthesis::setMap(
dnfMap *map)
{
     ASSERT(0 != map);

     m_dnfPtr=dnfCreateHandlerURL(ses,map,PPFIX);
     setTemplate();
}

bool
libManSynthesis::hasAgentAccess()    // does user have access?
{
     ASSERT(0 != m_usrPtr);

     return(m_usrPtr->hasKey(hlmankey));
}

bool
libManSynthesis::hasLibOpAccess()    // does user have lib-op access?
{
     ASSERT(0 != m_usrPtr);
     ASSERT(0 != m_libraryPtr);

     return(m_usrPtr->hasKey(m_libraryPtr->lib.libop)
      || sameas(m_usrPtr->userid(),m_libraryPtr->lib.primary));
}

bool
libManSynthesis::hasSysopPowers()  // does user have sysop access?
{
     ASSERT(0 != m_usrPtr);

     return (m_usrPtr->hasKey(flsysop));
}

VOID
libManSynthesis::handleErrorCode(  // handle generic error codes
FLMANCODE flc)
{
     switch (flc) {
     case FLMAN_ERROR:
          setError(GENERR);
          break;
     case FLMAN_OUTOFLIBS:
          setError(OUTOFLIB);
          break;
     case FLMAN_NOTFOUND:
          setError(NOTFOUND);
          break;
     case FLMAN_FLAG4COPY:
          setError(FLAG4CPY);
          break;
     default:
          ASSERTM(FALSE,"Unhandled File Library Manager Error Code!");
     }
}

VOID
libManSynthesis::setError(           // set error text variables
INT messageOpt,                    // given message opt
const CHAR* arg1,                  // argument for prfmsg
const CHAR* arg2)                  // argument for prfmsg
{
     ::setmbk(ahLibManMsg);
     ::clrprf();
     if ((0 != arg1) && (0 != arg2)) {
          ::prfmsg(messageOpt,arg1,arg2);
     }
     else if (0 != arg1) {
          ::prfmsg(messageOpt,arg1);
     }
     else {
          ::prfmsg(messageOpt);
     }
     m_errorStatus=true;
     m_errMessage=::stpans(prfbuf);
     setErrorVbs();
     ::rstmbk();
}

VOID
libManSynthesis::setErrorVbs()       // set up error text variables
{
     t_ErrMessage=m_errMessage;
}

bool
libManSynthesis::getLibName(
bool requireName)
{
     GETPARAMVAL("libname");
     bool rc=!(requireName);

     if (GOTPVAL) {
          if (strlen(m_pValBuf) >= FLDESCSZ) {
               setError(TOOLONG,m_pValBuf,"libname");
          }
          else if (!m_pLibAPI->exists(m_pValBuf)
           && !m_pLibAPI->isValidLibName(m_pValBuf,m_usrPtr->userid())) {
               setError(INVVALUE,m_pValBuf,"libname");
          }
          else {
               m_libraryPtr=new library(::strupr(m_pValBuf));
               rc=true;
          }
     }
     if (requireName) {
          if (!GOTPVAL) {
               setError(NOVALUE,"libname");
          }
          else if (!m_pLibAPI->exists(m_pValBuf)) {
               setError(LIBNFND,m_pValBuf);
          }
     }
     return(rc);
}
