/***************************************************************************
 *                                                                         *
 *   LIBRARY.H                                                             *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Library Wrapper Class                                            *
 *                                                                         *
 *                                                 - N.C. Osterc  11/04/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __LIBRARY_H
#define __LIBRARY_H

enum FLMANCODE {FLMAN_NOTFOUND, FLMAN_WORKING, FLMAN_ERROR,
                FLMAN_SUCCESS, FLMAN_OUTOFLIBS, FLMAN_FLAG4COPY,
                FLMAN_UPDATEREC, FLMAN_OPDONE, FLMAN_KEYWORDS};

class library : public libdisk {
public:

     library();                    // constructor

     library(                      // constructor
     const CHAR *name);            // passed name

     ~library();                   // destructor

     bool
     load();                       // load library data

     bool
     create();                     // create a library

     bool
     update();                     // update existing library

     FLMANCODE                     // returns code
     removeFromDisk();             // remove this library

     bool
     exists();                     // this library already exists?

     const CHAR *
     getLongDesc();                // get long description

     bool
     setLongDesc(                  // set the long description
     const CHAR *desc);            // given desc

     SHORT
     getFilesAdded(                // get amount of files added for part. day
     SHORT day);

     SHORT
     getFilesAddedWeekly();        // get amount of files added this week

     bool
     getWriteLock(                 // get a write lock
     INT *lockUser);

     VOID
     releaseWriteLock();           // release the write lock

     bool
     clearLibMem();                // clear library from memory

     struct fllib *
     getLibMemPtr();               // get a pointer to library memory

     FLMANCODE
     log(                          // log all unlogged files
     CHAR *userid,
     CHAR **lfname=NULL,
     bool approve=true,
     CHAR *pathToLog=NULL);

     VOID
     logProcess(                   // do log-in processing
     CHAR *userid,
     CHAR **loggedName,
     bool approve);

     const CHAR *
     getCurPath();                 // get current path
     
private:

     INT m_delState;               // keep track of delete lib state
     string m_strDesc;             // long description
     CHAR m_fileNameBuf[FLFILENM]; // buffer for file
     struct ffblk m_fblk;          // instance of file block structure
     CHAR m_loggedFile[FLFILENM];  // store file found
     SHORT m_logCode;              // code for logging files
     string m_srcFile, m_destFile; // source and dest strings
     string m_spath;               // current path of lib
     CHAR m_storePath[GCMAXPTH];   // store path
     FILE *m_srcf;                 // source file pointer
     FILE *m_destf;                // dest file pointer
};

#endif                             // __LIBRARY_H
