/***************************************************************************
 *                                                                         *
 *   LIBAPI.H                                                              *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Library API Class.                                                    *
 *                                                 - N.C. Osterc  11/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __LIBAPI_H
#define __LIBAPI_H

class libraryAPI {
public:

     libraryAPI();                 // default constructor

     ~libraryAPI();                // destructor

     bool
     isValidPath(                  // is passed path valid?
     CHAR *path);

     bool
     outOfLibs();                  // out of libraries to create?

     bool
     isValidLibName(               // is this library name valid?
     CHAR *libname,                // name in question
     const CHAR *userid);          // userid

     bool
     exists(                       // does this lib exist?
     CHAR *libname);

     const CHAR *
     getNextJoined(                // get next joined lib - NULL starts
     struct fllib *jlib,           // current lib
     const CHAR *lastLib);         // last lib gotten - or NULL

     const CHAR *
     getNextUnJoined(              // get next unjoined lib - NULL starts
     struct fllib *jlib,           // current lib
     const CHAR *lastLib);         // last lib gotten - or NULL

private:

     struct fllib *m_libptr;       // lib ptr
};

#endif                             __LIBAPI_H
