/***************************************************************************
 *                                                                         *
 *   LIBAPI.CPP                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Library API Class.                                                    *
 *                                               - N.C. Osterc  11/06/98   *
 *                                                                         *
 ***************************************************************************/

#include "libinc.h"
#include "libapi.h"

#define FILREV "$Revision: 3 $"

MARKSOURCE(libapi);

libraryAPI::libraryAPI()
{
}

libraryAPI::~libraryAPI()
{
}

bool
libraryAPI::outOfLibs()
{
     return(numoflib >= (numlib+numladd));
}

bool
libraryAPI::isValidPath(
CHAR *path)
{
     ASSERT(0 != path);

     path=::fixpath(path);
     INT flag=MKDIR(path);

     if ((0 != flag) && !isdir(path)) {
          if (!samend(path,":\\.") && !samend(path,":/.")) {
               if (::strlen(path) != 3 || !::samend(path,":.")) {
                    return(false);
               }
          }
     }
     if (0 == flag) {
          ::rmdir(path);
     }
     return(true);
}

bool
libraryAPI::isValidLibName(
CHAR *libname,
const CHAR *userid)
{
     ASSERT(0 != libname);
     ASSERT(0 != userid);

     CHAR *cptr=libname;
     bool rc=true;

     INT len=::strlen(cptr);

     if ((len < 1) || (len > 8)) {
          return(false);
     }
     while (*cptr != '\0') {
          if (!isfiln(*cptr,".")) {
               rc=false;
               break;
          }
          cptr++;
     }
     if (::rsvnam(libname)
      || (0 != ::profan(libname)) && !uhskey(userid,flsysop)) {
          rc=false;
     }
     return(rc);
}

bool
libraryAPI::exists(
CHAR *libname)
{
     ASSERT(0 != libname);

     return(0 != libfind(libname));
}

const CHAR *
libraryAPI::getNextUnJoined(
struct fllib *jlib,
const CHAR *lastLib)
{
     ASSERT(0 != jlib);

     bool foundLast=(0 == lastLib);

     for (SHORT loop=0; loop < numoflib; loop++) {
          m_libptr=liboff(loop);
          if ((0 != lastLib) && ::sameas(lastLib,m_libptr->libname)) {
               foundLast=true;
               continue;
          }
          else if (::sameas(m_libptr->libname,jlib->libname)) {
               continue;
          }
          else if (foundLast && !chjoined(m_libptr,jlib->libname)) {
               return(m_libptr->libname);
          }
     }
     return(0);
}

const CHAR *
libraryAPI::getNextJoined(
struct fllib *jlib,
const CHAR *lastLib)
{
     ASSERT(0 != jlib);

     bool foundLast=(0 == lastLib);

     for (SHORT loop=0; loop < numoflib; loop++) {
          m_libptr=liboff(loop);
          if (lastLib != NULL && ::sameas(lastLib,m_libptr->libname)) {
               foundLast=true;
               continue;
          }
          else if (::sameas(m_libptr->libname,jlib->libname)) {
               continue;
          }
          else if (foundLast && chjoined(m_libptr,jlib->libname)) {
               return(m_libptr->libname);
          }
     }
     return(0);
}
