/***************************************************************************
 *                                                                         *
 *   LEDITSYN.H                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Edit Library Class.                                                   *
 *                                                 - N.C. Osterc  11/09/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __LEDITSYN_H
#define __LEDITSYN_H

class libEditSynthesis: public libManSynthesis {
public:

     libEditSynthesis(             // default constructor
     acthSession *_ses);           // session object

     ~libEditSynthesis();          // destructor

     ACTHCODE
     proceed();                    // proceed entry point

private:

     bool
     getShortDesc();               // handle "shortdesc" parameter

     bool
     getLongDesc();                // handle "longdesc" parameter

     bool
     getAltPath();                 // handle "altpath" parameter

     bool
     getCheckParams();             // handle check parameters

     bool
     getRoyalty();                 // handle "royalty" parameter

     bool
     getMaxFiles();                // handle "maxfiles" parameter

     bool
     getMaxBytes();                // handle "maxbytes" parameter

     bool
     getMaxUpload();               // handle "maxupload" parameter

     bool
     getLibOp();                   // handle "libop" parameter

     bool
     getKeys();                    // handle key parameters

     bool
     getDownChargeFile();          // handle "downchargefile" parameter

     bool
     getDownChargeK();             // handle "downchargek" parameter

     bool
     saveLibrary();                // save library info

     bool
     checkKey(                     // validate key
     const CHAR *paramName,        // this parameter
     CHAR *buf);                   // buffer to put valid key

};

#endif                             // __LEDITSYN_H
