/***************************************************************************
 *                                                                         *
 *   LEDITSYN.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Edit Library Class.                                                   *
 *                                                 - N.C. Osterc  11/09/98 *
 *                                                                         *
 ***************************************************************************/

#include "libinc.h"
#include "leditsyn.h"

#define FILREV     "$Revision: 5 $"
#define LEDITDIR   "library/edit/"

#define MAXMISCSIZ 999999999

// Dynafile defs

dnfStep dnfLeditDefSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfLeditConfSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfLeditErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfLeditOSDefSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap libEditDefMap(PPFIX LEDITDIR "index.htm","Default",dnfLeditDefSteps);
dnfMap libEditDefOSMap(PPFIX LEDITDIR "indexos.htm","Default OS",dnfLeditOSDefSteps);
dnfMap libEditErrMap(PPFIX LEDITDIR "error.htm","Error",dnfLeditErrSteps);
dnfMap libEditConfMap(PPFIX LEDITDIR "confirm.htm","Confirm",dnfLeditConfSteps);

struct param2flag {                // param & flag struct
     CHAR *pname;
     LONG flag;
};

struct param2flag pfArray[] = {    // array of structs
     {"hidden"        ,FLGHID},
     {"oncd"          ,FLGCBD},
     {"readonly"      ,FLGRDO},
     {"auditup"       ,FLGAUL},
     {"auditdown"     ,FLGADL},
     {"notimechargeul",FLGFUL},
     {"notimechargedl",FLGFDL},
     {"osonly"        ,FLGDOS},
     {NULL            ,0}
};

// class method defs

enum {EDITRESP, EDITPARAMS, EDITACCESS};

MARKSOURCE(leditsyn);

libEditSynthesis::libEditSynthesis(       // default constructor
     acthSession *_ses):
     libManSynthesis(_ses)
{
     m_ahState=EDITACCESS;
}

libEditSynthesis::~libEditSynthesis()     // destructor
{
}

ACTHCODE
libEditSynthesis::proceed()           // proceed entry point
{
     ACTHCODE retval=isUserOK();

     if ((ACTHMORE == retval) && m_cyc.start()) {
          do {
               switch (m_ahState) {
               case EDITACCESS:
                    if (!getLibName(false)) {
                         setMap(&libEditErrMap);
                         m_ahState=EDITRESP;
                         break;
                    }
                    if (hasSysopPowers() || ((0 != m_libraryPtr) &&
                     hasLibOpAccess())) {
                         m_ahState=EDITPARAMS;
                    }
                    else {
                         return(ACTHFORBID);
                    }
                    break;
               case EDITPARAMS:
                    m_ahState=EDITRESP;
                    if (ISPARAM("save")) {
                         if (getLibName(true) && getShortDesc() && getLongDesc()
                          && getAltPath() && getCheckParams() && getRoyalty()
                          && getMaxFiles() && getMaxBytes() && getMaxUpload()
                          && getLibOp() && getDownChargeFile() && getKeys()
                          && getDownChargeK()) {
                              if (saveLibrary()) {
                                   setMap(&libEditConfMap);
                                   break;
                              }
                         }
                         setMap(&libEditErrMap);
                    }
                    else {
                         if (ISPARAM("osonly") || ((0 != m_libraryPtr)
                          && (m_libraryPtr->lib.flags&FLGDOS))) {
                              setMap(&libEditDefOSMap);
                         }
                         else {
                              setMap(&libEditDefMap);
                         }
                    }
                    break;
               case EDITRESP:
                    if (0 != m_libraryPtr) {
                         m_pLibVars->setLibraryVars(m_libraryPtr);
                    }
                    retval=dynafile();
                    break;
               }
          } while ((ACTHDONE != retval) && m_cyc.haveTime());
     }
     return(retval);
}

bool
libEditSynthesis::saveLibrary()
{
     ASSERT(0 != m_libraryPtr);
     bool rc=false;

     if (!m_libraryPtr->exists()) {
          if (m_pLibAPI->outOfLibs()) {
               setError(OUTOFLIB);
          }
          else if ((rc=m_libraryPtr->create()) == false) {
               setError(FAILCRT);
          }
     }
     else if ((rc=m_libraryPtr->update()) == false) {
          setError(FAILUPD);
     }
     return(rc);
}

bool
libEditSynthesis::getShortDesc()
{
     bool rc=true;

     if (GETPARAMVAL("shortdesc")) {
          if (::strlen(m_pValBuf) >= FLDESCSZ) {
               setError(TOOLONG,m_pValBuf,"shortdesc");
               rc=false;
          }
          else {
               ::stlcpy(m_libraryPtr->lib.libdesc,m_pValBuf,FLDESCSZ);
          }
     }
     return(rc);
}

bool
libEditSynthesis::getLongDesc()
{
     bool rc=true;

     if (GETPARAMVAL("longdesc")) {
          if (::strlen(m_pValBuf) > NLDLIN*(FLLDESCS-1)) {
               setError(TOOLONG,m_pValBuf,"longdesc");
               rc=false;
          }
          else {
               if (!m_libraryPtr->setLongDesc(m_pValBuf)) {
                    setError(BADLDESC);
                    rc=false;
               }
          }
     }
     return(rc);
}

bool
libEditSynthesis::getAltPath()
{
     bool rc=true;

     if (GETPARAMVAL("altpath")) {
          if (::strlen(m_pValBuf) >= GCSTRPTH) {
               setError(TOOLONG,m_pValBuf,"altpath");
               rc=false;
          }
          else if (*m_pValBuf == '\0') {
               m_libraryPtr->lib.path[0]='\0';

          }
          else if (!m_pLibAPI->isValidPath(m_pValBuf)) {
               setError(INVDIR,"altpath");
               rc=false;
          }
          else {
               ::stlcpy(m_libraryPtr->lib.path,checkdir(fnmcse(m_pValBuf)),GCSTRPTH);
          }
     }
     return(rc);
}

bool
libEditSynthesis::getCheckParams()
{
     INT i=0;

     while (0 != pfArray[i].pname) {
          GETPARAMVAL(pfArray[i].pname);
          if (GOTPVAL && (m_pValBuf[0] == 'Y' || m_pValBuf[0] == 'y')) {
               m_libraryPtr->lib.flags|=pfArray[i].flag;
          }
          else if (GOTPVAL) {
               m_libraryPtr->lib.flags&=~pfArray[i].flag;
          }
          ++i;
     }
     return(true);
}

bool
libEditSynthesis::getRoyalty()
{

     bool rc=true;

     if (GETPARAMVAL("royalty")) {
          SHORT royal=static_cast<SHORT>(::atoi(m_pValBuf));
          if ((royal > 100) || (royal < 0)) {
               setError(INVVALUE,m_pValBuf,"royalty");
               rc=false;
          }
          else {
               m_libraryPtr->lib.royal=royal;
          }
     }
     return(rc);
}

bool
libEditSynthesis::getMaxFiles()
{
     bool rc=true;

     if (GETPARAMVAL("maxfiles")) {
          LONG files=::atol(m_pValBuf);

          if ((files < 0) || (files > MAXMISCSIZ)) {
               setError(INVVALUE,m_pValBuf,"files");
               rc=false;
          }
          else {
               m_libraryPtr->lib.maxfil=files;
          }
     }
     return(rc);
}

bool
libEditSynthesis::getMaxBytes()
{
     bool rc=true;

     if (GETPARAMVAL("maxbytes")) {
          LONG maxbytes=::atol(m_pValBuf);

          if ((maxbytes < 0) || (maxbytes > MAXMISCSIZ)) {
               setError(INVVALUE,m_pValBuf,"maxbytes");
               rc=false;
          }
          else {
               m_libraryPtr->lib.maxbyt=maxbytes;
          }
     }
     return(rc);
}

bool
libEditSynthesis::getMaxUpload()
{
     bool rc=true;

     if (GETPARAMVAL("maxupload")) {
          LONG upload=::atol(m_pValBuf);

          if ((upload < 0) || (upload > MAXMISCSIZ)) {
               setError(INVVALUE,m_pValBuf,"maxupload");
               rc=false;
          }
          else {
               m_libraryPtr->lib.maxbup=upload;
          }
     }
     return(rc);
}

bool
libEditSynthesis::getDownChargeFile()
{
     bool rc=true;

     if (GETPARAMVAL("downchargefile")) {
          LONG num=::atol(m_pValBuf);
          if (!alldgs(m_pValBuf)
           && ((m_pValBuf[0] == '-') && !alldgs(&m_pValBuf[1]))) {
               setError(INVVALUE,m_pValBuf,"download charge per file");
               rc=false;
          }
          else if (::strlen(m_pValBuf) > 9) {
               setError(TOOLONG,m_pValBuf,"download charge per file");
               rc=false;
          }
          else {
               m_libraryPtr->lib.dlchge=num;
          }
     }
     return(rc);
}

bool
libEditSynthesis::getDownChargeK()
{
     bool rc=true;

     if (GETPARAMVAL("downchargek")) {
          LONG num=::atol(m_pValBuf);

          if (!alldgs(m_pValBuf)
           || (m_pValBuf[0] == '-' && !alldgs(&m_pValBuf[1]))) {
               setError(INVVALUE,m_pValBuf,"download charge per k");
               rc=false;
          }
          else if (strlen(m_pValBuf) > 9) {
               setError(TOOLONG,m_pValBuf,"download charge per k");
               rc=false;
          }
          else {
               m_libraryPtr->lib.kdlchge=num;
          }
     }
     return(rc);
}

bool
libEditSynthesis::getLibOp()
{
     bool rc=true;

     if (GETPARAMVAL("libop")) {
          CHAR* uptr=uidCaps(m_pValBuf);

          if (0 != uptr) {
               ::stlcpy(m_libraryPtr->lib.primary,uptr,UIDSIZ);
          }
          else {
               setError(BADID);
               rc=false;
          }
     }
     return(rc);
}

bool
libEditSynthesis::getKeys()
{
     if (!checkKey("viskey",m_libraryPtr->lib.keyreq)) {
          return(false);
     }
     if (!checkKey("dlkey",m_libraryPtr->lib.dlkey)) {
          return(false);
     }
     if (!checkKey("ulkey",m_libraryPtr->lib.ulkey)) {
          return(false);
     }
     if (!checkKey("overwritekey",m_libraryPtr->lib.overw)) {
          return(false);
     }
     if (!checkKey("preapvkey",m_libraryPtr->lib.autoap)) {
          return(false);
     }
     if (!checkKey("libopkey",m_libraryPtr->lib.libop)) {
          return(false);
     }
     return(true);
}

bool
libEditSynthesis::checkKey(
const CHAR *paramName,
CHAR *buf)
{
     if (GETPARAMVAL(paramName)) {
          if (::strlen(m_pValBuf) >= KEYSIZ) {
               setError(TOOLONG,m_pValBuf,paramName);
               return(false);
          }
          if (!keynam(::strupr(m_pValBuf))) {
               setError(INVNAME);
               return(false);
          }
          ::stlcpy(buf,::strupr(m_pValBuf),KEYSIZ);
     }
     return(true);
}
