/***************************************************************************
 *                                                                         *
 *   LDELSYN.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Library Synthesis Class.                                              *
 *                                                 - N.C. Osterc  11/09/98 *
 *                                                                         *
 ***************************************************************************/

#include "libinc.h"
#include "ldelsyn.h"

#define FILREV     "$Revision: 3 $"
#define LIBDELDIR  "library/delete/"

enum { DELPARAM, DELWORK, DELRESP, DELACCESS };

// Dynafile defs

dnfStep dnfLdelConfSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfLdelErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfLdelConfMap(PPFIX LIBDELDIR "index.htm","Default",dnfLdelConfSteps);
dnfMap dnfLdelErrMap(PPFIX LIBDELDIR "error.htm","Error",dnfLdelErrSteps);

// class method defs

MARKSOURCE(ldelsyn);

libDelSynthesis::libDelSynthesis(       // default constructor
               acthSession *_ses):
               libManSynthesis(_ses)
{
     m_ahState=DELPARAM;
}

libDelSynthesis::~libDelSynthesis()     // destructor
{
}

ACTHCODE
libDelSynthesis::proceed()           // proceed entry point
{
     ACTHCODE retval=isUserOK();

     if ((ACTHMORE == retval) && m_cyc.start()) {
          do {
               switch(m_ahState) {
               case DELPARAM:
                    GETPARAMVAL("libname");
                    if (GOTPVAL) {
                         m_libraryPtr=new library(m_pValBuf);
                         if (!hasSysopPowers() && !hasLibOpAccess()) {
                              return(ACTHFORBID);
                         }
                         if (m_libraryPtr->exists()) {
                              INT locku;
                              if (othrsin(m_libraryPtr->lib.libname)) {
                                   setError(OTHINLIB);
                              }
                              else if (!m_libraryPtr->getWriteLock(&locku)) {
                                   setError(CONFDEL);
                              }
                              else if (sameas(m_libraryPtr->lib.libname,deflname)) {
                                   m_libraryPtr->releaseWriteLock();
                                   setError(DELDEFLT);
                              }
                              else {
                                   untagall(m_libraryPtr->lib.libname,"");
                                   m_libraryPtr->clearLibMem();
                                   sortlibs();
                                   scanlibs();
                                   m_libraryPtr->releaseWriteLock();
                                   m_ahState=DELWORK;
                                   break;
                              }
                              setMap(&dnfLdelErrMap);
                              m_ahState=DELRESP;
                              break;
                         }
                    }
                    setError(NOTFOUND);
                    setMap(&dnfLdelErrMap);
                    m_ahState=DELRESP;
                    break;
               case DELWORK:
                    switch (m_libraryPtr->removeFromDisk()) {
                    case FLMAN_SUCCESS:
                         m_ahState=DELRESP;
                         setMap(&dnfLdelConfMap);
                         break;
                    case FLMAN_WORKING:
                         break;
                    default:
                         ASSERTM(FALSE,"Unhandled library remove case!");
                    }
                    break;
               case DELRESP:
                    retval=dynafile();
                    break;
               }
          } while ((ACTHDONE != retval) && m_cyc.haveTime());
     }
     return(retval);
}
