/***************************************************************************
 *                                                                         *
 *   JOINSYN.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Library Join Synthesis Class.                                         *
 *                                                 - N.C. Osterc  11/17/98 *
 *                                                                         *
 ***************************************************************************/

#include "libinc.h"
#include "joinsyn.h"

#define FILREV   "$Revision: 4 $"
#define JOINDIR  "library/join/"

enum { JOINPARAM, JOINWORK, JOINRESP };

// Dynafile defs

dnfStep dnfJoinErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfDefJoinSteps[]={
     dnfStep(DNFMAPEND)
};

enum {LISTITEM,LISTITEM1};

dnfStep dnfListJoinedSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,LISTITEM,"LISTITEM"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};

dnfStep dnfListUnJoinedSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,LISTITEM1,"LISTITEM"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};

dnfMap dnfJoinErrMap(PPFIX JOINDIR "error.htm","Error",dnfJoinErrSteps);
dnfMap dnfListJoinedMap(PPFIX JOINDIR "jlist.htm","Join List",dnfListJoinedSteps);
dnfMap dnfListUnJoinedMap(PPFIX JOINDIR "ujlist.htm","Unjoin List",dnfListUnJoinedSteps);
dnfMap dnfDefJoinMap(PPFIX JOINDIR "index.htm","Default",dnfDefJoinSteps);

// class method defs

MARKSOURCE(joinsyn);

joinSynthesis::joinSynthesis(       // default constructor
               acthSession *_ses):
               libManSynthesis(_ses),
               m_joinLibPtr(NULL),
               m_pjLibName(NULL) ,
               m_totJoined(0),
               m_tableDone(false),
               m_bUnJoin(false)
{
     m_ahState=JOINPARAM;
}

joinSynthesis::~joinSynthesis()     // destructor
{
     if (0 != m_joinLibPtr) {
          delete m_joinLibPtr;
     }
}

ACTHCODE
joinSynthesis::proceed()           // proceed entry point
{
     ACTHCODE retval=isUserOK();

     if ((ACTHMORE == retval) && m_cyc.start()) {
          do {
               switch(m_ahState) {
               case JOINPARAM:
                    GETPARAMVAL("libname");
                    if (GOTPVAL) {
                         m_libraryPtr=new library(m_pValBuf);
                         if (!hasSysopPowers() && !hasLibOpAccess()) {
                              return(ACTHFORBID);
                         }
                         if (!m_libraryPtr->exists()) {
                              setNotFound(m_pValBuf);
                              break;
                         }
                    }
                    m_bUnJoin=ISPARAM("unjoin");
                    if (ISPARAM("list")) {
                         setMap((m_bUnJoin ? &dnfListUnJoinedMap : &dnfListJoinedMap));
                         m_ahState=JOINRESP;
                         break;
                    }
                    GETPARAMVAL("joinlib");
                    if (GOTPVAL) {
                         if (!m_pLibAPI->exists(m_pValBuf)) {
                              setNotFound(m_pValBuf);
                              break;
                         }
                         else if (::sameas(m_pValBuf,m_libraryPtr->lib.libname)) {
                              setError(NOJ2SELF);
                              setMap(&dnfJoinErrMap);
                              break;
                         }
                         else {
                              m_joinLibPtr=new library(m_pValBuf);
                              m_ahState=JOINWORK;
                              break;
                         }
                    }
                    if (0 == m_libraryPtr) {
                         setNotFound("<none>");
                    }
                    else {
                         setMap(&dnfDefJoinMap);
                         m_ahState=JOINRESP;
                    }
                    break;
               case JOINWORK:
                    ::setmbk(flmsg);
                    if (m_bUnJoin) {
                         if (!chjoined(&(m_joinLibPtr->lib),
                          m_libraryPtr->lib.libname)) {
                              setError(NOTJOIN);
                              setMap(&dnfJoinErrMap);
                         }
                         else if (!chjoin(m_libraryPtr->getLibMemPtr(),
                          m_joinLibPtr->getLibMemPtr(),true)) {
                              setError(UNJFAIL);
                              setMap(&dnfJoinErrMap);
                         }
                         else {
                              scanlibs();
                              setMap(&dnfDefJoinMap);
                         }
                    }
                    else {
                         if (chjoined(&(m_joinLibPtr->lib),
                         m_libraryPtr->lib.libname)) {
                              setError(ALREADYJ);
                              setMap(&dnfJoinErrMap);
                         }
                         else if (!chjoin(m_libraryPtr->getLibMemPtr(),
                          m_joinLibPtr->getLibMemPtr(),false)) {
                              setError(JOINFAIL);
                              setMap(&dnfJoinErrMap);
                         }
                         else {
                              scanlibs();
                              setMap(&dnfDefJoinMap);
                         }
                    }
                    ::rstmbk();
                    m_ahState=JOINRESP;
                    break;
               case JOINRESP:
                    if (0 != m_libraryPtr) {
                         m_pLibVars->setLibraryVars(m_libraryPtr);
                    }
                    retval=dynafile();
                    break;
               }
          } while ((ACTHDONE != retval) && m_cyc.haveTime());
     }
     return(retval);
}

VOID
joinSynthesis::setNotFound(        // set up not found error
CHAR *libname)
{
     setError(NOJFND,libname);
     setMap(&dnfJoinErrMap);
     m_ahState=JOINRESP;
}

ACTHCODE
joinSynthesis::dynafile()          // overriden dynafile
{
     ACTHCODE retval=ACTHMORE;

     if (m_tableDone && (0 == m_totJoined)) {
          ::setmbk(ahLibManMsg);
          t_NoneJoined=::getmsg(NONEJND);
          ::rstmbk();
     }
     if (0 != m_pjLibName) {
          t_JoinedLibEnc=m_pjLibName;
          t_JoinedLib=m_pjLibName;
     }

     switch (m_dnfPtr->process()) {
     case DNFROWBEGIN:
          if (m_bUnJoin) {
               if (0 != (m_pjLibName=m_pLibAPI->getNextUnJoined(&(m_libraryPtr->lib)
                 ,m_pjLibName))) {
                    ::stlcpy(m_jNameBuf,m_pjLibName,FLNAMESZ);
                    m_pjLibName=&m_jNameBuf[0];
                    t_JoinedLibEnc=m_pjLibName;
                    t_JoinedLib=m_pjLibName;
                    ++m_totJoined;
               }
               else {
                    m_dnfPtr->tableDone();
                    m_tableDone=true;
               }
          }
          else {
               if (0 != (m_pjLibName=m_pLibAPI->getNextJoined(&(m_libraryPtr->lib)
                 ,m_pjLibName))) {
                    ::stlcpy(m_jNameBuf,m_pjLibName,FLNAMESZ);
                    m_pjLibName=&m_jNameBuf[0];
                    t_JoinedLibEnc=m_pjLibName;
                    t_JoinedLib=m_pjLibName;
                    ++m_totJoined;
               }
               else {
                    m_dnfPtr->tableDone();
                    m_tableDone=true;
               }
          }
          break;
     case DNFEND:
          retval=ACTHDONE;
          break;
     }
     return(retval);
}

