/***************************************************************************
 *                                                                         *
 *   FLMANAGT.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Library-Manager Agent Class.                                          *
 *                                                  - N.C. Osterc 10/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "libinc.h"
#include "flmanagt.h"
#include "libsyn.h"
#include "joinsyn.h"
#include "ldelsyn.h"
#include "feditsyn.h"
#include "leditsyn.h"
#include "logsyn.h"

#define URLARG1(x) sameas(ses->urlargv(0),x)
#define URLARG2(x) sameas(ses->urlargv(1),x)

libManAgent *pLibAgent;             // pointer to poll-manager agent

CHAR *hlmankey;                     // key for axs
INT timslc;                         // time slice
HMCVFILE ahLibManMsg;               // AH Library-Manager messages

VOID delAgent(VOID);                // delete agent
VOID getOptions();                  // read in message options
VOID freeOptions();                 // free message options

MARKSOURCE(flmanagt);

libManAgent::libManAgent() : acthAgent("AH Library Management","library-manager")  // default constructor
{
     //init__galfil();
     registerAgent(acthVersion);
     hook_finalshutdown(delAgent);
     getOptions();
}

libManAgent::~libManAgent()        // destructor
{
     freeOptions();
}

acthSynthesis *                    // synth obj ptr
libManAgent::newSynthesis(         // return a new synthesis object
acthSession *ses)                  // session object
{
     libManSynthesis* libSynth=0;

     if (ses->urlargc() >= 2) {
          if (URLARG1("library")) {
               if (URLARG2("delete")) {
                    libSynth=new libDelSynthesis(ses);
               }
               else if (URLARG2("edit")) {
                    libSynth=new libEditSynthesis(ses);
               }
               else if (URLARG2("join")) {
                    libSynth=new joinSynthesis(ses);
               }
               else if (URLARG2("log")) {
                    libSynth=new logSynthesis(ses);
               }
          }
          else if (URLARG1("file")) {
               if (URLARG2("edit")) {
                    libSynth=new fileEditSynthesis(ses);
               }
          }
     }
     if (0 == libSynth) {
          libSynth=new libManSynthesis(ses);
     }
     return(libSynth);
}

extern "C" VOID EXPORT             // init our agent
init__galflmah(VOID)
{
     pLibAgent=new libManAgent;
}

VOID
getOptions()
{
     ahLibManMsg=::opnmsg("GALFLMAH.MCV");
     ::setmbk(ahLibManMsg);
     hlmankey=::stpans(::stgopt(HLMANKEY));
     timslc=::numopt(TIMSLC,1,1000);
     ::rstmbk();
}

VOID
freeOptions()
{
     ::free(hlmankey);
     ::clsmsg(ahLibManMsg);
}

VOID
delAgent(                          // delete our agent
VOID)
{
     if (0 != pLibAgent) {
          delete pLibAgent;
     }
}
