/***************************************************************************
 *                                                                         *
 *   FILE.H                                                                *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Wrapper Class                                                    *
 *                                                                         *
 *                                                 - N.C. Osterc  11/04/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __FILE_H
#define __FILE_H

enum {RENKEYREM, RENLAST, RENPREP};

class file : public flfile {
public:

     file();                       // constructor

     file(                         // constructor
     const CHAR *newlibname,
     const CHAR *newfilename);     // passed name

     ~file();                      // destructor

     bool
     load();                       // load file data

     bool
     approve(                      // approve this file
     USHORT newdate);

     bool
     unApprove();                  // unapprove this file

     bool
     unLog();                      // unlog this file

     bool
     log(                          // log this file
     bool approve);

     bool
     nameOk();                     // is the file name ok?

     FLMANCODE
     update();                     // update existing file

     bool
     insertRecord();               // insert new record for file

     FLMANCODE
     rename();                     // rename file

     VOID
     addKeyWords(                  // add keywords for this file
     CHAR *flname);

     bool
     canRemoveKeyWord(             // keeps deleting keywords.. FALSE when done
     CHAR *newfilname);

     bool
     removeRecord();               // remove the file's database record

     VOID
     removeActual();               // remove the actual file on disk

     VOID
     renameActual(                 // rename the file on disk
     CHAR *oldname,
     CHAR *newname);

     FLMANCODE
     despose();                    // remove this file (from DB and disk)

     VOID
     setDescription(               // set up description
     const CHAR *newdesc);            // given description

     bool
     getWriteLock(                 // get a write lock
     INT *othusn);

     VOID
     releaseWriteLock();           // release the write lock

     VOID
     setOldName(                   // set up old file name
     CHAR *oldName);

private:

     VOID
     setKey();                     // setup composite key

     bool
     updateRecord();               // update disk

     struct key1 m_key;            // key structure
     SHORT m_flCode;               // file library code
     INT m_lock;                   // file lock
     INT m_othUnum;                // used on calls to getWriteLock()
     CHAR m_oldName[FLFILENM];     // store old filename
     SHORT m_renCode;              // rename process code
};

#endif                             // __LIBRARY_H
