/***************************************************************************
 *                                                                         *
 *   FEDITSYN.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   File Edit Synthesis Class.                                            *
 *                                                - N.C. Osterc  11/09/98  *
 *                                                                         *
 ***************************************************************************/

#include "libinc.h"
#include "feditsyn.h"

#define FILREV  "$Revision: 3 $"
#define FNAMESIZ 6
#define FEDITDIR "file/edit/"

// Dynafile defs

dnfStep dnfFeditDefSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfFeditConfSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfFeditErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap defFeditMap(PPFIX FEDITDIR "index.htm","Default",dnfFeditDefSteps);
dnfMap confFeditMap(PPFIX FEDITDIR "confirm.htm","Confirmation",dnfFeditConfSteps);
dnfMap errFeditMap(PPFIX FEDITDIR "error.htm","Error",dnfFeditErrSteps);

enum {FEDITPARAM, FEDITACCESS, FEDITRESP, FEDITUPDATE, FEDITRENAME,
      FEDITAPPROVE, FEDITUNAPV, FEDITUNLOG, FEDITDEL};

// class method defs

MARKSOURCE(feditsyn);

fileEditSynthesis::fileEditSynthesis(       // default constructor
     acthSession *_ses):
     libManSynthesis(_ses),
     m_rename(false),
     m_paramCount(0),
     m_paramProc(0)
{
     m_ahState=FEDITACCESS;
}

fileEditSynthesis::~fileEditSynthesis()     // destructor
{
}

ACTHCODE
fileEditSynthesis::proceed()           // proceed entry point
{
     FLMANCODE flc;
     ACTHCODE retval=isUserOK();

     if ((ACTHMORE == retval) || m_cyc.start()) {
          do {
               switch (m_ahState) {
               case FEDITACCESS:
                    if (!getLibName(true)) {
                         setMap(&errFeditMap);
                         m_ahState=FEDITRESP;
                         break;
                    }
                    else if (!hasSysopPowers() && !hasLibOpAccess()) {
                         return(ACTHFORBID);
                    }
                    m_ahState=FEDITPARAM;
                    break;
               case FEDITPARAM:
                    if (!getFName()) {
                         m_ahState=FEDITRESP;
                         setMap(&errFeditMap);
                         break;
                    }
                    m_paramCount=ses->nparam();
                    if (ISPARAM("save")) {
                         if (getUploader() && getDownloads() && getTimeAdded()
                          && getDesc() && getRename() && getDateAdded()) {
                              m_ahState=(m_rename ? FEDITRENAME : FEDITUPDATE);
                              break;
                         }
                         else {
                              setMap(&errFeditMap);
                         }
                    }
                    else if (ISPARAM("approve")) {
                         m_ahState=FEDITAPPROVE;
                         break;
                    }
                    else if (ISPARAM("unapprove")) {
                         m_ahState=FEDITUNAPV;
                         break;
                    }
                    else if (ISPARAM("unlog")) {
                         m_ahState=FEDITUNLOG;
                         break;
                    }
                    else if (ISPARAM("delete")) {
                         m_ahState=FEDITDEL;
                         break;
                    }
                    else {
                         setMap(&defFeditMap);
                    }
                    m_ahState=FEDITRESP;
                    break;
               case FEDITRENAME:
                    switch ((flc=m_filePtr->rename())) {
                    case FLMAN_WORKING:
                         break;
                    case FLMAN_SUCCESS:
                         m_ahState=FEDITRESP;
                         setMap(&confFeditMap);
                         break;
                    default:
                         handleErrorCode(flc);
                         setMap(&errFeditMap);
                         m_ahState=FEDITRESP;
                         break;
                    }
                    break;
               case FEDITAPPROVE:
                    if (getNextFname()) {
                         if (!getFName(false)) {
                              setMap(&errFeditMap);
                              m_ahState=FEDITRESP;
                         }
                         else {
                              if (!m_filePtr->approve(false)) {
                                   setMap(&errFeditMap);
                                   setError(FAILAPV);
                              }
                         }
                    }
                    else {
                         setMap(&confFeditMap);
                         m_ahState=FEDITRESP;
                    }
                    break;
               case FEDITUNAPV:
                    if (getNextFname()) {
                         if (!getFName(false)) {
                              setMap(&errFeditMap);
                              m_ahState=FEDITRESP;
                         }
                         else {
                              if (!m_filePtr->unApprove()) {
                                   setMap(&errFeditMap);
                                   setError(FAILUAPV);
                              }
                         }
                    }
                    else {
                         setMap(&confFeditMap);
                         m_ahState=FEDITRESP;
                    }
                    break;
               case FEDITUNLOG:
                    if (getNextFname()) {
                         if (!getFName(false)) {
                              setMap(&errFeditMap);
                              m_ahState=FEDITRESP;
                         }
                         else {
                              if (!m_filePtr->unLog()) {
                                   setMap(&errFeditMap);
                                   setError(FAILULOG);
                              }
                         }
                    }
                    else {
                         setMap(&confFeditMap);
                         m_ahState=FEDITRESP;
                    }
                    break;
               case FEDITDEL:
                    if (getNextFname()) {
                         if (!getFName(false)) {
                              setMap(&errFeditMap);
                              m_ahState=FEDITRESP;
                         }
                         else {
                              if (!m_filePtr->despose()) {
                                   setMap(&errFeditMap);
                                   setError(FAILDEL);
                              }
                         }
                    }
                    else {
                         setMap(&confFeditMap);
                         m_ahState=FEDITRESP;
                    }
                    break;
               case FEDITUPDATE:
                    switch ((flc=m_filePtr->update())) {
                    case FLMAN_WORKING:
                         break;
                    case FLMAN_SUCCESS:
                         m_ahState=FEDITRESP;
                         setMap(&confFeditMap);
                         break;
                    default:
                         handleErrorCode(flc);
                         setMap(&errFeditMap);
                         m_ahState=FEDITRESP;
                         break;
                    }
                    break;
               case FEDITRESP:
                    if (0 != m_libraryPtr) {
                         m_pLibVars->setLibraryVars(m_libraryPtr);
                    }
                    if (0 != m_filePtr) {
                         m_pLibVars->setFileVars(m_filePtr);
                    }
                    retval=dynafile();
                    break;
               }
          } while ((ACTHDONE != retval) && m_cyc.haveTime());
     }
     return(retval);
}

bool
fileEditSynthesis::getFName(
bool getParam)
{
     if (getParam) {
          GETPARAMVAL("fname");
     }
     bool rc=false;

     if (GOTPVAL) {
          if (0 != m_filePtr) {
               delete m_filePtr;
               m_filePtr=0;
          }
          m_filePtr=new file();
          ::stlcpy(m_filePtr->filname,m_pValBuf,FLFILENM);
          ::stlcpy(m_filePtr->libname,m_libraryPtr->lib.libname,FLNAMESZ);
          if (!m_filePtr->load()) {
               setError(FILNFND,m_pValBuf);
          }
          else {
               rc=true;
          }
     }
     else {
          setError(NOVALUE,"fname");
     }
     return(rc);
}

bool
fileEditSynthesis::getRename()
{
     GETPARAMVAL("rename");
     bool rc=true;

     if (GOTPVAL) {
          if (!::isvalfn(m_pValBuf)) {
               setError(INVFNAME,m_pValBuf);
               rc=false;
          }
          else if (::strlen(m_pValBuf) >= FLFILENM) {
               setError(FIL2LONG,m_pValBuf);
               rc=false;
          }
          else if (!::sameas(m_pValBuf,m_filePtr->filname)) {
               m_filePtr->setOldName(m_filePtr->filname);
               ::stlcpy(m_filePtr->filname,mkdosn(m_pValBuf),FLFILENM);
               m_rename=true;
          }
     }
     return(rc);
}

bool
fileEditSynthesis::getUploader()
{
     GETPARAMVAL("uploader");
     bool rc=true;

     if (GOTPVAL) {
          CHAR *uptr=uidCaps(m_pValBuf);

          if (0 != uptr) {
               ::stlcpy(m_filePtr->ulby,uptr,UIDSIZ);
          }
          else {
               setError(UIDNFND,m_pValBuf);
               rc=false;
          }
     }
     return(rc);
}

bool
fileEditSynthesis::getDownloads()
{
     GETPARAMVAL("downloads");
     bool rc=true;

     if (GOTPVAL) {
          if (!::alldgs(m_pValBuf)) {
               setError(INVVALUE,m_pValBuf,"downloads");
               rc=false;
          }
          else if (::strlen(m_pValBuf) >= NUMSZ) {
               setError(TOOLONG,m_pValBuf,"downloads");
               rc=false;
          }
          else {
               ::stlcpy(m_filePtr->numdls,m_pValBuf,NUMSZ);
          }
     }
     return(rc);
}

bool
fileEditSynthesis::getDateAdded()
{
     GETPARAMVAL("dateadded");
     bool rc=true;
     INT y;
     INT m;
     INT d;

     if (GOTPVAL) {
          dateDecode(m_pValBuf,&y,&m,&d);
          if (!validDate(y,m,d)) {
               setError(BADDATE);
               rc=false;
          }
          else if (dddate(m,d,y) > today()) {
               setError(ADVDATE);
               rc=false;
          }
          else {
               if (::sameas(m_filePtr->udate,NOTAPPED)) {
                    m_filePtr->approve(dddate(m,d,y));
               }
               else {
                    ::stlcpy(m_filePtr->udate,dat2srt(m_pValBuf),DATESZ);
               }
          }
     }
     return(rc);
}

bool
fileEditSynthesis::getTimeAdded()
{
     GETPARAMVAL("timeadded");
     bool rc=true;
     USHORT time=dctime(m_pValBuf);

     if (GOTPVAL) {
          if (GCINVALIDDOT == time) {
               setError(BADTIME);
               rc=false;
          }
          else {
               m_filePtr->utime=time;
          }
     }
     return(rc);
}

bool
fileEditSynthesis::getDesc()
{
     GETPARAMVAL("desc");
     bool rc=true;

     if (GOTPVAL) {
          if (strlen(m_pValBuf) >= DESCSIZ) {
               setError(TOOLONG,m_pValBuf,"desc");
               rc=false;
          }
          else {
               m_filePtr->setDescription(m_pValBuf);
          }
     }
     return(rc);
}

bool
fileEditSynthesis::getNextFname()
{
     while (m_paramProc < m_paramCount) {
          CHAR fnameBuf[FNAMESIZ];

          ses->param(m_paramProc,fnameBuf,FNAMESIZ,m_pValBuf,PVALBUFSIZ);
          ++m_paramProc;
          if (('\0' != fnameBuf[0]) && ::sameas(fnameBuf,"fname")
           && ('\0' != m_pValBuf[0])) {
               return(true);
          }
     }
     return(false);
}
