#include "gcomm.h"                                     // Galacticomm's world
#include "galacth.h"                                   // Active HTML world
#include "dnf.h"                                       // DynaFile tools

enum {FILELINK,FILENAM,FILEDESC};

dnfStep flistSteps[]={
     dnfStep(DNFTABLE),                                // start of table
          dnfStep(DNFCOLUMN,FILELINK,"FILELINK"),      // 1st column, FILELINK
          dnfStep(DNFCOLUMN,FILENAM ,"FILENAME"),      // 2nd column, FILENAME
          dnfStep(DNFCOLUMN,FILEDESC,"FILEDESC"),      // 3rd column, FILEDESC
     dnfStep(DNFTABLEEND),                             // end of table
     dnfStep(DNFMAPEND)
};
dnfMap flistMap("galacth/galflist/galflist.htm",
                "List of files and descriptions",flistSteps);

class flAgent : public acthAgent { // file listing agent
public:
     flAgent() : acthAgent("FTP site File Listing","galflist")
     {
          registerAgent(acthVersion);
     }

     acthSynthesis *               //   session info
     newSynthesis(                 // instantiate Synthesis class
     acthSession *ses);            //   for passing to acthSynthesis's ctor
};

class flSynthesis : public acthSynthesis { // hello-world response synthesis
public:
     flSynthesis(acthSession *_ses) : acthSynthesis(_ses), dnf(NULL) { }

     ~flSynthesis()                // desctructor
     {
          if (dnf != NULL) {
               delete dnf;
               dnf=NULL;
          }
     }

     ACTHCODE                      //   enumerated response (see galacth.h)
     proceed();                    // process request, synthesize response

private:
     dnfHandler *dnf;              // pointer to DynaFile Handler
};

flAgent theflAgent;                // the one and only instance of flAgent

acthSynthesis *                    //   new session-specific structure
flAgent::newSynthesis(             // instantiate Synthesis class
acthSession *ses)                  //   passed to acthSynthesis's constructor
{
     return(new flSynthesis(ses));
}

ACTHCODE
flSynthesis::proceed()
{
     ACTHCODE retval=ACTHMORE;

     if (dnf == NULL) {
          dnf=new dnfHandler(flistMap,bout);
     }
     else {
          switch (dnf->process()) {
          case DNFROWBEGIN:
               if (dnf->rowNumber() == 4) {
                    dnf->tableDone();
               }
               break;
          case FILELINK:                           // hyperlink    \ coincidentally,
          case FILENAM:                            // file name    / the same text
               switch (dnf->rowNumber()) {
               case 0:
                    bout << "MAKOREAD.EXE";
                    break;
               case 1:
                    bout << "BASE42.ZIP";
                    break;
               case 2:
                    bout << "GENUTECH.DOC";
                    break;
               case 3:
                    bout << "HILSBORG.JPG";
                    break;
               }
               break;
          case FILEDESC:                           // file descriptions
               switch (dnf->rowNumber()) {
               case 0:
                    bout << "Reads a Mako-encrypted file";
                    break;
               case 1:
                    bout << "Answers to life, universe, everything";
                    break;
               case 2:
                    bout << "GenuTech's business plan";
                    break;
               case 3:
                    bout << "Aerial view of the Hillsborough site";
                    break;
               }
               break;
          case DNFEND:
               retval=ACTHDONE;
               break;
          }
     }
     return(retval);
}
