/***************************************************************************
 *                                                                         *
 *   SYNLLIBS.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File List Libraries Synthesis                             *
 *   Declaration                                                           *
 *                                                                         *
 *                                                - Phil Henning 10/16/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __SYNLLIBS_H
#define __SYNLLIBS_H

#include "synfilah.h"
#include "filtdef.h"

class synListLibs : public synBaseAuth {     // /list/libs URL
public:
     synListLibs(
     acthSession* _ses,
     bool anonok,
     INT lvlcnt=0);

     ~synListLibs();

protected:
     ACTHCODE
     proceedRequest();                       // proceed with request

     ACTHCODE
     proceedSynth();                         // proceed with synthesis

     ACTHCODE
     proceedDerivedResponse();               // proceed with response

     VOID
     addToQueue();                           // add to queue

     bool
     okToAdd(                                // ok to add this lib
     const struct fllib* pLib);              // lib to add

     VOID
     buildMap();                             // build list map

     VOID
     buildContext();                         // build list context

     INT
     translateError();                       // translate err to mcv file op

private:
     LIBACCESS      m_listAccess;            // access to list
     LIBTYPE        m_listType;              // type of libs (os, normal)
     LISTORDER      m_listOrder;             // list order
     LISTDIR        m_listDirection;         // list direction (gt, lt, etc)
     INT            m_listCount;             // max number to list
     INT            m_curCount;              // current number listed
     bool           m_listAll;               // list all?
     bool           m_started;               // have we started yet?
     bool           m_moreLow;               // list context - more low
     bool           m_moreHigh;              // list context - more high
     struct fllib   m_fllib;                 // file library struct
     string         m_strStart;              // start parameter
     string         m_strLast;               // last one listed
     string         m_strHighLib;            // high library
     string         m_strLowLib;             // low library
     LIBQUE         m_queue;                 // queue to store fllib structs
     struct fllib*  m_flParent;              // root lib we are searching in
     bool           m_allDone;               // are we completely done?
};


#endif // __SYNLLIBS_H

