/***************************************************************************
 *                                                                         *
 *   SYNLFILS.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File List Files Synthesis                                 *
 *   Declaration                                                           *
 *                                                                         *
 *                                                - Phil Henning 10/27/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __SYNLFILS_H
#define __SYNLFILS_H

#include "synfilah.h"
#include "filtdef.h"
#include "libqueue.h"
#include "kwdsrch.h"


class synListFiles : public synBaseAuth {     // /list/libs URL
public:
     synListFiles(
     acthSession* _ses,
     bool anonok,
     INT lvlcnt=0);

     ~synListFiles();

protected:
     ACTHCODE
     proceedRequest();             // setup request context

     ACTHCODE
     proceedSynth();               // proceed with synthesis

     ACTHCODE
     proceedDerivedResponse();     // proceed with response

     INT
     translateError();             // translate err to mcv file op

private:
     VOID
     InitSyn();                    // initialize synthesis

     VOID
     buildOSMap();                 // build OS file map

     string
     getFileName(                  // get file name from string
     const string& str);           // string to extract from

     string
     getLibName(                   // get lib name from string
     const string& str);           // string to extract from

     string
     getUDate(                     // get uploaded date from string
     const string& str);           // string to extract from

     string
     getPop(                       // get popularity from string
     const string& str);           // string to extract from

     VOID
     initKeys();                   // init btrieve keys

     VOID
     buildContext();               // build non-os list context

     VOID
     buildMap();                   // build non-os map

     VOID
     setMoreString(                // build more string from file data
     string* str,                  // ptr to string to hold more string
     const flfile& file);          // file to build string from

     VOID
     buildOSContext();             // build os list context

     VOID
     handleContext(                // handle context for name,date,pop srchs
     INT keynum);                  // btrieve key

     VOID
     handleDateSearch(             // handle date search
     INT keynum);                  // btrieve key

     bool
     handleContinuingList(         // handle continuing list in search
     INT keynum);                  // btrieve key

     VOID
     handleSearch(                 // handle name searches
     INT keynum);                  // btrieve key

     VOID
     handlePopSearch(              // handle pop searches
     INT keynum);                  // btrieve key

     VOID
     handleKeywordContext();       // build context for keyword searches

     VOID
     handleKeywordSearch();        // do the keyword search

     VOID
     updateKeys();                 // update btrieve keys

     bool
     setNextLib();                 // set next lib to search

     VOID
     setInitialLib();              // set initial lib to search in

     bool
     okToAdd(                      // ok to add this file?
     const struct flfile* pFile);  // file struct to add

     VOID
     addToQueue(                   // add to file list queue
     const struct flfile& ff);     // file to add

     VOID
     addToOSQueue(                 // add to os file list queue
     const struct ffblk& ff);      // file to add

     LISTORDER
     LoadDftOrder(                 // load default order
     acthUserID* uid);             // for this User-ID

     VOID
     SaveDftOrder(                 // save default order
     acthUserID* uid,              // for this User-ID
     LISTORDER neworder);          // new list order

     SEARCHTYPE
     LoadDftSearch(                // load default search type
     acthUserID* uid);             // for this User-ID

     VOID
     SaveDftSearch(                // save default search type
     acthUserID* uid,              // for this User-ID
     SEARCHTYPE neworder);         // new search order

     NAMESTART
     GetDftNameStart();            // get default namestart

     POPSTART
     GetDftPopStart();             // get default popstart

     DATETYPE
     GetDftDateType();             // get default datestart

     string
     validateDate(                 // validate a date
     const CHAR* stg);             // date to validate

     string
     relativeDate(                 // calculate relative date
     const CHAR* stg);             // date to calculate

     string
     sinceLastScanDate();          // calculate last scan date

     VOID
     setKey0();                    // set key 0

     VOID
     setKey1();                    // set key 1

     VOID
     setKey3();                    // set key 3

     VOID
     setKey4();                    // set key 4

     VOID
     setKey5();                    // set key 5

     VOID
     setKwdSrchError(              // map keyword error to agent error
     flkwStatus st);               // keyword search status

private:
     LISTORDER      m_listOrder;   // list order
     LISTDIR        m_listDirection; // direction (gt, lt, etc..)
     SEARCHTYPE     m_searchType;  // browse type
     NAMESTART      m_nameStart;   // name search start
     POPSTART       m_popStart;    // popularity search start
     DATETYPE       m_dateType;    // date search start
     INT            m_listCount;   // max items to list
     INT            m_curCount;    // current number of items listed
     INT            m_previous;    // is there anything before the first item?
     bool           m_started;     // did we start generating the list?
     bool           m_moreLow;     // list context - is more low
     bool           m_moreHigh;    // list context - is more high
     bool           m_searchAllLibs; // search across all libs?
     bool           m_searchOnlyUnapproved; // search only for unapproved files
     bool           m_listAll;     // list all files, disregard m_listCount
     bool           m_init;        // are we initialized?
     bool           m_bEndOfLib;   // no more libs to search
     struct fllib   m_fllib;       // file library struct
     string         m_searchStart; // start parameter
     string         m_strHigh;     // high item
     string         m_strLow;      // low item
     string         m_dateStart;   // date search start
     string         m_searchWildcard; // wildcard
     string         m_searchKeywords; // keyword(s)
     string         m_strDesc;     // file description (one line)
     string         m_strDetail;   // file detail
     string         m_strDetailLine; // file detail with <br>'s
     string         m_strDetailRaw; // raw file detail
     string         m_strDetailJS; // js file detail
     FILQUE         m_queue;       // queue of flfile structs (normal libs)
     OSFILQUE       m_OSqueue;     // queue of ffblk structs (os libs)
     filLibMap      m_libMap;      // map of libs to include in search
     LIBMAP::iterator m_iterLib;   // current lib we're on in map
     struct fllib   m_searchLib;   // lib to do search in
     struct flfile  m_ffile;       // file struct
     struct ffblk   m_fb;          // file block struct
     union combo    m_key;         // btrieve key
     CONTEXTSTATE   m_contextState; // determining list context state
     flKeywordSearch m_KwdSearcher; // keyword search object
     bool           m_allDone;     // are we completely done?
     WIN32_FIND_DATA m_findData;   // find data structure, for doing os searching
     HANDLE         m_fh;          // handle to find data info, os searching
     bool           m_popit;       // should we delete the last file from queue
     INT            m_libCount;    // number of libs included in search
};

#endif // __SYNLFILS_H

